/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.ChooseClassAndDoHighlightRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HighlightOverridingMethodsHandler
extends HighlightUsagesHandlerBase<PsiClass> {
    private final PsiElement myTarget;
    private final PsiClass myClass;

    public HighlightOverridingMethodsHandler(Editor editor, PsiFile file, PsiElement target, PsiClass psiClass) {
        super(editor, file);
        this.myTarget = target;
        this.myClass = psiClass;
    }

    @Override
    public List<PsiClass> getTargets() {
        PsiReferenceList list;
        PsiReferenceList psiReferenceList = list = "extends".equals(this.myTarget.getText()) ? this.myClass.getExtendsList() : this.myClass.getImplementsList();
        if (list == null) {
            return Collections.emptyList();
        }
        PsiClassType[] classTypes = list.getReferencedTypes();
        return ChooseClassAndDoHighlightRunnable.resolveClasses(classTypes);
    }

    @Override
    protected void selectTargets(List<PsiClass> targets, final Consumer<List<PsiClass>> selectionConsumer) {
        new ChooseClassAndDoHighlightRunnable(targets, this.myEditor, CodeInsightBundle.message((String)"highlight.overridden.classes.chooser.title", (Object[])new Object[0])){

            protected void selected(PsiClass ... classes) {
                selectionConsumer.consume(Arrays.asList(classes));
            }
        }.run();
    }

    @Override
    public void computeUsages(List<PsiClass> classes) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.highlight.implements");
        for (PsiMethod method : this.myClass.getMethods()) {
            List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
            block1: for (HierarchicalMethodSignature superSignature : superSignatures) {
                PsiClass containingClass = superSignature.getMethod().getContainingClass();
                if (containingClass == null) continue;
                for (PsiClass classToAnalyze : classes) {
                    PsiIdentifier identifier;
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)classToAnalyze, (PsiClass)containingClass, (boolean)true) || (identifier = method.getNameIdentifier()) == null) continue;
                    this.addOccurrence((PsiElement)identifier);
                    continue block1;
                }
            }
        }
        if (this.myReadUsages.isEmpty()) {
            ItemPresentation presentation;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            String name = classes.size() == 1 ? ((presentation = classes.get(0).getPresentation()) != null ? presentation.getPresentableText() : "") : "";
            this.myHintText = CodeInsightBundle.message((String)"no.methods.overriding.0.are.found", (Object[])new Object[]{classes.size(), name});
        } else {
            this.addOccurrence(this.myTarget);
            int methodCount = this.myReadUsages.size() - 1;
            this.myStatusText = CodeInsightBundle.message((String)"status.bar.overridden.methods.highlighted.message", (Object[])new Object[]{methodCount, HighlightUsagesHandler.getShortcutText()});
        }
    }
}

