/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class RemoveInitializerFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoveInitializerFix.class.getName()));

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.unused.assignment.remove.quickfix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RemoveInitializerFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RemoveInitializerFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RemoveInitializerFix", "applyFix"));
        }
        PsiElement psiInitializer = descriptor.getPsiElement();
        if (!(psiInitializer instanceof PsiExpression)) {
            return;
        }
        if (!(psiInitializer.getParent() instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)psiInitializer.getParent();
        this.sideEffectAwareRemove(project, psiInitializer, psiInitializer, variable);
    }

    protected void sideEffectAwareRemove(Project project, PsiElement psiInitializer, PsiElement elementToDelete, PsiVariable variable) {
        if (!FileModificationService.getInstance().prepareFileForWrite(elementToDelete.getContainingFile())) {
            return;
        }
        PsiElement declaration = variable.getParent();
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(psiInitializer, variable, sideEffects);
        int res = 2;
        if (hasSideEffects) {
            hasSideEffects = PsiUtil.isStatement((PsiElement)psiInitializer);
            res = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, FileEditorManager.getInstance((Project)project).getSelectedTextEditor(), hasSideEffects, ((PsiElement)sideEffects.get(0)).getText(), variable.getTypeElement().getText() + " " + variable.getName() + ";<br>" + PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)psiInitializer)));
        }
        try {
            if (res == 2) {
                elementToDelete.delete();
            } else if (res == 1) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                PsiStatement statementFromText = factory.createStatementFromText(psiInitializer.getText() + ";", null);
                PsiElement parent = elementToDelete.getParent();
                if (parent instanceof PsiExpressionStatement) {
                    parent.replace((PsiElement)statementFromText);
                } else {
                    declaration.getParent().addAfter((PsiElement)statementFromText, declaration);
                    elementToDelete.delete();
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RemoveInitializerFix", "getFamilyName"));
        }
        return string;
    }
}

