/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysisData;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.AnalyzerExt;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LiteAnalyzerExt;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class NullableMethodAnalysis {
    static Result<Key, Value> FinalNull = new Final<Key, Value>(Value.Null);
    static Result<Key, Value> FinalBot = new Final<Key, Value>(Value.Bot);
    static BasicValue lNull = new NullableMethodAnalysisData.LabeledNull(0);

    NullableMethodAnalysis() {
    }

    static Result<Key, Value> analyze(MethodNode methodNode, boolean[] origins, boolean jsr) throws AnalyzerException {
        InsnList insns = methodNode.instructions;
        NullableMethodAnalysisData.Constraint[] data = new NullableMethodAnalysisData.Constraint[insns.size()];
        int[] originsMapping = NullableMethodAnalysis.mapOrigins(origins);
        NullableMethodInterpreter interpreter = new NullableMethodInterpreter(insns, origins, originsMapping);
        Frame<V>[] frames = jsr ? new AnalyzerExt(interpreter, data, NullableMethodAnalysisData.Constraint.EMPTY).analyze("this", methodNode) : new LiteAnalyzerExt(interpreter, data, NullableMethodAnalysisData.Constraint.EMPTY).analyze("this", methodNode);
        BasicValue result = BasicValue.REFERENCE_VALUE;
        for (int i = 0; i < frames.length; ++i) {
            Frame frame = frames[i];
            if (frame == null || insns.get(i).getOpcode() != 176) continue;
            BasicValue stackTop = (BasicValue)frame.pop();
            result = NullableMethodAnalysis.combine(result, stackTop, data[i]);
        }
        if (result instanceof NullableMethodAnalysisData.LabeledNull) {
            return FinalNull;
        }
        if (result instanceof NullableMethodAnalysisData.Calls) {
            NullableMethodAnalysisData.Calls calls = (NullableMethodAnalysisData.Calls)result;
            int mergedMappedLabels = calls.mergedLabels;
            if (mergedMappedLabels != 0) {
                HashSet sum = new HashSet();
                Key[] createdKeys = interpreter.keys;
                for (int origin = 0; origin < originsMapping.length; ++origin) {
                    int mappedOrigin = originsMapping[origin];
                    Key createdKey = createdKeys[origin];
                    if (createdKey == null || (mergedMappedLabels & 1 << mappedOrigin) == 0) continue;
                    sum.add(new Product<Key, Value>(Value.Null, Collections.singleton(createdKey)));
                }
                if (!sum.isEmpty()) {
                    return new Pending<Key, Value>(sum);
                }
            }
        }
        return FinalBot;
    }

    private static int[] mapOrigins(boolean[] origins) {
        int[] originsMapping = new int[origins.length];
        int mapped = 0;
        for (int i = 0; i < origins.length; ++i) {
            originsMapping[i] = origins[i] ? mapped++ : -1;
        }
        return originsMapping;
    }

    static BasicValue combine(BasicValue v1, BasicValue v2, NullableMethodAnalysisData.Constraint constraint) {
        if (v1 instanceof NullableMethodAnalysisData.LabeledNull) {
            return lNull;
        }
        if (v2 instanceof NullableMethodAnalysisData.LabeledNull) {
            int v2Origins = ((NullableMethodAnalysisData.LabeledNull)v2).origins;
            int constraintOrigins = constraint.nulls;
            int intersect = v2Origins & constraintOrigins;
            return intersect == v2Origins ? v1 : lNull;
        }
        if (v1 instanceof NullableMethodAnalysisData.Calls) {
            if (v2 instanceof NullableMethodAnalysisData.Calls) {
                NullableMethodAnalysisData.Calls calls1 = (NullableMethodAnalysisData.Calls)v1;
                NullableMethodAnalysisData.Calls calls2 = (NullableMethodAnalysisData.Calls)v2;
                int labels2 = calls2.mergedLabels;
                int aliveLabels2 = labels2 - (labels2 & constraint.calls);
                return new NullableMethodAnalysisData.Calls(calls1.mergedLabels | aliveLabels2);
            }
            return v1;
        }
        if (v2 instanceof NullableMethodAnalysisData.Calls) {
            NullableMethodAnalysisData.Calls calls2 = (NullableMethodAnalysisData.Calls)v2;
            int labels2 = calls2.mergedLabels;
            int aliveLabels2 = labels2 - (labels2 & constraint.calls);
            return new NullableMethodAnalysisData.Calls(aliveLabels2);
        }
        return BasicValue.REFERENCE_VALUE;
    }
}

