/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionRVContentProviderImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalDescriptorsUtil;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.SequentialCleanupTask;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionContextImpl
extends GlobalInspectionContextBase
implements GlobalInspectionContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.GlobalInspectionContextImpl");
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Inspection Results", (String)ToolWindowId.INSPECTION);
    private final NotNullLazyValue<ContentManager> myContentManager;
    private InspectionResultsView myView;
    private Content myContent;
    private AnalysisUIOptions myUIOptions;
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = new TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement>(){

        public RefElement fun(LocalInspectionTool tool, PsiElement elt, GlobalInspectionContext context) {
            PsiNamedElement problemElement = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elt, (Class[])new Class[]{PsiFile.class});
            RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
            if (refElement == null && problemElement != null) {
                refElement = GlobalInspectionContextUtil.retrieveRefElement(elt, context);
            }
            return refElement;
        }
    };
    private final Map<InspectionToolWrapper, InspectionToolPresentation> myPresentationMap;

    public GlobalInspectionContextImpl(@NotNull Project project, @NotNull NotNullLazyValue<ContentManager> contentManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "<init>"));
        }
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "<init>"));
        }
        super(project);
        this.myView = null;
        this.myContent = null;
        this.myPresentationMap = new THashMap();
        this.myUIOptions = AnalysisUIOptions.getInstance(project).copy();
        this.myContentManager = contentManager;
    }

    public ContentManager getContentManager() {
        return (ContentManager)this.myContentManager.getValue();
    }

    public synchronized void addView(@NotNull InspectionResultsView view, String title) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "addView"));
        }
        if (this.myContent != null) {
            return;
        }
        ((ContentManager)this.myContentManager.getValue()).addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent() == GlobalInspectionContextImpl.this.myContent) {
                    if (GlobalInspectionContextImpl.this.myView != null) {
                        GlobalInspectionContextImpl.this.close(false);
                    }
                    GlobalInspectionContextImpl.this.myContent = null;
                }
            }
        });
        this.myView = view;
        this.myContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)view, title, false);
        this.myContent.setDisposer((Disposable)this.myView);
        ContentManager contentManager = this.getContentManager();
        contentManager.addContent(this.myContent);
        contentManager.setSelectedContent(this.myContent);
        ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow(ToolWindowId.INSPECTION).activate(null);
    }

    public void addView(@NotNull InspectionResultsView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "addView"));
        }
        this.addView(view, view.getCurrentProfileName() == null ? InspectionsBundle.message((String)"inspection.results.title", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.results.for.profile.toolwindow.title", (Object[])new Object[]{view.getCurrentProfileName()}));
    }

    @Override
    public void doInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "doInspections"));
        }
        if (this.myContent != null) {
            this.getContentManager().removeContent(this.myContent, true);
        }
        super.doInspections(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchInspectionsOffline(final @NotNull AnalysisScope scope, final @Nullable String outputPath, final boolean runGlobalToolsOnly, final @NotNull List<File> inspectionsResults) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "launchInspectionsOffline"));
        }
        if (inspectionsResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionsResults", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "launchInspectionsOffline"));
        }
        this.cleanupTools();
        this.setCurrentScope(scope);
        DefaultInspectionToolPresentation.setOutputPath(outputPath);
        try {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GlobalInspectionContextImpl.this.performInspectionsWithProgress(scope, runGlobalToolsOnly);
                    String ext = ".xml";
                    HashMap globalTools = new HashMap();
                    for (Map.Entry stringSetEntry : GlobalInspectionContextImpl.this.myTools.entrySet()) {
                        Tools sameTools = (Tools)stringSetEntry.getValue();
                        boolean hasProblems = false;
                        String toolName = (String)stringSetEntry.getKey();
                        if (sameTools != null) {
                            for (ScopeToolState toolDescr : sameTools.getTools()) {
                                InspectionToolWrapper toolWrapper = toolDescr.getTool();
                                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                                    hasProblems = new File(outputPath, toolName + ".xml").exists();
                                    continue;
                                }
                                InspectionToolPresentation presentation = GlobalInspectionContextImpl.this.getPresentation(toolWrapper);
                                presentation.updateContent();
                                if (!presentation.hasReportedProblems()) continue;
                                Element root = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
                                globalTools.put(root, sameTools);
                                LOG.assertTrue(!hasProblems, (Object)toolName);
                                break;
                            }
                        }
                        if (!hasProblems) continue;
                        try {
                            new File(outputPath).mkdirs();
                            File file = new File(outputPath, toolName + ".xml");
                            inspectionsResults.add(file);
                            FileUtil.writeToFile((File)file, (byte[])("</" + InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]) + ">").getBytes("UTF-8"), (boolean)true);
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                    GlobalInspectionContextImpl.this.getRefManager().iterate(new RefVisitor((Map)globalTools){
                        final /* synthetic */ Map val$globalTools;
                        {
                            this.val$globalTools = map;
                        }

                        public void visitElement(@NotNull RefEntity refEntity) {
                            if (refEntity == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$2$1", "visitElement"));
                            }
                            for (Element element : this.val$globalTools.keySet()) {
                                Tools tools = (Tools)this.val$globalTools.get(element);
                                for (ScopeToolState state : tools.getTools()) {
                                    try {
                                        InspectionToolWrapper toolWrapper = state.getTool();
                                        InspectionToolPresentation presentation = GlobalInspectionContextImpl.this.getPresentation(toolWrapper);
                                        presentation.exportResults(element, refEntity);
                                    }
                                    catch (Throwable e) {
                                        LOG.error("Problem when exporting: " + refEntity.getExternalName(), e);
                                    }
                                }
                            }
                        }
                    });
                    for (Element element : globalTools.keySet()) {
                        String toolName = ((Tools)globalTools.get(element)).getShortName();
                        element.setAttribute("is_local_tool", Boolean.toString(false));
                        org.jdom.Document doc = new org.jdom.Document(element);
                        PathMacroManager.getInstance((ComponentManager)GlobalInspectionContextImpl.this.getProject()).collapsePaths(doc.getRootElement());
                        try {
                            new File(outputPath).mkdirs();
                            File file = new File(outputPath, toolName + ".xml");
                            inspectionsResults.add(file);
                            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                            try {
                                JDOMUtil.writeDocument((org.jdom.Document)doc, (Writer)writer, (String)"\n");
                            }
                            finally {
                                writer.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            });
        }
        finally {
            DefaultInspectionToolPresentation.setOutputPath(null);
        }
    }

    public void ignoreElement(@NotNull InspectionProfileEntry tool, PsiElement element) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "ignoreElement"));
        }
        RefElement refElement = this.getRefManager().getReference(element);
        Tools tools = (Tools)this.myTools.get(tool.getShortName());
        if (tools != null) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                this.ignoreElementRecursively(toolWrapper, (RefEntity)refElement);
            }
        }
    }

    public InspectionResultsView getView() {
        return this.myView;
    }

    private void ignoreElementRecursively(@NotNull InspectionToolWrapper toolWrapper, RefEntity refElement) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "ignoreElementRecursively"));
        }
        if (refElement != null) {
            InspectionToolPresentation presentation = this.getPresentation(toolWrapper);
            presentation.ignoreCurrentElement(refElement);
            List children = refElement.getChildren();
            if (children != null) {
                for (RefEntity child : children) {
                    this.ignoreElementRecursively(toolWrapper, child);
                }
            }
        }
    }

    public AnalysisUIOptions getUIOptions() {
        return this.myUIOptions;
    }

    public void setSplitterProportion(float proportion) {
        this.myUIOptions.SPLITTER_PROPORTION = proportion;
    }

    public ToggleAction createToggleAutoscrollAction() {
        return this.myUIOptions.getAutoScrollToSourceHandler().createToggleAction();
    }

    @Override
    protected void launchInspections(@NotNull AnalysisScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "launchInspections"));
        }
        this.myUIOptions = AnalysisUIOptions.getInstance(this.getProject()).copy();
        this.myView = new InspectionResultsView(this.getProject(), this.getCurrentProfile(), scope, this, new InspectionRVContentProviderImpl(this.getProject()));
        super.launchInspections(scope);
    }

    @Override
    protected PerformInBackgroundOption createOption() {
        return new PerformAnalysisInBackgroundOption(this.getProject());
    }

    @Override
    protected void notifyInspectionsFinished() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                LOG.info("Code inspection finished");
                if (GlobalInspectionContextImpl.this.myView != null) {
                    if (!GlobalInspectionContextImpl.this.myView.update() && !GlobalInspectionContextImpl.this.getUIOptions().SHOW_ONLY_DIFF) {
                        NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[0]), MessageType.INFO).notify(GlobalInspectionContextImpl.this.getProject());
                        GlobalInspectionContextImpl.this.close(true);
                    } else {
                        GlobalInspectionContextImpl.this.addView(GlobalInspectionContextImpl.this.myView);
                    }
                }
            }
        });
    }

    @Override
    protected void runTools(@NotNull AnalysisScope scope, boolean runGlobalToolsOnly) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "runTools"));
        }
        InspectionManagerEx inspectionManager = (InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject());
        ArrayList<Tools> globalTools = new ArrayList<Tools>();
        ArrayList<Tools> localTools = new ArrayList<Tools>();
        ArrayList<Tools> globalSimpleTools = new ArrayList<Tools>();
        this.initializeTools(globalTools, localTools, globalSimpleTools);
        this.appendPairedInspectionsForUnfairTools(globalTools, globalSimpleTools, localTools);
        ((RefManagerImpl)this.getRefManager()).initializeAnnotators();
        this.runGlobalTools(scope, inspectionManager, globalTools);
        if (runGlobalToolsOnly) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        THashSet localScopeFiles = scope.toSearchScope() instanceof LocalSearchScope ? new THashSet() : null;
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            tool.inspectionStarted((InspectionManager)inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)this.getPresentation(toolWrapper));
        }
        final boolean headlessEnvironment = ApplicationManager.getApplication().isHeadlessEnvironment();
        Map<String, InspectionToolWrapper> map = GlobalInspectionContextImpl.getInspectionWrappersMap(localTools);
        scope.accept(new PsiElementVisitor((Set)localScopeFiles, psiManager, localTools, inspectionManager, globalSimpleTools, map){
            final /* synthetic */ Set val$localScopeFiles;
            final /* synthetic */ PsiManager val$psiManager;
            final /* synthetic */ List val$localTools;
            final /* synthetic */ InspectionManagerEx val$inspectionManager;
            final /* synthetic */ List val$globalSimpleTools;
            final /* synthetic */ Map val$map;
            {
                this.val$localScopeFiles = set;
                this.val$psiManager = psiManager;
                this.val$localTools = list;
                this.val$inspectionManager = inspectionManagerEx;
                this.val$globalSimpleTools = list2;
                this.val$map = map;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitFile(final PsiFile file) {
                Document document;
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                if (GlobalInspectionContextImpl.this.myView == null && !headlessEnvironment) {
                    throw new ProcessCanceledException();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running local inspections on " + virtualFile.getPath());
                }
                String url = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)GlobalInspectionContextImpl.this.getProject(), (boolean)true, (boolean)false);
                GlobalInspectionContextImpl.this.incrementJobDoneAmount(GlobalInspectionContextImpl.this.getStdJobDescriptors().LOCAL_ANALYSIS, url);
                if (SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile)) {
                    return;
                }
                if (this.val$localScopeFiles != null && !this.val$localScopeFiles.add(virtualFile)) {
                    return;
                }
                FileViewProvider viewProvider = this.val$psiManager.findViewProvider(virtualFile);
                Document document2 = document = viewProvider == null ? null : viewProvider.getDocument();
                if (document == null || GlobalInspectionContextImpl.isBinary(file)) {
                    return;
                }
                LocalInspectionsPass pass = new LocalInspectionsPass(file, document, 0, file.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty());
                try {
                    List lTools = GlobalInspectionContextImpl.getWrappersFromTools(this.val$localTools, file);
                    pass.doInspectInBatch(GlobalInspectionContextImpl.this, this.val$inspectionManager, lTools);
                    JobLauncher.getInstance().invokeConcurrentlyUnderProgress(this.val$globalSimpleTools, GlobalInspectionContextImpl.this.myProgressIndicator, false, new Processor<Tools>(){

                        public boolean process(Tools tools) {
                            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
                            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
                            ProblemsHolder problemsHolder = new ProblemsHolder((InspectionManager)val$inspectionManager, file, false);
                            ProblemDescriptionsProcessor problemDescriptionProcessor = GlobalInspectionContextImpl.this.getProblemDescriptionProcessor(toolWrapper, val$map);
                            tool.checkFile(file, (InspectionManager)val$inspectionManager, problemsHolder, (GlobalInspectionContext)GlobalInspectionContextImpl.this, problemDescriptionProcessor);
                            InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(toolWrapper);
                            LocalDescriptorsUtil.addProblemDescriptors(problemsHolder.getResults(), false, GlobalInspectionContextImpl.this, null, (TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement>)CONVERT, toolPresentation);
                            return true;
                        }
                    });
                }
                catch (ProcessCanceledException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        throw e;
                    }
                    LOG.error("In file: " + file, cause);
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("In file: " + file, e);
                }
                finally {
                    InjectedLanguageManager.getInstance((Project)GlobalInspectionContextImpl.this.getProject()).dropFileCaches(file);
                }
            }
        });
        for (Tools tools : globalSimpleTools) {
            GlobalInspectionToolWrapper toolWrapper = (GlobalInspectionToolWrapper)tools.getTool();
            GlobalSimpleInspectionTool tool = (GlobalSimpleInspectionTool)toolWrapper.getTool();
            ProblemDescriptionsProcessor problemDescriptionProcessor = this.getProblemDescriptionProcessor(toolWrapper, map);
            tool.inspectionFinished((InspectionManager)inspectionManager, (GlobalInspectionContext)this, problemDescriptionProcessor);
        }
    }

    private void runGlobalTools(@NotNull AnalysisScope scope, @NotNull InspectionManagerEx inspectionManager, @NotNull List<Tools> globalTools) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "runGlobalTools"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "runGlobalTools"));
        }
        if (globalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalTools", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "runGlobalTools"));
        }
        ArrayList<InspectionToolWrapper> needRepeatSearchRequest = new ArrayList<InspectionToolWrapper>();
        boolean surelyNoExternalUsages = scope.getScopeType() == 1;
        for (Tools tools : globalTools) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                GlobalInspectionTool tool = (GlobalInspectionTool)toolWrapper.getTool();
                InspectionToolPresentation toolPresentation = this.getPresentation(toolWrapper);
                try {
                    if (tool.isGraphNeeded()) {
                        try {
                            ((RefManagerImpl)this.getRefManager()).findAllDeclarations();
                        }
                        catch (Throwable e) {
                            this.getStdJobDescriptors().BUILD_GRAPH.setDoneAmount(0);
                            throw e;
                        }
                    }
                    tool.runInspection(scope, (InspectionManager)inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation);
                    if (surelyNoExternalUsages || !tool.queryExternalUsagesRequests((InspectionManager)inspectionManager, (GlobalInspectionContext)this, (ProblemDescriptionsProcessor)toolPresentation)) continue;
                    needRepeatSearchRequest.add(toolWrapper);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        for (GlobalInspectionContextExtension extension : this.myExtensions.values()) {
            try {
                extension.performPostRunActivities(needRepeatSearchRequest, (GlobalInspectionContext)this);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void appendPairedInspectionsForUnfairTools(@NotNull List<Tools> globalTools, @NotNull List<Tools> globalSimpleTools, @NotNull List<Tools> localTools) {
        Tools[] larray;
        if (globalTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalTools", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "appendPairedInspectionsForUnfairTools"));
        }
        if (globalSimpleTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalSimpleTools", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "appendPairedInspectionsForUnfairTools"));
        }
        if (localTools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localTools", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "appendPairedInspectionsForUnfairTools"));
        }
        for (Tools tool : larray = localTools.toArray(new Tools[localTools.size()])) {
            InspectionToolWrapper batchInspection;
            LocalInspectionToolWrapper toolWrapper = (LocalInspectionToolWrapper)tool.getTool();
            LocalInspectionTool localTool = (LocalInspectionTool)toolWrapper.getTool();
            if (!(localTool instanceof PairedUnfairLocalInspectionTool)) continue;
            String batchShortName = ((PairedUnfairLocalInspectionTool)localTool).getInspectionForBatchShortName();
            InspectionProfile currentProfile = this.getCurrentProfile();
            InspectionToolWrapper inspectionToolWrapper = batchInspection = currentProfile == null ? null : currentProfile.getInspectionTool(batchShortName, this.getProject());
            if (batchInspection == null || this.myTools.containsKey(batchShortName)) continue;
            InspectionProfileEntry batchTool = batchInspection.getTool();
            ToolsImpl newTool = new ToolsImpl(batchInspection, batchInspection.getDefaultLevel(), true);
            if (batchTool instanceof LocalInspectionTool) {
                localTools.add(newTool);
            } else if (batchTool instanceof GlobalSimpleInspectionTool) {
                globalSimpleTools.add(newTool);
            } else if (batchTool instanceof GlobalInspectionTool) {
                globalTools.add(newTool);
            } else {
                throw new AssertionError(batchTool);
            }
            this.myTools.put(batchShortName, newTool);
            batchInspection.initialize((GlobalInspectionContext)this);
        }
    }

    private static List<LocalInspectionToolWrapper> getWrappersFromTools(List<Tools> localTools, PsiFile file) {
        ArrayList<LocalInspectionToolWrapper> lTools = new ArrayList<LocalInspectionToolWrapper>();
        for (Tools tool : localTools) {
            LocalInspectionToolWrapper enabledTool = (LocalInspectionToolWrapper)tool.getEnabledTool((PsiElement)file);
            if (enabledTool == null) continue;
            lTools.add(enabledTool);
        }
        return lTools;
    }

    @NotNull
    private ProblemDescriptionsProcessor getProblemDescriptionProcessor(final @NotNull GlobalInspectionToolWrapper toolWrapper, final @NotNull Map<String, InspectionToolWrapper> wrappersMap) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "getProblemDescriptionProcessor"));
        }
        if (wrappersMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrappersMap", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "getProblemDescriptionProcessor"));
        }
        ProblemDescriptionsProcessor problemDescriptionsProcessor = new ProblemDescriptionsProcessor(){

            @Nullable
            public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$5", "getDescriptions"));
                }
                return new CommonProblemDescriptor[0];
            }

            public void ignoreElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$5", "ignoreElement"));
                }
            }

            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                if (commonProblemDescriptors == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonProblemDescriptors", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$5", "addProblemElement"));
                }
                for (CommonProblemDescriptor problemDescriptor : commonProblemDescriptors) {
                    GlobalInspectionToolWrapper targetWrapper;
                    if (!(problemDescriptor instanceof ProblemDescriptor)) continue;
                    ProblemGroup problemGroup = ((ProblemDescriptor)problemDescriptor).getProblemGroup();
                    GlobalInspectionToolWrapper globalInspectionToolWrapper = targetWrapper = problemGroup == null ? toolWrapper : (InspectionToolWrapper)wrappersMap.get(problemGroup.getProblemName());
                    if (targetWrapper == null) continue;
                    InspectionToolPresentation toolPresentation = GlobalInspectionContextImpl.this.getPresentation(targetWrapper);
                    toolPresentation.addProblemElement(refEntity, new CommonProblemDescriptor[]{problemDescriptor});
                }
            }

            public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$5", "getElement"));
                }
                return null;
            }
        };
        if (problemDescriptionsProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "getProblemDescriptionProcessor"));
        }
        return problemDescriptionsProcessor;
    }

    @NotNull
    private static Map<String, InspectionToolWrapper> getInspectionWrappersMap(@NotNull List<Tools> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "getInspectionWrappersMap"));
        }
        HashMap name2Inspection = new HashMap(tools.size());
        for (Tools tool : tools) {
            InspectionToolWrapper toolWrapper = tool.getTool();
            name2Inspection.put(toolWrapper.getShortName(), toolWrapper);
        }
        HashMap hashMap = name2Inspection;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "getInspectionWrappersMap"));
        }
        return hashMap;
    }

    @Override
    public void close(boolean noSuspisiousCodeFound) {
        ContentManager contentManager;
        if (!noSuspisiousCodeFound && (this.myView == null || this.myView.isRerun())) {
            return;
        }
        AnalysisUIOptions.getInstance(this.getProject()).save(this.myUIOptions);
        if (this.myContent != null && (contentManager = this.getContentManager()) != null) {
            contentManager.removeContent(this.myContent, true);
        }
        this.myView = null;
        super.close(noSuspisiousCodeFound);
    }

    @Override
    public void cleanup() {
        ((InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject())).closeRunningContext(this);
        for (Tools tools : this.myTools.values()) {
            for (ScopeToolState state : tools.getTools()) {
                InspectionToolWrapper toolWrapper = state.getTool();
                this.getPresentation(toolWrapper).finalCleanup();
            }
        }
        super.cleanup();
    }

    public void refreshViews() {
        if (this.myView != null) {
            this.myView.updateView(false);
        }
    }

    @NotNull
    public InspectionToolPresentation getPresentation(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "getPresentation"));
        }
        InspectionToolPresentation presentation = this.myPresentationMap.get(toolWrapper);
        if (presentation == null) {
            String presentationClass = StringUtil.notNullize((String)(toolWrapper.myEP == null ? null : toolWrapper.myEP.presentation), (String)DefaultInspectionToolPresentation.class.getName());
            try {
                presentation = (InspectionToolPresentation)Class.forName(presentationClass).getConstructor(InspectionToolWrapper.class, GlobalInspectionContextImpl.class).newInstance(new Object[]{toolWrapper, this});
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            this.myPresentationMap.put(toolWrapper, presentation);
        }
        InspectionToolPresentation inspectionToolPresentation = presentation;
        if (inspectionToolPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl", "getPresentation"));
        }
        return inspectionToolPresentation;
    }

    @Override
    public void codeCleanup(final Project project, final AnalysisScope scope, final InspectionProfile profile, final String commandName, final Runnable postRunnable, boolean modal) {
        Object task = modal ? new Task.Modal(project, "Inspect code...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$7", "run"));
                }
                GlobalInspectionContextImpl.this.cleanup(scope, profile, project, postRunnable, commandName);
            }
        } : new Task.Backgroundable(project, "Inspect code...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInspection/ex/GlobalInspectionContextImpl$8", "run"));
                }
                GlobalInspectionContextImpl.this.cleanup(scope, profile, project, postRunnable, commandName);
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private void cleanup(AnalysisScope scope, final InspectionProfile profile, final Project project, final Runnable postRunnable, final String commandName) {
        PsiElement[] elements;
        final int fileCount = scope.getFileCount();
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        final ArrayList lTools = new ArrayList();
        final LinkedHashMap results = new LinkedHashMap();
        final SearchScope searchScope = scope.toSearchScope();
        final TextRange range = searchScope instanceof LocalSearchScope ? ((elements = ((LocalSearchScope)searchScope).getScope()).length == 1 ? elements[0].getTextRange() : null) : null;
        scope.accept(new PsiElementVisitor(){
            private int myCount = 0;

            public void visitFile(PsiFile file) {
                if (progressIndicator != null) {
                    progressIndicator.setFraction((double)(++this.myCount) / (double)fileCount);
                }
                if (GlobalInspectionContextImpl.isBinary(file)) {
                    return;
                }
                for (Tools tools : profile.getAllEnabledInspectionTools(project)) {
                    InspectionToolWrapper tool;
                    if (!(tools.getTool().getTool() instanceof CleanupLocalInspectionTool) || !((tool = tools.getEnabledTool((PsiElement)file)) instanceof LocalInspectionToolWrapper)) continue;
                    lTools.add((LocalInspectionToolWrapper)tool);
                    tool.initialize((GlobalInspectionContext)GlobalInspectionContextImpl.this);
                }
                if (!lTools.isEmpty()) {
                    final LocalInspectionsPass pass = new LocalInspectionsPass(file, PsiDocumentManager.getInstance((Project)project).getDocument(file), range != null ? range.getStartOffset() : 0, range != null ? range.getEndOffset() : file.getTextLength(), LocalInspectionsPass.EMPTY_PRIORITY_RANGE, true, HighlightInfoProcessor.getEmpty());
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            pass.doInspectInBatch(GlobalInspectionContextImpl.this, (InspectionManagerEx)InspectionManager.getInstance((Project)project), lTools);
                        }
                    };
                    ApplicationManager.getApplication().runReadAction(runnable);
                    List<HighlightInfo> infos = pass.getInfos();
                    if (searchScope instanceof LocalSearchScope) {
                        Iterator<HighlightInfo> iterator = infos.iterator();
                        while (iterator.hasNext()) {
                            HighlightInfo info = iterator.next();
                            TextRange infoRange = new TextRange(info.getStartOffset(), info.getEndOffset());
                            if (((LocalSearchScope)searchScope).containsRange(file, infoRange)) continue;
                            iterator.remove();
                        }
                    }
                    if (!infos.isEmpty()) {
                        results.put(file, infos);
                    }
                }
            }
        });
        if (results.isEmpty()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (commandName != null) {
                        NOTIFICATION_GROUP.createNotification(InspectionsBundle.message((String)"inspection.no.problems.message", (Object[])new Object[0]), MessageType.INFO).notify(GlobalInspectionContextImpl.this.getProject());
                    }
                    if (postRunnable != null) {
                        postRunnable.run();
                    }
                }
            });
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(results.keySet())) {
                    return;
                }
                final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, "Code Cleanup", true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(new SequentialCleanupTask(project, results, progressTask));
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        if (commandName != null) {
                            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                        }
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                ProgressManager.getInstance().run((Task)progressTask);
                            }
                        });
                        if (postRunnable != null) {
                            ApplicationManager.getApplication().invokeLater(postRunnable);
                        }
                    }
                }, commandName, null);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    private static boolean isBinary(PsiFile file) {
        return file instanceof PsiBinaryFile || file.getFileType().isBinary();
    }
}

