/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ThrownExceptionValueDescriptorImpl
extends ValueDescriptorImpl {
    @NotNull
    private final ObjectReference myExceptionObj;

    public ThrownExceptionValueDescriptorImpl(Project project, @NotNull ObjectReference exceptionObj) {
        if (exceptionObj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionObj", "com/intellij/debugger/ui/impl/watch/ThrownExceptionValueDescriptorImpl", "<init>"));
        }
        super(project);
        this.myExceptionObj = exceptionObj;
        this.setRenderer(DebugProcessImpl.getDefaultRenderer(exceptionObj));
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.myExceptionObj;
    }

    @Override
    public String getName() {
        return "Exception";
    }

    @Override
    @NotNull
    public Type getType() {
        ReferenceType referenceType = this.myExceptionObj.referenceType();
        if (referenceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/watch/ThrownExceptionValueDescriptorImpl", "getType"));
        }
        return referenceType;
    }

    @Override
    public String calcValueName() {
        return this.getName();
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        throw new EvaluateException("Evaluation not supported for thrown exception object");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

