/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryUtil {
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = new Comparator<Repository>(){

        @Override
        public int compare(Repository o1, Repository o2) {
            return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
        }
    };
    private static final Logger LOGGER = Logger.getInstance(RepositoryUtil.class);
    private static final int IO_RETRIES = 3;

    public static void assertFileExists(File file, String message) {
        if (!file.exists()) {
            throw new RepoStateException(message);
        }
    }

    @NotNull
    public static String tryLoadFile(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/repo/RepositoryUtil", "tryLoadFile"));
        }
        String string = RepositoryUtil.tryOrThrow(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file).trim());
            }
        }, file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/repo/RepositoryUtil", "tryLoadFile"));
        }
        return string;
    }

    public static <T> T tryOrThrow(Callable<T> actionToTry, File fileToLoad) {
        IOException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOGGER.info("IOException while loading " + fileToLoad, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + fileToLoad, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + fileToLoad, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDir", "com/intellij/dvcs/repo/RepositoryUtil", "visitVcsDirVfs"));
        }
        if (subDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDirs", "com/intellij/dvcs/repo/RepositoryUtil", "visitVcsDirVfs"));
        }
        vcsDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir);
            RepositoryUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)Processor.TRUE);
        }
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<T> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/repo/RepositoryUtil", "sortRepositories"));
        }
        List repos = ContainerUtil.filter(repositories, (Condition)new Condition<T>(){

            public boolean value(T t) {
                return t.getRoot().isValid();
            }
        });
        Collections.sort(repos, REPOSITORY_COMPARATOR);
        return repos;
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/repo/RepositoryUtil", "getVcsRootForLibraryFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/repo/RepositoryUtil", "getVcsRootForLibraryFile"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        VirtualFile root = vcsManager.getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file));
        if (root != null) {
            LOGGER.debug("Found root for zip/jar file: " + root);
            return root;
        }
        List entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
        HashSet<VirtualFile> libraryRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry : entries) {
            VirtualFile moduleRoot;
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry) || (moduleRoot = vcsManager.getVcsRootFor(entry.getOwnerModule().getModuleFile())) == null) continue;
            libraryRoots.add(moduleRoot);
        }
        if (libraryRoots.size() == 0) {
            LOGGER.debug("No library roots");
            return null;
        }
        Iterator libIterator = libraryRoots.iterator();
        VirtualFile topLibraryRoot = (VirtualFile)libIterator.next();
        while (libIterator.hasNext()) {
            VirtualFile libRoot = (VirtualFile)libIterator.next();
            if (!VfsUtilCore.isAncestor((VirtualFile)libRoot, (VirtualFile)topLibraryRoot, (boolean)true)) continue;
            topLibraryRoot = libRoot;
        }
        LOGGER.debug("Several library roots, returning " + topLibraryRoot);
        return topLibraryRoot;
    }

    @Nullable
    public static VirtualFile getVcsRoot(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/repo/RepositoryUtil", "getVcsRoot"));
        }
        VirtualFile root = null;
        if (file != null && (root = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file)) == null) {
            LOGGER.debug("Cannot get root by file. Trying with get by library: " + file);
            root = RepositoryUtil.getVcsRootForLibraryFile(project, file);
        }
        return root;
    }

    public static class Updater
    implements Consumer<Object> {
        private final Repository myRepository;

        public Updater(Repository repository) {
            this.myRepository = repository;
        }

        public void consume(Object dummy) {
            if (!Disposer.isDisposed((Disposable)this.myRepository)) {
                this.myRepository.update();
            }
        }
    }
}

