/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.RepositoryContentHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.HttpRequests;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.helpers.DefaultHandler;

public class RepositoryHelper {
    @NonNls
    public static final String PLUGIN_LIST_FILE = "availables.xml";

    public static List<IdeaPluginDescriptor> loadPluginsFromRepository(@Nullable ProgressIndicator indicator) throws Exception {
        return RepositoryHelper.loadPluginsFromRepository(indicator, null);
    }

    public static List<IdeaPluginDescriptor> loadPluginsFromRepository(final @Nullable ProgressIndicator indicator, @Nullable BuildNumber buildnumber) throws Exception {
        File pluginListFile;
        final ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String url = appInfo.getPluginsListUrl() + "?build=" + (buildnumber != null ? buildnumber.asString() : appInfo.getApiVersion());
        if (indicator != null) {
            indicator.setText2(IdeBundle.message((String)"progress.connecting.to.plugin.manager", (Object[])new Object[]{appInfo.getPluginManagerUrl()}));
        }
        if ((pluginListFile = new File(PathManager.getPluginsPath(), PLUGIN_LIST_FILE)).length() > 0L) {
            try {
                url = url + "&crc32=" + Files.hash((File)pluginListFile, (HashFunction)Hashing.crc32()).toString();
            }
            catch (NoSuchMethodError e) {
                String guavaPath = PathUtil.getJarPathForClass(Hashing.class);
                throw new RuntimeException(guavaPath, e);
            }
        }
        return HttpRequests.request(url).get(new ThrowableConvertor<URLConnection, List<IdeaPluginDescriptor>, Exception>(){

            public List<IdeaPluginDescriptor> convert(URLConnection connection) throws Exception {
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(IdeBundle.message((String)"progress.waiting.for.reply.from.plugin.manager", (Object[])new Object[]{appInfo.getPluginManagerUrl()}));
                }
                if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 304) {
                    return RepositoryHelper.loadPluginList(pluginListFile);
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(IdeBundle.message((String)"progress.downloading.list.of.plugins", (Object[])new Object[0]));
                }
                return RepositoryHelper.readPluginsStream(connection, indicator, RepositoryHelper.PLUGIN_LIST_FILE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<IdeaPluginDescriptor> readPluginsStream(@NotNull URLConnection connection, @Nullable ProgressIndicator indicator, @NotNull String file) throws Exception {
        File localFile;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/ide/plugins/RepositoryHelper", "readPluginsStream"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/RepositoryHelper", "readPluginsStream"));
        }
        InputStream input = HttpRequests.getInputStream(connection);
        try {
            localFile = RepositoryHelper.createLocalPluginsDescriptions(file);
            FileOutputStream output = new FileOutputStream(localFile);
            try {
                NetUtils.copyStreamContent((ProgressIndicator)indicator, (InputStream)input, (OutputStream)output, (int)connection.getContentLength());
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        finally {
            input.close();
        }
        return RepositoryHelper.loadPluginList(localFile);
    }

    private static List<IdeaPluginDescriptor> loadPluginList(File file) throws Exception {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        RepositoryContentHandler handler = new RepositoryContentHandler();
        parser.parse(file, (DefaultHandler)handler);
        return handler.getPluginsList();
    }

    @NotNull
    private static File createLocalPluginsDescriptions(@NotNull String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/plugins/RepositoryHelper", "createLocalPluginsDescriptions"));
        }
        File basePath = new File(PathManager.getPluginsPath());
        if (!basePath.isDirectory() && !basePath.mkdirs()) {
            throw new IOException("Cannot create directory: " + basePath);
        }
        File temp = new File(basePath, file);
        if (temp.exists()) {
            FileUtil.delete((File)temp);
        } else {
            FileUtilRt.createParentDirs((File)temp);
        }
        File file2 = temp;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/RepositoryHelper", "createLocalPluginsDescriptions"));
        }
        return file2;
    }

    public static String getDownloadUrl() {
        return ApplicationInfoImpl.getShadowInstance().getPluginsDownloadUrl() + "?action=download&id=";
    }
}

