/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInfoUsageCollector
extends UsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@Nullable Project project) throws CollectUsagesException {
        HashSet<UsageDescriptor> set = new HashSet<UsageDescriptor>();
        UiInfoUsageCollector.add(set, "Nav Bar visible", UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Nav Bar floating", UiInfoUsageCollector.navbar() ? 0 : 1);
        UiInfoUsageCollector.add(set, "Toolbar visible", UiInfoUsageCollector.toolbar() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Toolbar hidden", UiInfoUsageCollector.toolbar() ? 0 : 1);
        UiInfoUsageCollector.add(set, "Toolbar + NavBar", !UiInfoUsageCollector.toolbar() && UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Toolbar and NavBar hidden", !UiInfoUsageCollector.toolbar() && !UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Status bar visible", UiInfoUsageCollector.status() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Status bar hidden", UiInfoUsageCollector.status() ? 0 : 1);
        UiInfoUsageCollector.add(set, "Tool Window buttons visible", UiInfoUsageCollector.stripes() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Tool Window buttons hidden", UiInfoUsageCollector.stripes() ? 0 : 1);
        UiInfoUsageCollector.add(set, "Recent Files = 15", UiInfoUsageCollector.recent() == 15 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Recent Files (15, 30]", 15 < UiInfoUsageCollector.recent() && UiInfoUsageCollector.recent() < 31 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Recent Files (30, 50]", 30 < UiInfoUsageCollector.recent() && UiInfoUsageCollector.recent() < 51 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Recent Files > 50", 50 < UiInfoUsageCollector.recent() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Block cursor", EditorSettingsExternalizable.getInstance().isBlockCursor() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Line Numbers", EditorSettingsExternalizable.getInstance().isLineNumbersShown() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Soft Wraps", EditorSettingsExternalizable.getInstance().isUseSoftWraps() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Tabs None", UiInfoUsageCollector.tabPlace() == 0 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Tabs Top", UiInfoUsageCollector.tabPlace() == 1 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Tabs Bottom", UiInfoUsageCollector.tabPlace() == 3 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Tabs Left", UiInfoUsageCollector.tabPlace() == 2 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Tabs Right", UiInfoUsageCollector.tabPlace() == 4 ? 1 : 0);
        UiInfoUsageCollector.add(set, "Retina", UIUtil.isRetina() ? 1 : 0);
        UiInfoUsageCollector.add(set, "Show tips on startup", GeneralSettings.getInstance().showTipsOnStartup() ? 1 : 0);
        HashSet<UsageDescriptor> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/UiInfoUsageCollector", "getUsages"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("UI Features");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/UiInfoUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    private static void add(HashSet<UsageDescriptor> set, String key, int value) {
        set.add(new UsageDescriptor(key, value));
    }

    private static int tabPlace() {
        return UISettings.getInstance().EDITOR_TAB_PLACEMENT;
    }

    private static int recent() {
        return UISettings.getInstance().RECENT_FILES_LIMIT;
    }

    private static boolean stripes() {
        return UISettings.getInstance().HIDE_TOOL_STRIPES;
    }

    private static boolean status() {
        return UISettings.getInstance().SHOW_STATUS_BAR;
    }

    private static boolean toolbar() {
        return UISettings.getInstance().SHOW_MAIN_TOOLBAR;
    }

    private static boolean navbar() {
        return UISettings.getInstance().SHOW_NAVIGATION_BAR;
    }
}

