/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.ideSettings;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeSettingsDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeSettingsStatisticsService;
import com.intellij.internal.statistic.ideSettings.IdeSettingsStatisticsUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeSettingsUsagesCollector
extends AbstractApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/ideSettings/IdeSettingsUsagesCollector", "getProjectUsages"));
        }
        HashSet usageDescriptors = new HashSet();
        for (Pair<Object, IdeSettingsDescriptor> provider : IdeSettingsUsagesCollector.getProviders(project, true)) {
            usageDescriptors.addAll(IdeSettingsStatisticsUtils.getUsages((IdeSettingsDescriptor)provider.second, provider.first));
        }
        HashSet hashSet = usageDescriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeSettingsUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<Pair<Object, IdeSettingsDescriptor>> getProviders(@Nullable Project project, boolean projectComponent) {
        HashSet pairs = new HashSet();
        for (IdeSettingsDescriptor descriptor : IdeSettingsStatisticsService.getInstance().getSettingDescriptors()) {
            Pair<Object, IdeSettingsDescriptor> pair = IdeSettingsUsagesCollector.getProvider(project, descriptor, projectComponent);
            if (pair == null) continue;
            pairs.add(pair);
        }
        HashSet hashSet = pairs;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeSettingsUsagesCollector", "getProviders"));
        }
        return hashSet;
    }

    @Nullable
    private static Pair<Object, IdeSettingsDescriptor> getProvider(@Nullable Project project, @NotNull IdeSettingsDescriptor descriptor, boolean projectComponent) {
        Object projectProvider;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/internal/statistic/ideSettings/IdeSettingsUsagesCollector", "getProvider"));
        }
        Object applicationProvider = IdeSettingsStatisticsUtils.getApplicationProvider(descriptor.myProviderName);
        if (applicationProvider != null) {
            return projectComponent ? null : Pair.create((Object)applicationProvider, (Object)descriptor);
        }
        if (project != null && (projectProvider = IdeSettingsStatisticsUtils.getProjectProvider(project, descriptor.myProviderName)) != null) {
            return projectComponent ? Pair.create((Object)projectProvider, (Object)descriptor) : null;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getApplicationUsages() {
        HashSet applicationUsageDescriptors = new HashSet();
        applicationUsageDescriptors.addAll(super.getApplicationUsages());
        for (Pair<Object, IdeSettingsDescriptor> provider : IdeSettingsUsagesCollector.getProviders(null, false)) {
            applicationUsageDescriptors.addAll(IdeSettingsStatisticsUtils.getUsages((IdeSettingsDescriptor)provider.second, provider.first));
        }
        HashSet hashSet = applicationUsageDescriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeSettingsUsagesCollector", "getApplicationUsages"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = IdeSettingsStatisticsUtils.GROUP;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/ideSettings/IdeSettingsUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

