/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private final MyVirtualFile myRoot = new MyVirtualFile("", null);
    public static final String PROTOCOL = "mock";

    @NotNull
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockVirtualFileSystem", "findFileByPath"));
        }
        path = path.replace(File.separatorChar, '/');
        if (StringUtil.startsWithChar((CharSequence)(path = path.replace('/', ':')), (char)':')) {
            path = path.substring(1);
        }
        MyVirtualFile file = this.myRoot;
        for (String component : StringUtil.split((String)path, (String)":")) {
            file = file.getOrCreate(component);
        }
        MyVirtualFile myVirtualFile = file;
        if (myVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem", "findFileByPath"));
        }
        return myVirtualFile;
    }

    @NotNull
    public VirtualFile getRoot() {
        MyVirtualFile myVirtualFile = this.myRoot;
        if (myVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem", "getRoot"));
        }
        return myVirtualFile;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    public void refresh(boolean asynchronous) {
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/mock/MockVirtualFileSystem", "deleteFile"));
        }
        throw new UnsupportedOperationException();
    }

    public void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/mock/MockVirtualFileSystem", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/mock/MockVirtualFileSystem", "moveFile"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/mock/MockVirtualFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/mock/MockVirtualFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/mock/MockVirtualFileSystem", "copyFile"));
        }
        throw new UnsupportedOperationException();
    }

    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/mock/MockVirtualFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/mock/MockVirtualFileSystem", "renameFile"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/mock/MockVirtualFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/mock/MockVirtualFileSystem", "createChildFile"));
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/mock/MockVirtualFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/mock/MockVirtualFileSystem", "createChildDirectory"));
        }
        throw new IOException();
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/mock/MockVirtualFileSystem", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    public class MyVirtualFile
    extends LightVirtualFile {
        private final Map<String, MyVirtualFile> myChildren;
        private final MyVirtualFile myParent;

        public MyVirtualFile(@Nullable String name, MyVirtualFile parent) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "<init>"));
            }
            super(name);
            this.myChildren = new THashMap();
            this.myParent = parent;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            MockVirtualFileSystem mockVirtualFileSystem = MockVirtualFileSystem.this;
            if (mockVirtualFileSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getFileSystem"));
            }
            return mockVirtualFileSystem;
        }

        @NotNull
        public MyVirtualFile getOrCreate(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getOrCreate"));
            }
            MyVirtualFile file = this.myChildren.get(name);
            if (file == null) {
                file = new MyVirtualFile(name, this);
                this.myChildren.put(name, file);
            }
            MyVirtualFile myVirtualFile = file;
            if (myVirtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getOrCreate"));
            }
            return myVirtualFile;
        }

        public boolean isDirectory() {
            return !this.myChildren.isEmpty();
        }

        @NotNull
        public String getPath() {
            MyVirtualFile parent = this.getParent();
            String string = parent == null ? this.getName() : parent.getPath() + "/" + this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockVirtualFileSystem$MyVirtualFile", "getPath"));
            }
            return string;
        }

        public MyVirtualFile getParent() {
            return this.myParent;
        }

        public VirtualFile[] getChildren() {
            Collection<MyVirtualFile> children = this.myChildren.values();
            return (VirtualFile[])children.toArray(new MyVirtualFile[children.size()]);
        }
    }
}

