/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.Nullable;

public class ToggleCaseAction
extends TextComponentEditorAction {
    public ToggleCaseAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(final Editor editor, @Nullable Caret caret, DataContext dataContext) {
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasBlockSelection()) {
                int[] starts = selectionModel.getBlockSelectionStarts();
                int[] ends = selectionModel.getBlockSelectionEnds();
                LogicalPosition blockStart = selectionModel.getBlockStart();
                LogicalPosition blockEnd = selectionModel.getBlockEnd();
                selectionModel.removeBlockSelection();
                selectionModel.removeSelection();
                for (int i = 0; i < starts.length; ++i) {
                    String converted;
                    int startOffset = starts[i];
                    int endOffset = ends[i];
                    String text = ((Object)editor.getDocument().getCharsSequence().subSequence(startOffset, endOffset)).toString();
                    if (text.equals(converted = Handler.toCase(text, true))) {
                        converted = Handler.toCase(text, false);
                    }
                    editor.getDocument().replaceString(startOffset, endOffset, (CharSequence)converted);
                }
                if (blockStart != null && blockEnd != null) {
                    selectionModel.setBlockSelection(blockStart, blockEnd);
                }
            } else {
                final Ref toLowerCase = new Ref((Object)Boolean.FALSE);
                Handler.runForCaret(editor, caret, new CaretAction(){

                    public void perform(Caret caret) {
                        String selectedText;
                        if (!caret.hasSelection()) {
                            caret.selectWordAtCaret(true);
                        }
                        if ((selectedText = caret.getSelectedText()) != null && !selectedText.equals(Handler.toCase(selectedText, true))) {
                            toLowerCase.set((Object)Boolean.TRUE);
                        }
                    }
                });
                Handler.runForCaret(editor, caret, new CaretAction(){

                    public void perform(Caret caret) {
                        VisualPosition caretPosition = caret.getVisualPosition();
                        int selectionStartOffset = caret.getSelectionStart();
                        int selectionEndOffset = caret.getSelectionEnd();
                        VisualPosition selectionStartPosition = caret.getSelectionStartPosition();
                        VisualPosition selectionEndPosition = caret.getSelectionEndPosition();
                        caret.removeSelection();
                        String text = editor.getDocument().getText(new TextRange(selectionStartOffset, selectionEndOffset));
                        editor.getDocument().replaceString(selectionStartOffset, selectionEndOffset, (CharSequence)Handler.toCase(text, (Boolean)toLowerCase.get()));
                        caret.moveToVisualPosition(caretPosition);
                        caret.setSelection(selectionStartPosition, selectionStartOffset, selectionEndPosition, selectionEndOffset);
                    }
                });
            }
        }

        private static void runForCaret(Editor editor, Caret caret, CaretAction action) {
            if (caret == null) {
                editor.getCaretModel().runForEachCaret(action);
            } else {
                action.perform(caret);
            }
        }

        private static String toCase(String text, boolean lower) {
            StringBuilder builder = new StringBuilder(text.length());
            boolean prevIsSlash = false;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (!prevIsSlash) {
                    c = lower ? Character.toLowerCase(c) : Character.toUpperCase(c);
                }
                prevIsSlash = c == '\\';
                builder.append(c);
            }
            return builder.toString();
        }
    }
}

