/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.impl;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.RootFileElement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeBuilder
extends AbstractTreeBuilder {
    private final FileChooserDescriptor myChooserDescriptor;
    private final Runnable myOnInitialized;

    public FileTreeBuilder(JTree tree, DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, Comparator<NodeDescriptor> comparator, FileChooserDescriptor chooserDescriptor, @Nullable Runnable onInitialized) {
        super(tree, treeModel, treeStructure, comparator, false);
        this.myOnInitialized = onInitialized;
        this.myChooserDescriptor = chooserDescriptor;
        this.initRootNode();
        this.installVirtualFileListener();
    }

    protected void onRootNodeInitialized() {
        if (this.myOnInitialized != null) {
            this.myOnInitialized.run();
        }
    }

    private void installVirtualFileListener() {
        VirtualFileAdapter myVirtualFileListener = new VirtualFileAdapter(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileChooser/impl/FileTreeBuilder$1", "propertyChanged"));
                }
                FileTreeBuilder.this.getUpdater().addSubtreeToUpdate(FileTreeBuilder.this.getRootNode());
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileChooser/impl/FileTreeBuilder$1", "fileCreated"));
                }
                FileTreeBuilder.this.getUpdater().addSubtreeToUpdate(FileTreeBuilder.this.getRootNode());
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileChooser/impl/FileTreeBuilder$1", "fileDeleted"));
                }
                FileTreeBuilder.this.getUpdater().addSubtreeToUpdate(FileTreeBuilder.this.getRootNode());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileChooser/impl/FileTreeBuilder$1", "fileMoved"));
                }
                FileTreeBuilder.this.getUpdater().addSubtreeToUpdate(FileTreeBuilder.this.getRootNode());
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        FileElement descriptor;
        VirtualFile file;
        Object element = nodeDescriptor.getElement();
        if (element != null && (file = (descriptor = (FileElement)element).getFile()) != null) {
            if (this.myChooserDescriptor.isChooseJarContents() && FileElement.isArchive((VirtualFile)file)) {
                return true;
            }
            return file.isDirectory();
        }
        return true;
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor.getElement() instanceof RootFileElement) {
            return true;
        }
        if (!SystemInfo.isWindows) {
            NodeDescriptor parent = nodeDescriptor.getParentDescriptor();
            return parent != null && parent.getElement() instanceof RootFileElement;
        }
        return false;
    }

    @NotNull
    protected ProgressIndicator createProgressIndicator() {
        StatusBarProgress statusBarProgress = new StatusBarProgress();
        if (statusBarProgress == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/impl/FileTreeBuilder", "createProgressIndicator"));
        }
        return statusBarProgress;
    }
}

