/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathImpl
implements FilePath {
    private VirtualFile myVirtualFile;
    private VirtualFile myVirtualParent;
    private final String myName;
    @NotNull
    private final File myFile;
    private boolean myIsDirectory;
    private final boolean myLocal;
    private static Constructor<File> ourFileStringConstructor;
    private static boolean ourFileStringConstructorInitialized;

    private FilePathImpl(VirtualFile virtualParent, @NotNull String name, boolean isDirectory, VirtualFile child, boolean forDeleted) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/FilePathImpl", "<init>"));
        }
        this(FilePathImpl.fileFromVirtual(virtualParent, child, name), isDirectory, true);
        this.myVirtualParent = virtualParent;
        if (!forDeleted) {
            if (child == null) {
                this.refresh();
            } else {
                this.myVirtualFile = child;
            }
        }
    }

    private static File fileFromVirtual(VirtualFile virtualParent, VirtualFile child, String name) {
        assert (virtualParent != null || child != null);
        if (virtualParent != null) {
            return new File(virtualParent.getPath(), name);
        }
        return new File(child.getPath());
    }

    public FilePathImpl(@NotNull VirtualFile virtualParent, String name, boolean isDirectory) {
        if (virtualParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualParent", "com/intellij/openapi/vcs/FilePathImpl", "<init>"));
        }
        this(virtualParent, name, isDirectory, null, false);
    }

    private FilePathImpl(@NotNull VirtualFile virtualParent, String name, boolean isDirectory, boolean forDeleted) {
        if (virtualParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualParent", "com/intellij/openapi/vcs/FilePathImpl", "<init>"));
        }
        this(virtualParent, name, isDirectory, null, forDeleted);
    }

    public FilePathImpl(@NotNull File file, boolean isDirectory) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/FilePathImpl", "<init>"));
        }
        this(file, isDirectory, true);
    }

    private FilePathImpl(@NotNull File file, boolean isDirectory, boolean local) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/FilePathImpl", "<init>"));
        }
        this.myFile = file;
        this.myName = file.getName();
        this.myIsDirectory = isDirectory;
        this.myLocal = local;
    }

    public FilePathImpl(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/FilePathImpl", "<init>"));
        }
        this(virtualFile.getParent(), virtualFile.getName(), virtualFile.isDirectory(), virtualFile, false);
    }

    public FilePath createChild(String subPath, boolean isDirectory) {
        if (StringUtil.isEmptyOrSpaces((String)subPath)) {
            return this;
        }
        if (this.getVirtualFile() != null && subPath.indexOf(47) == -1 && subPath.indexOf(92) == -1) {
            return new FilePathImpl(this.getVirtualFile(), subPath, isDirectory, true);
        }
        return new FilePathImpl(new File(this.getIOFile(), subPath), isDirectory);
    }

    public int hashCode() {
        return StringUtil.stringHashCodeInsensitive((CharSequence)this.myFile.getPath());
    }

    public boolean equals(Object o) {
        if (!(o instanceof FilePath)) {
            return false;
        }
        if (!(FilePathImpl.isSpecialName(this.myName) || FilePathImpl.isSpecialName(((FilePath)o).getName()) || Comparing.equal((String)this.myName, (String)((FilePath)o).getName()))) {
            return false;
        }
        return this.myFile.equals(((FilePath)o).getIOFile());
    }

    private static boolean isSpecialName(String name) {
        return ".".equals(name) || "..".equals(name);
    }

    public void refresh() {
        if (this.myLocal) {
            this.myVirtualFile = this.myVirtualParent == null ? LocalFileSystem.getInstance().findFileByIoFile(this.myFile) : this.myVirtualParent.findChild(this.myName);
        }
    }

    public void hardRefresh() {
        if (this.myLocal && (this.myVirtualFile == null || !this.myVirtualFile.isValid())) {
            this.myVirtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
        }
    }

    public String getPath() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile != null && virtualFile.isValid()) {
            return virtualFile.getPath();
        }
        return this.myFile.getPath();
    }

    public void setIsDirectory(boolean isDirectory) {
        this.myIsDirectory = isDirectory;
    }

    public boolean isDirectory() {
        if (this.myVirtualFile == null) {
            return this.myIsDirectory;
        }
        return this.myVirtualFile.isDirectory();
    }

    public boolean isUnder(FilePath parent, boolean strict) {
        VirtualFile parentFile;
        if (this.myVirtualFile != null && (parentFile = parent.getVirtualFile()) != null) {
            return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)this.myVirtualFile, (boolean)strict);
        }
        return FileUtil.isAncestor((File)parent.getIOFile(), (File)this.getIOFile(), (boolean)strict);
    }

    public FilePath getParentPath() {
        if (this.myVirtualParent != null && this.myVirtualParent.isValid() && this.myVirtualParent.getParent() != null) {
            return new FilePathImpl(this.myVirtualParent);
        }
        String path = this.myFile.getPath();
        int pos = path.lastIndexOf(File.separatorChar);
        if (pos < 0 || pos == path.indexOf(File.separatorChar)) {
            return null;
        }
        return new FilePathImpl(new File(path.substring(0, pos)), true);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        if (this.myVirtualFile != null && !this.myVirtualFile.isValid()) {
            this.myVirtualFile = null;
        }
        return this.myVirtualFile;
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        if (this.myVirtualParent != null && !this.myVirtualParent.isValid()) {
            this.myVirtualParent = null;
        }
        return this.myVirtualParent;
    }

    @NotNull
    public File getIOFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/FilePathImpl", "getIOFile"));
        }
        return file;
    }

    public String getName() {
        return this.myName;
    }

    public String getPresentableUrl() {
        if (this.myVirtualFile == null || !this.myVirtualFile.isValid()) {
            return this.myFile.getAbsolutePath();
        }
        return this.myVirtualFile.getPresentableUrl();
    }

    @Nullable
    public Document getDocument() {
        if (this.myVirtualFile == null || this.myVirtualFile.getFileType().isBinary()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
    }

    public Charset getCharset() {
        return this.getCharset(null);
    }

    public Charset getCharset(Project project) {
        EncodingProjectManager e;
        Charset rc;
        VirtualFile existing;
        VirtualFile virtualFile = existing = this.myVirtualFile != null && this.myVirtualFile.isValid() ? this.myVirtualFile : null;
        if (existing == null) {
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            for (File f = this.myFile; !(f == null || (existing = lfs.findFileByIoFile(f)) != null && existing.isValid()); f = f.getParentFile()) {
            }
        }
        if (existing != null && (rc = existing.getCharset()) != null) {
            return rc;
        }
        EncodingProjectManager encodingProjectManager = e = project != null ? EncodingProjectManager.getInstance((Project)project) : null;
        if (e == null) {
            e = EncodingManager.getInstance();
        }
        return e.getDefaultCharset();
    }

    public FileType getFileType() {
        return this.myVirtualFile != null ? this.myVirtualFile.getFileType() : FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName());
    }

    public static FilePathImpl create(VirtualFile file) {
        return FilePathImpl.create(VfsUtilCore.virtualToIoFile((VirtualFile)file), file.isDirectory());
    }

    public static FilePathImpl create(File selectedFile) {
        return FilePathImpl.create(selectedFile, false);
    }

    public static FilePathImpl create(File selectedFile, boolean isDirectory) {
        if (selectedFile == null) {
            return null;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile virtualFile = lfs.findFileByIoFile(selectedFile);
        if (virtualFile != null) {
            return new FilePathImpl(virtualFile);
        }
        return FilePathImpl.createForDeletedFile(selectedFile, isDirectory);
    }

    public static FilePathImpl createForDeletedFile(File selectedFile, boolean isDirectory) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parentFile = selectedFile.getParentFile();
        if (parentFile == null) {
            return new FilePathImpl(selectedFile, isDirectory);
        }
        VirtualFile virtualFileParent = lfs.findFileByIoFile(parentFile);
        if (virtualFileParent != null) {
            return new FilePathImpl(virtualFileParent, selectedFile.getName(), isDirectory, true);
        }
        return new FilePathImpl(selectedFile, isDirectory);
    }

    public static FilePath createOn(String s) {
        File ioFile = new File(s);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        VirtualFile virtualFile = localFileSystem.findFileByIoFile(ioFile);
        if (virtualFile != null) {
            return new FilePathImpl(virtualFile);
        }
        VirtualFile virtualFileParent = localFileSystem.findFileByIoFile(ioFile.getParentFile());
        if (virtualFileParent != null) {
            return new FilePathImpl(virtualFileParent, ioFile.getName(), false);
        }
        return null;
    }

    @NotNull
    public static FilePath createNonLocal(String path, boolean directory) {
        path = path.replace('/', File.separatorChar);
        if (!ourFileStringConstructorInitialized) {
            ourFileStringConstructorInitialized = true;
            try {
                ourFileStringConstructor = File.class.getDeclaredConstructor(String.class, Integer.TYPE);
                ourFileStringConstructor.setAccessible(true);
            }
            catch (Exception ex) {
                ourFileStringConstructor = null;
            }
        }
        File file = null;
        try {
            if (ourFileStringConstructor != null) {
                file = ourFileStringConstructor.newInstance(path, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            file = new File(path);
        }
        FilePathImpl filePathImpl = new FilePathImpl(file, directory, false);
        if (filePathImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/FilePathImpl", "createNonLocal"));
        }
        return filePathImpl;
    }

    @NonNls
    public String toString() {
        return "FilePath[" + this.myFile.getName() + "] (" + this.myFile.getParent() + ")";
    }

    public boolean isNonLocal() {
        return !this.myLocal;
    }
}

