/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.BaseRevision;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BeforeAfter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private final TreeMap<String, FileStatus> myFileToStatus;
    private final Map<String, Pair<VcsKey, VcsRevisionNumber>> myFileToVcs;

    ChangeListsIndexes() {
        this.myFileToStatus = new TreeMap();
        this.myFileToVcs = new HashMap<String, Pair<VcsKey, VcsRevisionNumber>>();
    }

    ChangeListsIndexes(ChangeListsIndexes idx) {
        this.myFileToStatus = new TreeMap<String, FileStatus>((SortedMap<String, FileStatus>)idx.myFileToStatus);
        this.myFileToVcs = new HashMap<String, Pair<VcsKey, VcsRevisionNumber>>(idx.myFileToVcs);
    }

    void add(FilePath file, FileStatus status, VcsKey key, VcsRevisionNumber number) {
        String fileKey = file.getIOFile().getAbsolutePath();
        this.myFileToStatus.put(fileKey, status);
        this.myFileToVcs.put(fileKey, (Pair<VcsKey, VcsRevisionNumber>)Pair.create((Object)key, (Object)number));
    }

    void remove(FilePath file) {
        String fileKey = file.getIOFile().getAbsolutePath();
        this.myFileToStatus.remove(fileKey);
        this.myFileToVcs.remove(fileKey);
    }

    public FileStatus getStatus(VirtualFile file) {
        return this.myFileToStatus.get(new File(file.getPath()).getAbsolutePath());
    }

    public FileStatus getStatus(File file) {
        return this.myFileToStatus.get(file.getAbsolutePath());
    }

    public void changeAdded(Change change, VcsKey key) {
        this.addChangeToIdx(change, key);
    }

    public void changeRemoved(Change change) {
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    public VcsKey getVcsFor(Change change) {
        VcsKey key = this.getVcsForRevision(change.getAfterRevision());
        if (key != null) {
            return key;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private VcsKey getVcsForRevision(ContentRevision revision) {
        if (revision != null) {
            String fileKey = revision.getFile().getIOFile().getAbsolutePath();
            Pair<VcsKey, VcsRevisionNumber> pair = this.myFileToVcs.get(fileKey);
            return pair == null ? null : (VcsKey)pair.getFirst();
        }
        return null;
    }

    private void addChangeToIdx(Change change, VcsKey key) {
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.add(afterRevision.getFile(), change.getFileStatus(), key, beforeRevision == null ? VcsRevisionNumber.NULL : beforeRevision.getRevisionNumber());
        }
        if (beforeRevision != null) {
            if (afterRevision != null) {
                if (!Comparing.equal((Object)beforeRevision.getFile(), (Object)afterRevision.getFile())) {
                    this.add(beforeRevision.getFile(), FileStatus.DELETED, key, beforeRevision.getRevisionNumber());
                }
            } else {
                this.add(beforeRevision.getFile(), change.getFileStatus(), key, beforeRevision.getRevisionNumber());
            }
        }
    }

    public void getDelta(ChangeListsIndexes newIndexes, Set<BaseRevision> toRemove, Set<BaseRevision> toAdd, Set<BeforeAfter<BaseRevision>> toModify) {
        Pair<VcsKey, VcsRevisionNumber> pair;
        HashSet<String> oldKeySet = new HashSet<String>(this.myFileToVcs.keySet());
        HashSet<String> toRemoveSet = new HashSet<String>(oldKeySet);
        Set<String> newKeySet = newIndexes.myFileToVcs.keySet();
        HashSet<String> toAddSet = new HashSet<String>(newKeySet);
        toRemoveSet.removeAll(newKeySet);
        toAddSet.removeAll(oldKeySet);
        oldKeySet.removeAll(toRemoveSet);
        for (String s : toRemoveSet) {
            pair = this.myFileToVcs.get(s);
            toRemove.add(this.fromPairAndPath(s, pair));
        }
        for (String s : toAddSet) {
            pair = newIndexes.myFileToVcs.get(s);
            toAdd.add(this.fromPairAndPath(s, pair));
        }
        for (String s : oldKeySet) {
            Pair<VcsKey, VcsRevisionNumber> old = this.myFileToVcs.get(s);
            Pair<VcsKey, VcsRevisionNumber> newOne = newIndexes.myFileToVcs.get(s);
            assert (old != null && newOne != null);
            if (old.equals(newOne)) continue;
            toModify.add((BeforeAfter<BaseRevision>)new BeforeAfter((Object)this.fromPairAndPath(s, old), (Object)this.fromPairAndPath(s, newOne)));
        }
    }

    private BaseRevision fromPairAndPath(String s, Pair<VcsKey, VcsRevisionNumber> pair) {
        return new BaseRevision((VcsKey)pair.getFirst(), (VcsRevisionNumber)pair.getSecond(), s);
    }

    public List<BaseRevision> getAffectedFilesUnderVcs() {
        ArrayList<BaseRevision> result = new ArrayList<BaseRevision>();
        for (Map.Entry<String, Pair<VcsKey, VcsRevisionNumber>> entry : this.myFileToVcs.entrySet()) {
            Pair<VcsKey, VcsRevisionNumber> value = entry.getValue();
            result.add(this.fromPairAndPath(entry.getKey(), value));
        }
        return result;
    }

    public SortedSet<String> getAffectedPaths() {
        return Collections.unmodifiableSortedSet((SortedSet)this.myFileToStatus.keySet());
    }
}

