/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vcs.impl.CheckinHandlersManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CheckinHandlersManagerImpl
extends CheckinHandlersManager {
    private final List<BaseCheckinHandlerFactory> myRegisteredBeforeCheckinHandlers;
    private final MultiMap<VcsKey, VcsCheckinHandlerFactory> myVcsMap = new MultiMap();

    public CheckinHandlersManagerImpl() {
        this.myRegisteredBeforeCheckinHandlers = new ArrayList<BaseCheckinHandlerFactory>();
        ContainerUtil.addAll(this.myRegisteredBeforeCheckinHandlers, (Object[])CheckinHandlerFactory.EP_NAME.getExtensions());
        for (VcsCheckinHandlerFactory factory : (VcsCheckinHandlerFactory[])VcsCheckinHandlerFactory.EP_NAME.getExtensions()) {
            this.myVcsMap.putValue((Object)factory.getKey(), (Object)factory);
        }
    }

    public List<BaseCheckinHandlerFactory> getRegisteredCheckinHandlerFactories(AbstractVcs<?>[] allActiveVcss) {
        ArrayList<BaseCheckinHandlerFactory> list = new ArrayList<BaseCheckinHandlerFactory>(this.myRegisteredBeforeCheckinHandlers.size() + allActiveVcss.length);
        list.addAll(this.myRegisteredBeforeCheckinHandlers);
        for (AbstractVcs<?> vcs : allActiveVcss) {
            Collection factories = this.myVcsMap.get((Object)vcs.getKeyInstanceMethod());
            if (factories.isEmpty()) continue;
            list.addAll(factories);
        }
        return list;
    }

    public List<VcsCheckinHandlerFactory> getMatchingVcsFactories(@NotNull List<AbstractVcs> vcsList) {
        if (vcsList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsList", "com/intellij/openapi/vcs/impl/CheckinHandlersManagerImpl", "getMatchingVcsFactories"));
        }
        SmartList result = new SmartList();
        for (AbstractVcs vcs : vcsList) {
            Collection factories = this.myVcsMap.get((Object)vcs.getKeyInstanceMethod());
            if (factories.isEmpty()) continue;
            result.addAll(factories);
        }
        return result;
    }

    public void registerCheckinHandlerFactory(BaseCheckinHandlerFactory factory) {
        this.myRegisteredBeforeCheckinHandlers.add(factory);
    }

    public void unregisterCheckinHandlerFactory(BaseCheckinHandlerFactory handler) {
        this.myRegisteredBeforeCheckinHandlers.remove(handler);
    }
}

