/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlatformVcsDetector
implements ProjectComponent {
    private final Project myProject;
    private final ProjectLevelVcsManagerImpl myVcsManager;

    public PlatformVcsDetector(Project project, ProjectLevelVcsManagerImpl vcsManager) {
        this.myProject = project;
        this.myVcsManager = vcsManager;
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

            public void run() {
                DumbAwareRunnable runnable = new DumbAwareRunnable(){

                    public void run() {
                        AbstractVcs vcs;
                        VirtualFile file = ProjectBaseDirectory.getInstance(PlatformVcsDetector.this.myProject).getBaseDir(PlatformVcsDetector.this.myProject.getBaseDir());
                        if (PlatformVcsDetector.this.myVcsManager.needAutodetectMappings() && (vcs = PlatformVcsDetector.this.myVcsManager.findVersioningVcs(file)) != null && vcs != PlatformVcsDetector.this.myVcsManager.getVcsFor(file)) {
                            PlatformVcsDetector.this.myVcsManager.removeDirectoryMapping(new VcsDirectoryMapping("", ""));
                            PlatformVcsDetector.this.myVcsManager.setAutoDirectoryMapping(file.getPath(), vcs.getName());
                            PlatformVcsDetector.this.myVcsManager.cleanupMappings();
                            PlatformVcsDetector.this.myVcsManager.updateActiveVcss();
                        }
                    }
                };
                ApplicationManager.getApplication().invokeLater((Runnable)runnable, new Condition(){

                    public boolean value(Object o) {
                        return !PlatformVcsDetector.this.myProject.isOpen() || PlatformVcsDetector.this.myProject.isDisposed();
                    }
                });
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("PlatformVcsDetector" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/PlatformVcsDetector", "getComponentName"));
        }
        return "PlatformVcsDetector";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

