/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeanPropertyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return false;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.getProperty(dataContext) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "invoke"));
        }
        this.performInvoke(editor, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "invoke"));
        }
        this.performInvoke(null, dataContext);
    }

    private void performInvoke(@Nullable Editor editor, DataContext dataContext) {
        BeanProperty property = this.getProperty(dataContext);
        assert (property != null);
        PsiNamedElement element = property.getPsiElement();
        if (PsiElementRenameHandler.canRename(element.getProject(), editor, (PsiElement)element)) {
            new PropertyRenameDialog(property, editor).show();
        }
    }

    public static void doRename(@NotNull BeanProperty property, String newName, boolean searchInComments, boolean isPreview) {
        PsiMethod getter;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/refactoring/rename/BeanPropertyRenameHandler", "doRename"));
        }
        PsiNamedElement psiElement = property.getPsiElement();
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), (PsiElement)psiElement, newName, searchInComments, false);
        rename.setPreviewUsages(isPreview);
        PsiMethod setter = property.getSetter();
        if (setter != null) {
            JavaCodeStyleManager manager;
            String suggestedParameterName;
            String setterName = PropertyUtil.suggestSetterName((String)newName);
            rename.addElement((PsiElement)setter, setterName);
            PsiParameter[] setterParameters = setter.getParameterList().getParameters();
            if (setterParameters.length == 1 && (suggestedParameterName = (manager = JavaCodeStyleManager.getInstance((Project)psiElement.getProject())).propertyNameToVariableName(property.getName(), VariableKind.PARAMETER)).equals(setterParameters[0].getName())) {
                rename.addElement((PsiElement)setterParameters[0], manager.propertyNameToVariableName(newName, VariableKind.PARAMETER));
            }
        }
        if ((getter = property.getGetter()) != null) {
            String getterName = PropertyUtil.suggestGetterName((String)newName, (PsiType)getter.getReturnType());
            rename.addElement((PsiElement)getter, getterName);
        }
        rename.run();
    }

    @Nullable
    protected abstract BeanProperty getProperty(DataContext var1);

    private static class PropertyRenameDialog
    extends RenameDialog {
        private final BeanProperty myProperty;

        protected PropertyRenameDialog(BeanProperty property, Editor editor) {
            super(property.getMethod().getProject(), (PsiElement)property.getPsiElement(), null, editor);
            this.myProperty = property;
        }

        @Override
        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            BeanPropertyRenameHandler.doRename(this.myProperty, newName, searchInComments, this.isPreviewUsages());
            this.close(0);
        }
    }
}

