/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.testFramework.LoggedErrorProcessor;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TestLogger
extends com.intellij.openapi.diagnostic.Logger {
    private final Logger myLogger;

    public TestLogger(Logger logger) {
        this.myLogger = logger;
    }

    public boolean isDebugEnabled() {
        return this.myLogger.isDebugEnabled();
    }

    public void debug(String message) {
        this.myLogger.debug((Object)message);
    }

    public void debug(Throwable t) {
        this.myLogger.debug((Object)t);
    }

    public void debug(String message, Throwable t) {
        this.myLogger.debug((Object)message, t);
    }

    public void info(String message) {
        this.myLogger.info((Object)message);
    }

    public void info(String message, Throwable t) {
        this.myLogger.info((Object)message, t);
    }

    public void warn(String message, @Nullable Throwable t) {
        LoggedErrorProcessor.getInstance().processWarn(message, t, this.myLogger);
    }

    public void error(String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/testFramework/TestLogger", "error"));
        }
        LoggedErrorProcessor.getInstance().processError(message, t, details, this.myLogger);
    }

    public Level getLevel() {
        return this.myLogger.getLevel();
    }

    public void setLevel(Level level) {
        this.myLogger.setLevel(level);
    }
}

