/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.impl.SocketConnectionBase;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class ServerSocketConnectionImpl<Request extends AbstractRequest, Response extends AbstractResponse>
extends SocketConnectionBase<Request, Response> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.ServerSocketConnectionImpl");
    private ServerSocket myServerSocket;
    private final int myDefaultPort;
    private final int myConnectionAttempts;

    public ServerSocketConnectionImpl(int defaultPort, int connectionAttempts, @NotNull RequestResponseExternalizerFactory<Request, Response> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/io/socketConnection/impl/ServerSocketConnectionImpl", "<init>"));
        }
        super(factory);
        this.myDefaultPort = defaultPort;
        this.myConnectionAttempts = connectionAttempts;
    }

    @Override
    public void open() throws IOException {
        this.myServerSocket = this.createSocket();
        this.setPort(this.myServerSocket.getLocalPort());
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocketConnectionImpl.this.waitForConnection();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    ServerSocketConnectionImpl.this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Connection failed: " + e.getMessage());
                }
            }
        });
    }

    @NotNull
    private ServerSocket createSocket() throws IOException {
        IOException exc = null;
        for (int i = 0; i < this.myConnectionAttempts; ++i) {
            ServerSocket serverSocket;
            block3: {
                int port = this.myDefaultPort + i;
                try {
                    serverSocket = new ServerSocket(port);
                    if (serverSocket != null) break block3;
                }
                catch (IOException e) {
                    exc = e;
                    LOG.info((Throwable)e);
                    continue;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/socketConnection/impl/ServerSocketConnectionImpl", "createSocket"));
            }
            return serverSocket;
        }
        throw exc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnection() throws IOException {
        this.addThreadToInterrupt();
        try {
            this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
            LOG.debug("waiting for connection on port " + this.getPort());
            Socket socket = this.myServerSocket.accept();
            try {
                this.attachToSocket(socket);
            }
            finally {
                socket.close();
            }
        }
        finally {
            this.myServerSocket.close();
            this.removeThreadToInterrupt();
        }
    }
}

