/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleTaskController<Request, Result> {
    @NotNull
    private final Consumer<Result> myResultHandler;
    @NotNull
    private final Object LOCK;
    @NotNull
    private List<Request> myAwaitingRequests;
    private boolean myActive;

    public SingleTaskController(@NotNull Consumer<Result> handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/vcs/log/data/SingleTaskController", "<init>"));
        }
        this.LOCK = new Object();
        this.myResultHandler = handler;
        this.myAwaitingRequests = ContainerUtil.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void request(@NotNull Request requests) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/vcs/log/data/SingleTaskController", "request"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myAwaitingRequests.add(requests);
            if (!this.myActive) {
                this.startNewBackgroundTask();
                this.myActive = true;
            }
        }
    }

    protected abstract void startNewBackgroundTask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final List<Request> popRequests() {
        Object object = this.LOCK;
        // MONITORENTER : object
        List<Request> requests = this.myAwaitingRequests;
        this.myAwaitingRequests = ContainerUtil.newArrayList();
        List<Request> list = requests;
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/SingleTaskController", "popRequests"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void taskCompleted(@Nullable Result result) {
        if (result != null) {
            this.myResultHandler.consume(result);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                this.myActive = false;
            } else {
                this.startNewBackgroundTask();
            }
        }
    }
}

