/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class BitSetFlags
implements Flags {
    private final int mySize;
    @NotNull
    private final BitSet myBitSet;

    public BitSetFlags(int size) {
        if (size < 0) {
            throw new NegativeArraySizeException("size < 0: " + size);
        }
        this.mySize = size;
        this.myBitSet = new BitSet(size);
    }

    public BitSetFlags(int size, boolean defaultValue) {
        this(size);
        if (defaultValue) {
            this.setAll(true);
        }
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean get(int index) {
        this.checkRange(index);
        return this.myBitSet.get(index);
    }

    @Override
    public void set(int index, boolean value) {
        this.checkRange(index);
        this.myBitSet.set(index, value);
    }

    @Override
    public void setAll(boolean value) {
        this.myBitSet.set(0, this.mySize, value);
    }

    private void checkRange(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < 0:" + index);
        }
        if (index >= this.mySize) {
            throw new IndexOutOfBoundsException("index: " + index + " >= mySize: " + this.mySize);
        }
    }
}

