/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblematicWhitespaceInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("problematic.whitespace.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ProblematicWhitespaceInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean useTabs = (Boolean)infos[2];
        String string = useTabs != false ? InspectionGadgetsBundle.message("problematic.whitespace.spaces.problem.descriptor", (String)infos[0]) : InspectionGadgetsBundle.message("problematic.whitespace.tabs.problem.descriptor", (String)infos[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ProblematicWhitespaceInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean buildFix = (Boolean)infos[1];
        if (!buildFix) {
            return null;
        }
        return new ShowWhitespaceFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProblematicWhitespaceVisitor();
    }

    private static class ProblematicWhitespaceVisitor
    extends BaseInspectionVisitor {
        private ProblematicWhitespaceVisitor() {
        }

        public void visitJavaFile(PsiJavaFile file) {
            super.visitJavaFile(file);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)file.getProject());
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)JavaFileType.INSTANCE);
            boolean useTabs = indentOptions.USE_TAB_CHARACTER;
            boolean smartTabs = indentOptions.SMART_TABS;
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
            if (document == null) {
                return;
            }
            int lineCount = document.getLineCount();
            int previousLineIndent = 0;
            block0: for (int i = 0; i < lineCount; ++i) {
                int startOffset = document.getLineStartOffset(i);
                int endOffset = document.getLineEndOffset(i);
                String line = document.getText(new TextRange(startOffset, endOffset));
                boolean spaceSeen = false;
                int length = line.length();
                for (int j = 0; j < length; ++j) {
                    char c = line.charAt(j);
                    if (c == '\t') {
                        if (useTabs) {
                            if (!smartTabs || !spaceSeen) continue;
                            this.registerError((PsiElement)file, file.getName(), this.isOnTheFly(), Boolean.TRUE);
                            return;
                        }
                        this.registerError((PsiElement)file, file.getName(), this.isOnTheFly(), Boolean.FALSE);
                        return;
                    }
                    if (c == ' ') {
                        if (useTabs) {
                            if (!smartTabs) {
                                this.registerError((PsiElement)file, file.getName(), this.isOnTheFly(), Boolean.TRUE);
                                return;
                            }
                            if (!spaceSeen) {
                                int currentIndent = Math.max(0, j);
                                if (currentIndent < previousLineIndent) {
                                    this.registerError((PsiElement)file, file.getName(), this.isOnTheFly(), Boolean.TRUE);
                                    return;
                                }
                                previousLineIndent = currentIndent;
                            }
                        }
                        spaceSeen = true;
                        continue;
                    }
                    if (spaceSeen) continue block0;
                    previousLineIndent = Math.max(0, j);
                    continue block0;
                }
            }
        }
    }

    private static class ShowWhitespaceFix
    extends InspectionGadgetsFix {
        private ShowWhitespaceFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("problematic.whitespace.show.whitespaces.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ProblematicWhitespaceInspection$ShowWhitespaceFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ProblematicWhitespaceInspection$ShowWhitespaceFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            EditorSettings settings;
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            Editor editor = editorManager.getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            settings.setWhitespacesShown(!(settings = editor.getSettings()).isWhitespacesShown());
            editor.getComponent().repaint();
        }
    }
}

