/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.VariableContext;

class VariableContextWrapper
implements VariableContext {
    private final VariableContext parentContext;
    private final Scope scope;

    public VariableContextWrapper(@NotNull VariableContext parentContext, @Nullable Scope scope) {
        if (parentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentContext", "org/jetbrains/debugger/VariableContextWrapper", "<init>"));
        }
        this.parentContext = parentContext;
        this.scope = scope;
    }

    @Override
    @Nullable
    public String getName() {
        return this.parentContext.getName();
    }

    @Override
    @NotNull
    public MemberFilter createMemberFilter() {
        MemberFilter memberFilter = this.parentContext.getViewSupport().createMemberFilter(this);
        if (memberFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableContextWrapper", "createMemberFilter"));
        }
        return memberFilter;
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        EvaluateContext evaluateContext = this.parentContext.getEvaluateContext();
        if (evaluateContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableContextWrapper", "getEvaluateContext"));
        }
        return evaluateContext;
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        DebuggerViewSupport debuggerViewSupport = this.parentContext.getViewSupport();
        if (debuggerViewSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariableContextWrapper", "getViewSupport"));
        }
        return debuggerViewSupport;
    }

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.parentContext.watchableAsEvaluationExpression();
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public VariableContext getParent() {
        return this.parentContext;
    }
}

