/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.android.logcat.AdbErrors;
import org.jetbrains.android.logcat.AndroidToolWindowFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbService {
    @NotNull
    private static final Ddmlib ourDdmlib = new Ddmlib();
    @Nullable
    private static SettableFuture<AndroidDebugBridge> ourFuture;
    @Nullable
    private static BridgeConnectorTask ourMonitorTask;

    public static synchronized ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        if (adb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adb", "com/android/tools/idea/ddms/adb/AdbService", "getDebugBridge"));
        }
        if (ourFuture != null && !AdbService.wasSuccessful(ourFuture)) {
            AdbService.terminateDdmlib();
        }
        if (ourFuture == null) {
            ourFuture = SettableFuture.create();
            ourMonitorTask = new BridgeConnectorTask(adb, ourDdmlib, ourFuture);
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)ourMonitorTask);
        }
        return ourFuture;
    }

    public static synchronized void terminateDdmlib() {
        ourFuture = null;
        if (ourMonitorTask != null) {
            ourMonitorTask.cancel();
        }
        ourDdmlib.terminate();
    }

    public static boolean canDdmsBeCorrupted(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "com/android/tools/idea/ddms/adb/AdbService", "canDdmsBeCorrupted"));
        }
        return AdbService.isDdmsCorrupted(bridge) || AdbService.allDevicesAreEmpty(bridge);
    }

    private static boolean allDevicesAreEmpty(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "com/android/tools/idea/ddms/adb/AdbService", "allDevicesAreEmpty"));
        }
        for (IDevice device : bridge.getDevices()) {
            if (device.getClients().length <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDdmsCorrupted(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bridge", "com/android/tools/idea/ddms/adb/AdbService", "isDdmsCorrupted"));
        }
        IDevice[] devices = bridge.getDevices();
        if (devices.length > 0) {
            for (IDevice device : devices) {
                Client[] clients = device.getClients();
                if (clients.length <= 0) continue;
                ClientData clientData = clients[0].getClientData();
                return clientData.getVmIdentifier() == null;
            }
        }
        return false;
    }

    public static synchronized void restartDdmlib(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/ddms/adb/AdbService", "restartDdmlib"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.TOOL_WINDOW_ID);
        boolean hidden = false;
        if (toolWindow != null && toolWindow.isVisible()) {
            hidden = true;
            toolWindow.hide(null);
        }
        AdbService.terminateDdmlib();
        if (hidden) {
            toolWindow.show(null);
        }
    }

    private static boolean wasSuccessful(Future<AndroidDebugBridge> future) {
        if (!future.isDone()) {
            return false;
        }
        try {
            AndroidDebugBridge bridge = future.get();
            return bridge != null && bridge.isConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class Ddmlib {
        private static final Logger LOG = Logger.getInstance(Ddmlib.class);
        private AndroidDebugBridge myBridge;
        private boolean myDdmLibInitialized = false;
        private boolean ourDdmLibTerminated = false;

        private Ddmlib() {
        }

        public synchronized void initialize(@NotNull File adb) {
            if (adb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adb", "com/android/tools/idea/ddms/adb/AdbService$Ddmlib", "initialize"));
            }
            boolean forceRestart = true;
            if (!this.myDdmLibInitialized) {
                this.myDdmLibInitialized = true;
                this.ourDdmLibTerminated = false;
                DdmPreferences.setLogLevel((String)Log.LogLevel.INFO.getStringValue());
                DdmPreferences.setTimeOut((int)3000000);
                AndroidDebugBridge.init((boolean)AndroidEnableAdbServiceAction.isAdbServiceEnabled());
                LOG.info("DDMLib initialized");
            } else {
                AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
                boolean bl = forceRestart = bridge != null && !bridge.isConnected();
                if (forceRestart) {
                    LOG.info("Force restarting bridge: currently not connected.");
                }
            }
            this.myBridge = AndroidDebugBridge.createBridge((String)adb.getPath(), (boolean)forceRestart);
        }

        public synchronized boolean isConnectionInProgress() {
            return !this.isConnected() && !this.ourDdmLibTerminated;
        }

        public synchronized boolean isConnected() {
            return this.myBridge.isConnected();
        }

        public synchronized void terminate() {
            this.ourDdmLibTerminated = true;
            AndroidDebugBridge.disconnectBridge();
            AndroidDebugBridge.terminate();
            this.myDdmLibInitialized = false;
            LOG.info("DDMLib terminated");
        }
    }

    private static class BridgeConnectorTask
    implements Runnable {
        private static final long TIMEOUT_MS = 10000L;
        private final CountDownLatch myCancelLatch;
        private final Ddmlib myDdmlib;
        private final SettableFuture<AndroidDebugBridge> myResult;
        private final File myAdb;

        public BridgeConnectorTask(File adb, @NotNull Ddmlib ddmlib, @NotNull SettableFuture<AndroidDebugBridge> result) {
            if (ddmlib == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ddmlib", "com/android/tools/idea/ddms/adb/AdbService$BridgeConnectorTask", "<init>"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/ddms/adb/AdbService$BridgeConnectorTask", "<init>"));
            }
            this.myCancelLatch = new CountDownLatch(1);
            this.myAdb = adb;
            this.myDdmlib = ddmlib;
            this.myResult = result;
        }

        @Override
        public void run() {
            AdbErrors.clear();
            this.myDdmlib.initialize(this.myAdb);
            long startTime = System.currentTimeMillis();
            while (!this.myDdmlib.isConnected()) {
                if (this.myDdmlib.isConnectionInProgress()) {
                    try {
                        if (this.myCancelLatch.await(200L, TimeUnit.MILLISECONDS)) {
                        }
                    }
                    catch (InterruptedException ignore) {}
                    break;
                }
                if (System.currentTimeMillis() <= startTime + 10000L) continue;
            }
            if (this.myDdmlib.isConnected()) {
                this.myResult.set((Object)AndroidDebugBridge.getBridge());
            } else {
                this.myResult.setException((Throwable)new CancellationException());
            }
        }

        public void cancel() {
            this.myCancelLatch.countDown();
        }
    }
}

