/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.DefaultSdks;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import java.io.File;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkModuleCustomizer
implements ModuleCustomizer<IdeaAndroidProject> {
    private static final Logger LOG = Logger.getInstance(AndroidSdkModuleCustomizer.class);

    @Override
    public void customizeModule(@NotNull Module module, @NotNull Project project, @Nullable IdeaAndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/android/AndroidSdkModuleCustomizer", "customizeModule"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/android/AndroidSdkModuleCustomizer", "customizeModule"));
        }
        if (androidProject == null) {
            return;
        }
        File androidSdkHomePath = DefaultSdks.getDefaultAndroidHome();
        if (androidSdkHomePath == null) {
            return;
        }
        String compileTarget = androidProject.getDelegate().getCompileTarget();
        Sdk sdk = AndroidSdkUtils.findSuitableAndroidSdk(compileTarget);
        if (sdk == null) {
            sdk = AndroidSdkUtils.tryToCreateAndroidSdk(androidSdkHomePath, compileTarget);
        }
        if (sdk != null) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)sdk);
            return;
        }
        String text = String.format("Module '%1$s': platform '%2$s' not found.", module.getName(), compileTarget);
        LOG.info(text);
        Message msg = new Message("Failed to set up SDK", Message.Type.ERROR, text);
        ProjectSyncMessages.getInstance(project).add(msg, new NotificationHyperlink[0]);
    }
}

