/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.BuildFileStatementFactory;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class Dependency
extends BuildFileStatement {
    private static final Logger LOG = Logger.getInstance(Dependency.class);
    @NonNls
    private static final String FILE_TREE_BASE_DIR_PROPERTY = "dir";
    @NonNls
    private static final String FILE_TREE_INCLUDE_PATTERN_PROPERTY = "include";
    public Scope scope;
    public Type type;
    public Object data;
    public String extraClosure;

    public Dependency(@NotNull Scope scope, @NotNull Type type, @NotNull Object data, @Nullable String extraClosure) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/parser/Dependency", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/parser/Dependency", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/gradle/parser/Dependency", "<init>"));
        }
        this.scope = scope;
        this.type = type;
        this.data = data;
        this.extraClosure = extraClosure;
    }

    public Dependency(@NotNull Scope scope, @NotNull Type type, @NotNull Object data) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/android/tools/idea/gradle/parser/Dependency", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/parser/Dependency", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/gradle/parser/Dependency", "<init>"));
        }
        this(scope, type, data, null);
    }

    @Override
    @NotNull
    public List<PsiElement> getGroovyElements(@NotNull GroovyPsiElementFactory factory) {
        String extraGroovyCode;
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/android/tools/idea/gradle/parser/Dependency", "getGroovyElements"));
        }
        switch (this.type) {
            case EXTERNAL: {
                if (this.extraClosure != null) {
                    extraGroovyCode = "('" + BuildFileKey.escapeLiteralString(this.data) + "')";
                    break;
                }
                extraGroovyCode = " '" + BuildFileKey.escapeLiteralString(this.data) + "'";
                break;
            }
            case MODULE: {
                extraGroovyCode = this.data instanceof Map ? " project(" + GradleGroovyFile.convertMapToGroovySource((Map)this.data) + ")" : " project('" + BuildFileKey.escapeLiteralString(this.data) + "')";
                if (this.extraClosure == null) break;
                extraGroovyCode = "(" + extraGroovyCode.substring(1) + ")";
                break;
            }
            case FILES: {
                extraGroovyCode = " files('" + BuildFileKey.escapeLiteralString(this.data) + "')";
                break;
            }
            case FILETREE: {
                extraGroovyCode = " fileTree(" + GradleGroovyFile.convertMapToGroovySource((Map)this.data) + ")";
                break;
            }
            default: {
                extraGroovyCode = "";
            }
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)(this.scope.getGroovyMethodCall() + extraGroovyCode));
        if (statement instanceof GrMethodCall && this.extraClosure != null) {
            statement.add((PsiElement)factory.createClosureFromText(this.extraClosure));
        }
        ImmutableList immutableList = ImmutableList.of((Object)statement);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency", "getGroovyElements"));
        }
        return immutableList;
    }

    public boolean matches(@NotNull Dependency dependency) {
        List includes;
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/parser/Dependency", "matches"));
        }
        if (this.equals(dependency)) {
            return true;
        }
        if (this.scope != dependency.scope) {
            return false;
        }
        String s1 = this.data.toString();
        String s2 = dependency.data.toString();
        switch (this.type) {
            default: {
                if (dependency.type != Type.MODULE) {
                    return false;
                }
                if (this.data instanceof Map) {
                    s1 = GradleGroovyFile.convertMapToGroovySource((Map)this.data).replaceAll("path: ':", "path: '");
                }
                if (dependency.data instanceof Map) {
                    s2 = GradleGroovyFile.convertMapToGroovySource((Map)dependency.data).replaceAll("path: ':", "path: '");
                }
                if (s1.startsWith(":")) {
                    s1 = s1.substring(1);
                }
                if (s2.startsWith(":")) {
                    s2 = s2.substring(1);
                }
                return s1.equals(s2);
            }
            case EXTERNAL: {
                if (dependency.type != Type.EXTERNAL) {
                    return false;
                }
                if (s1.startsWith("com.android.support:appcompat-v7") && s2.startsWith("com.android.support:support-v4")) {
                    return true;
                }
                String[] tokens1 = s1.split(":");
                String[] tokens2 = s2.split(":");
                if (tokens1.length < 2 || tokens2.length < 2) {
                    return false;
                }
                return tokens1[0].equals(tokens2[0]) && tokens1[1].equals(tokens2[1]);
            }
            case FILES: {
                if (dependency.type != Type.FILES) {
                    return false;
                }
                return FileUtil.pathsEqual((String)s1, (String)s2);
            }
            case FILETREE: 
        }
        if (dependency.type != Type.FILES) {
            return false;
        }
        Map values = (Map)this.data;
        String dir = (String)values.get(FILE_TREE_BASE_DIR_PROPERTY);
        Object value = values.get(FILE_TREE_INCLUDE_PATTERN_PROPERTY);
        if (value == null) {
            return false;
        }
        List list = includes = value instanceof List ? (List)value : ImmutableList.of((Object)value.toString());
        if (dir == null || includes == null) {
            return false;
        }
        File baseDir = new File(dir);
        File depFile = new File(s2);
        File depDir = depFile.getParentFile();
        if (depDir == null) {
            return false;
        }
        if (FileUtil.filesEqual((File)baseDir, (File)depDir)) {
            for (String glob : includes) {
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)glob));
                if (!pattern.matcher(depFile.getName()).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.scope != that.scope) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scope, this.type, this.data});
    }

    public String toString() {
        return "Dependency {myScope=" + (Object)((Object)this.scope) + ", myType=" + (Object)((Object)this.type) + ", myData='" + this.data + '\'' + '}';
    }

    @NotNull
    public String getValueAsString() {
        String string = this.data.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency", "getValueAsString"));
        }
        return string;
    }

    public static ValueFactory getFactory() {
        return new DependencyFactory();
    }

    private static class DependencyFactory
    extends BuildFileStatementFactory {
        private DependencyFactory() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public List<BuildFileStatement> getValues(@NotNull PsiElement statement) {
            ArrayList dependencies;
            block25: {
                GroovyPsiElement[] allArguments;
                String extraClosure;
                Scope scope;
                GrMethodCall call;
                block26: {
                    GroovyPsiElement element;
                    block27: {
                        String methodName;
                        GrMethodCall method;
                        block28: {
                            if (statement == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory", "getValues"));
                            }
                            if (!(statement instanceof GrMethodCall)) {
                                List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                                if (list == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory", "getValues"));
                                }
                                return list;
                            }
                            call = (GrMethodCall)statement;
                            scope = Scope.fromMethodCall(GradleGroovyFile.getMethodCallName(call));
                            if (scope == null) {
                                List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                                if (list == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory", "getValues"));
                                }
                                return list;
                            }
                            extraClosure = null;
                            GrClosableBlock[] closureArguments = ((GrMethodCall)statement).getClosureArguments();
                            if (closureArguments.length > 0) {
                                extraClosure = closureArguments[0].getText();
                            }
                            GrArgumentList argumentList = call.getArgumentList();
                            dependencies = Lists.newArrayList();
                            allArguments = argumentList.getAllArguments();
                            if (allArguments.length != 1) break block26;
                            element = allArguments[0];
                            if (!(element instanceof GrMethodCall)) break block27;
                            method = (GrMethodCall)element;
                            methodName = GradleGroovyFile.getMethodCallName(method);
                            if (!"project".equals(methodName)) break block28;
                            Object value = GradleGroovyFile.getFirstLiteralArgumentValue(method);
                            if (value != null) {
                                dependencies.add(new Dependency(scope, Type.MODULE, value.toString(), extraClosure));
                                break block25;
                            } else {
                                Map<String, Object> values = GradleGroovyFile.getNamedArgumentValues(method);
                                if (!values.isEmpty()) {
                                    dependencies.add(new Dependency(scope, Type.MODULE, values, extraClosure));
                                }
                            }
                            break block25;
                        }
                        if ("files".equals(methodName)) {
                            for (Object o : GradleGroovyFile.getLiteralArgumentValues(method)) {
                                dependencies.add(new Dependency(scope, Type.FILES, o.toString(), extraClosure));
                            }
                            break block25;
                        } else if ("fileTree".equals(methodName)) {
                            Map<String, Object> values = GradleGroovyFile.getNamedArgumentValues(method);
                            dependencies.add(new Dependency(scope, Type.FILETREE, values, extraClosure));
                            break block25;
                        } else {
                            LOG.warn("Didn't know how to parse dependency method call " + methodName);
                        }
                        break block25;
                    }
                    if (element instanceof GrLiteral) {
                        Object value = ((GrLiteral)element).getValue();
                        if (value != null) {
                            dependencies.add(new Dependency(scope, Type.EXTERNAL, value.toString(), extraClosure));
                        }
                        break block25;
                    } else {
                        List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory", "getValues"));
                        }
                        return list;
                    }
                }
                if (allArguments.length > 1) {
                    Map<String, Object> attributes = GradleGroovyFile.getNamedArgumentValues(call);
                    if (attributes.isEmpty()) {
                        List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory", "getValues"));
                        }
                        return list;
                    }
                    Object groupId = attributes.get("group");
                    Object artifactId = attributes.get("name");
                    Object version = attributes.get("version");
                    Object ext = attributes.get("ext");
                    if (groupId == null || artifactId == null || version == null) {
                        List<BuildFileStatement> list = DependencyFactory.getUnparseableStatements(statement);
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory", "getValues"));
                        }
                        return list;
                    }
                    String coordinate = Joiner.on((String)":").join(groupId, artifactId, new Object[]{version});
                    if (ext != null) {
                        coordinate = coordinate + "@" + ext;
                    }
                    dependencies.add(new Dependency(scope, Type.EXTERNAL, coordinate, extraClosure));
                }
            }
            ArrayList arrayList = dependencies;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$DependencyFactory", "getValues"));
            }
            return arrayList;
        }
    }

    public static enum Type {
        FILES,
        FILETREE,
        EXTERNAL,
        MODULE;

    }

    public static enum Scope {
        COMPILE("Compile", "compile", true, true),
        PROVIDED("Provided", "provided", true, false),
        APK("APK", "apk", true, false),
        ANDROID_TEST_COMPILE("Test compile", "androidTestCompile", true, false),
        DEBUG_COMPILE("Debug compile", "debugCompile", true, false),
        RELEASE_COMPILE("Release compile", "releaseCompile", true, false),
        RUNTIME("Runtime", "runtime", false, true),
        TEST_COMPILE("Test compile", "testCompile", false, true),
        TEST_RUNTIME("Test runtime", "testRuntime", false, true);

        private final String myGroovyMethodCall;
        private final String myDisplayName;
        private final boolean myAndroidScope;
        private final boolean myJavaScope;

        private Scope(String displayName, String groovyMethodCall, boolean androidScope, boolean javaScope) {
            if (displayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/android/tools/idea/gradle/parser/Dependency$Scope", "<init>"));
            }
            if (groovyMethodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groovyMethodCall", "com/android/tools/idea/gradle/parser/Dependency$Scope", "<init>"));
            }
            this.myDisplayName = displayName;
            this.myGroovyMethodCall = groovyMethodCall;
            this.myAndroidScope = androidScope;
            this.myJavaScope = javaScope;
        }

        public String getGroovyMethodCall() {
            return this.myGroovyMethodCall;
        }

        @Nullable
        public static Scope fromMethodCall(@NotNull String methodCall) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/android/tools/idea/gradle/parser/Dependency$Scope", "fromMethodCall"));
            }
            for (Scope scope : Scope.values()) {
                if (!scope.myGroovyMethodCall.equals(methodCall)) continue;
                return scope;
            }
            return null;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$Scope", "getDisplayName"));
            }
            return string;
        }

        public boolean isAndroidScope() {
            return this.myAndroidScope;
        }

        public boolean isJavaScope() {
            return this.myJavaScope;
        }

        @NotNull
        public String toString() {
            String string = this.myDisplayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/parser/Dependency$Scope", "toString"));
            }
            return string;
        }
    }
}

