/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.IdeaJavaProject;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.CompilerOutputModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.ContentRootModuleCustomizer;
import com.android.tools.idea.gradle.customizer.java.DependenciesModuleCustomizer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaProjectDataService
implements ProjectDataService<IdeaJavaProject, Void> {
    private static final Logger LOG = Logger.getInstance(JavaProjectDataService.class);
    private final List<ModuleCustomizer<IdeaJavaProject>> myCustomizers = ImmutableList.of((Object)new ContentRootModuleCustomizer(), (Object)new DependenciesModuleCustomizer(), (Object)new CompilerOutputModuleCustomizer());

    @NotNull
    public Key<IdeaJavaProject> getTargetDataKey() {
        Key<IdeaJavaProject> key = AndroidProjectKeys.IDE_JAVA_PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/JavaProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<IdeaJavaProject>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/android/tools/idea/gradle/service/JavaProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/JavaProjectDataService", "importData"));
        }
        if (!toImport.isEmpty()) {
            try {
                this.doImport(toImport, project);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up Java modules in project '%1$s'", project.getName()), e);
                GradleSyncState.getInstance(project).syncFailed(e.getMessage());
            }
        }
    }

    private void doImport(final Collection<DataNode<IdeaJavaProject>> toImport, final Project project) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                if (!project.isDisposed()) {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                    Map gradleProjectsByName = JavaProjectDataService.indexByModuleName(toImport);
                    for (Module module : moduleManager.getModules()) {
                        IdeaJavaProject javaProject = (IdeaJavaProject)gradleProjectsByName.get(module.getName());
                        if (javaProject == null) continue;
                        JavaProjectDataService.this.customizeModule(module, javaProject);
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    @NotNull
    private static Map<String, IdeaJavaProject> indexByModuleName(@NotNull Collection<DataNode<IdeaJavaProject>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/android/tools/idea/gradle/service/JavaProjectDataService", "indexByModuleName"));
        }
        HashMap javaProjectsByModuleName = Maps.newHashMap();
        for (DataNode<IdeaJavaProject> d : dataNodes) {
            IdeaJavaProject javaProject = (IdeaJavaProject)d.getData();
            javaProjectsByModuleName.put(javaProject.getModuleName(), javaProject);
        }
        HashMap hashMap = javaProjectsByModuleName;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/service/JavaProjectDataService", "indexByModuleName"));
        }
        return hashMap;
    }

    private void customizeModule(@NotNull Module module, @NotNull IdeaJavaProject javaProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/service/JavaProjectDataService", "customizeModule"));
        }
        if (javaProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaProject", "com/android/tools/idea/gradle/service/JavaProjectDataService", "customizeModule"));
        }
        for (ModuleCustomizer<IdeaJavaProject> customizer : this.myCustomizers) {
            customizer.customizeModule(module, module.getProject(), javaProject);
        }
    }

    public void removeData(@NotNull Collection<? extends Void> toRemove, @NotNull Project project, boolean synchronous) {
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/android/tools/idea/gradle/service/JavaProjectDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/JavaProjectDataService", "removeData"));
        }
    }
}

