/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.welcome.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.InstallComponentsPath;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Joiner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public final class Haxm
extends InstallableComponent {
    public static final Storage.Unit UI_UNITS = Storage.Unit.MiB;
    public static final Logger LOG = Logger.getInstance(Haxm.class);
    public static final String COMPONENT_VENDOR = "intel";
    public static final String COMPONENT_PATH = "Hardware_Accelerated_Execution_Manager";
    private static final ScopedStateStore.Key<Boolean> KEY_INSTALL_HAXM = ScopedStateStore.createKey("install.haxm", ScopedStateStore.Scope.PATH, Boolean.class);
    private static final ScopedStateStore.Key<Integer> KEY_EMULATOR_MEMORY_MB = ScopedStateStore.createKey("emulator.memory", ScopedStateStore.Scope.PATH, Integer.class);
    private static long memorySize = -1L;
    private final ScopedStateStore.Key<Boolean> myIsCustomInstall;
    private ScopedStateStore myState;
    private ProgressStep myProgressStep;

    public Haxm(ScopedStateStore.Key<Boolean> isCustomInstall) {
        super("SDK Emulator Extra - Intel\u00ae HAXM", 0x233333L, KEY_INSTALL_HAXM);
        this.myIsCustomInstall = isCustomInstall;
    }

    public static boolean canRun() {
        if (Boolean.getBoolean("install.haxm") && (SystemInfo.isWindows || SystemInfo.isMac)) {
            return Haxm.getMemorySize() >= Storage.Unit.GiB.getNumberOfBytes();
        }
        return false;
    }

    @NotNull
    private static GeneralCommandLine getMacHaxmInstallCommandLine(File source, int memorySize) {
        String shellScript = Haxm.getAbsolutePathString(source, "silent_install.sh");
        String diskImage = Haxm.getAbsolutePathString(source, "IntelHAXM_1.1.0_below_10.10.dmg");
        Object[] installerInvocation = new String[]{"/bin/bash", shellScript, "-f", diskImage, "-m", String.valueOf(memorySize)};
        String appleScript = String.format("do shell script \"%s\" with administrator privileges", Joiner.on((String)" ").join(installerInvocation));
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath("/usr/bin/osascript");
        commandLine.setWorkDirectory(source);
        commandLine.addParameters(new String[]{"-e", appleScript});
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getMacHaxmInstallCommandLine"));
        }
        return generalCommandLine;
    }

    private static String getAbsolutePathString(File source, String filename) {
        return "'" + new File(source, filename).getAbsolutePath() + "'";
    }

    @NotNull
    private static GeneralCommandLine getWindowsHaxmInstallCommandLine(File source, int memorySize) {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(new File(source, "silent_install.bat").getAbsolutePath());
        commandLine.setWorkDirectory(source);
        commandLine.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getWindowsHaxmInstallCommandLine"));
        }
        return generalCommandLine;
    }

    private static int getRecommendedMemoryAllocation() {
        return FirstRunWizardDefaults.getRecommendedHaxmMemory(Haxm.getMemorySize());
    }

    public static long getMemorySize() {
        if (memorySize < 0L) {
            memorySize = Haxm.checkMemorySize();
        }
        return memorySize;
    }

    private static long checkMemorySize() {
        OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> oracleSpecificMXBean = Class.forName("com.sun.management.OperatingSystemMXBean");
            Method getPhysicalMemorySizeMethod = oracleSpecificMXBean.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            Object result = getPhysicalMemorySizeMethod.invoke((Object)osMXBean, new Object[0]);
            if (result instanceof Number) {
                return ((Number)result).longValue();
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return 32L * Storage.Unit.GiB.getNumberOfBytes();
    }

    @Override
    public void init(@NotNull ScopedStateStore state, @NotNull ProgressStep progressStep) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/welcome/Haxm", "init"));
        }
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/Haxm", "init"));
        }
        this.myState = state;
        this.myProgressStep = progressStep;
        state.put(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        state.put(KEY_INSTALL_HAXM, true);
    }

    @Override
    public DynamicWizardStep[] createSteps() {
        return new DynamicWizardStep[]{new HaxmInstallSettingsStep(this.myIsCustomInstall, KEY_INSTALL_HAXM, KEY_EMULATOR_MEMORY_MB)};
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdk) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/Haxm", "configure"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/Haxm", "configure"));
        }
        if (!Haxm.canRun()) {
            Logger.getInstance(this.getClass()).error("Tried to install HAXM on %s OS with %s memory size", new String[]{Platform.current().name(), String.valueOf(Haxm.getMemorySize())});
            installContext.print("Unable to install Intel HAXM", ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        GeneralCommandLine commandLine = this.getCommandLine(sdk);
        try {
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            this.myProgressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                this.myProgressStep.print("HAXM installation failed. To install HAXM follow the instructions found at http://www.intel.com/software/android/.", ConsoleViewContentType.ERROR_OUTPUT);
            } else {
                this.myProgressStep.print("Completed HAXM installation\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Intel HAXM installer: " + e.getMessage(), ConsoleViewContentType.ERROR_OUTPUT);
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private GeneralCommandLine getCommandLine(File sdk) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        progressIndicator.setIndeterminate(true);
        progressIndicator.setText("Running Intel\u00ae HAXM installer");
        int memorySize = this.myState.getNotNull(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        String path = FileUtil.join((String[])new String[]{"extras", COMPONENT_VENDOR, COMPONENT_PATH});
        File sourceLocation = new File(sdk, path);
        if (SystemInfo.isMac) {
            GeneralCommandLine generalCommandLine = Haxm.getMacHaxmInstallCommandLine(sourceLocation, memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getCommandLine"));
            }
            return generalCommandLine;
        }
        if (SystemInfo.isWindows) {
            GeneralCommandLine generalCommandLine = Haxm.getWindowsHaxmInstallCommandLine(sourceLocation, memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getCommandLine"));
            }
            return generalCommandLine;
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Usupported OS");
    }

    @Override
    @NotNull
    public PkgDesc.Builder[] getRequiredSdkPackages() {
        PkgDesc.Builder[] builderArray = new PkgDesc.Builder[]{InstallComponentsPath.createExtra(true, COMPONENT_VENDOR, COMPONENT_PATH)};
        if (builderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/Haxm", "getRequiredSdkPackages"));
        }
        return builderArray;
    }
}

