/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.ProgressStep;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.ThrowableComputable;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallContext {
    private final File myTempDirectory;
    @Nullable
    private final ProgressStep myProgressStep;

    InstallContext(@NotNull File tempDirectory) {
        if (tempDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirectory", "com/android/tools/idea/welcome/InstallContext", "<init>"));
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myTempDirectory = tempDirectory;
        this.myProgressStep = null;
    }

    public InstallContext(@NotNull File tempDirectory, @NotNull ProgressStep progressStep) {
        if (tempDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDirectory", "com/android/tools/idea/welcome/InstallContext", "<init>"));
        }
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/InstallContext", "<init>"));
        }
        this.myTempDirectory = tempDirectory;
        this.myProgressStep = progressStep;
    }

    public File getTempDirectory() {
        return this.myTempDirectory;
    }

    public boolean isCanceled() {
        return this.myProgressStep != null && this.myProgressStep.isCanceled();
    }

    public void print(String message, ConsoleViewContentType contentType) {
        if (this.myProgressStep != null) {
            this.myProgressStep.print(message, contentType);
        } else if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    public <R, E extends Exception> R run(ThrowableComputable<R, E> operation, double progressRatio) throws E {
        Wrapper<R, E> wrapper = new Wrapper<R, E>(operation);
        if (this.myProgressStep != null) {
            this.myProgressStep.run(wrapper, progressRatio);
        } else {
            ProgressManager.getInstance().executeProcessUnderProgress(wrapper, (ProgressIndicator)new TestingProgressIndicator());
        }
        return (R)((Wrapper)wrapper).getResult();
    }

    public void advance(double progress) {
        if (this.myProgressStep != null) {
            this.myProgressStep.advance(progress);
        }
    }

    private static class Wrapper<R, E extends Exception>
    implements Runnable {
        private final ThrowableComputable<R, E> myRunnable;
        private volatile R myResult;
        private volatile E myException;

        public Wrapper(ThrowableComputable<R, E> runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.myResult = this.myRunnable.compute();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.myException = e;
            }
        }

        private R getResult() throws E {
            if (this.myException != null) {
                throw this.myException;
            }
            return this.myResult;
        }
    }

    private static class TestingProgressIndicator
    extends ProgressIndicatorBase {
        private int previous = 0;

        private TestingProgressIndicator() {
        }

        public void setText(String text) {
            System.out.println(text);
        }

        public void setText2(String text) {
            System.out.println("Text2: " + text);
        }

        public void setFraction(double fraction) {
            int p = (int)Math.floor(fraction * 20.0);
            if (p > this.previous) {
                this.previous = p;
                System.out.print(".");
            }
        }
    }
}

