/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.actions.CreateResourceFileActionGroup;
import org.jetbrains.android.actions.CreateResourceFileDialog;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceFileAction
extends CreateElementActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.CreateResourceFileAction");
    private final Map<String, CreateTypedResourceFileAction> mySubactions = new HashMap<String, CreateTypedResourceFileAction>();
    private String myRootElement;
    private boolean myNavigate;

    @NotNull
    public static CreateResourceFileAction getInstance() {
        AnAction action = ActionManager.getInstance().getAction("Android.CreateResourcesActionGroup");
        assert (action instanceof CreateResourceFileActionGroup);
        CreateResourceFileAction createResourceFileAction = ((CreateResourceFileActionGroup)action).getCreateResourceFileAction();
        if (createResourceFileAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "getInstance"));
        }
        return createResourceFileAction;
    }

    public CreateResourceFileAction() {
        super(AndroidBundle.message("new.resource.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), StdFileTypes.XML.getIcon());
    }

    public void add(CreateTypedResourceFileAction action) {
        this.mySubactions.put(action.getResourceType(), action);
    }

    public Collection<CreateTypedResourceFileAction> getSubactions() {
        return this.mySubactions.values();
    }

    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        final PsiElement element = (PsiElement)context.getData(DataKeys.PSI_ELEMENT.getName());
        if (!(element instanceof PsiDirectory) || AndroidFacet.getInstance(element) == null) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return AndroidResourceUtil.isResourceDirectory((PsiDirectory)element);
            }
        });
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, boolean navigate) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        PsiElement[] elements = CreateResourceFileAction.doCreateFileResource(facet, resType, resName, rootElement, config, chooseResName, dialogTitle, navigate);
        if (elements.length == 0) {
            return null;
        }
        assert (elements.length == 1 && elements[0] instanceof XmlFile);
        return (XmlFile)elements[0];
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/actions/CreateResourceFileAction", "createFileResource"));
        }
        return CreateResourceFileAction.createFileResource(facet, resType, resName, rootElement, config, chooseResName, dialogTitle, true);
    }

    @NotNull
    private static PsiElement[] doCreateFileResource(@NotNull AndroidFacet facet, @NotNull ResourceType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, boolean navigate) {
        PsiDirectory psiResDir;
        Module selectedModule;
        String subdirName;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
        }
        if (resType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resType", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
        }
        final CreateResourceFileAction action = CreateResourceFileAction.getInstance();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            subdirName = resType.getName();
            selectedModule = facet.getModule();
        } else {
            MyDialog dialog = new MyDialog(facet, action.mySubactions.values(), resType, resName, rootElement, config, chooseResName, action, facet.getModule(), true);
            dialog.setNavigate(navigate);
            if (dialogTitle != null) {
                dialog.setTitle(dialogTitle);
            }
            dialog.show();
            if (!dialog.isOK()) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            if (chooseResName) {
                resName = dialog.getFileName();
            }
            subdirName = dialog.getSubdirName();
            selectedModule = dialog.getSelectedModule();
        }
        AndroidFacet selectedFacet = AndroidFacet.getInstance(selectedModule);
        LOG.assertTrue(selectedFacet != null);
        VirtualFile resourceDir = selectedFacet.getPrimaryResourceDir();
        final Project project = facet.getModule().getProject();
        PsiDirectory psiDirectory = psiResDir = resourceDir != null ? PsiManager.getInstance((Project)project).findDirectory(resourceDir) : null;
        if (psiResDir == null) {
            Messages.showErrorDialog((Project)project, (String)("Cannot find resource directory for module " + selectedFacet.getModule().getName()), (String)CommonBundle.getErrorTitle());
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        final String finalResName = resName;
        PsiElement[] elements = (PsiElement[])ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiElement[]>(){

            @Nullable
            public PsiElement[] compute() {
                CreateElementActionBase.MyInputValidator validator = action.createValidator(project, psiResDir, subdirName);
                return validator.checkInput(finalResName) && validator.canClose(finalResName) ? validator.getCreatedElements() : null;
            }
        });
        PsiElement[] psiElementArray = elements != null ? elements : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "doCreateFileResource"));
        }
        return psiElementArray;
    }

    @NotNull
    protected PsiElement[] invokeDialog(final Project project, final PsiDirectory directory) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)directory);
        LOG.assertTrue(facet != null);
        MyDialog dialog = new MyDialog(facet, this.mySubactions.values(), null, null, null, null, true, this, facet.getModule(), false){

            @Override
            protected InputValidator createValidator(@NotNull String subdirName) {
                if (subdirName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subdirName", "org/jetbrains/android/actions/CreateResourceFileAction$3", "createValidator"));
                }
                return CreateResourceFileAction.this.createValidator(project, directory, subdirName);
            }
        };
        dialog.show();
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "invokeDialog"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    private CreateElementActionBase.MyInputValidator createValidator(Project project, final PsiDirectory resDir, final String subdirName) {
        PsiDirectory resSubdir = resDir.findSubdirectory(subdirName);
        if (resSubdir == null) {
            resSubdir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                public PsiDirectory compute() {
                    return resDir.createSubdirectory(subdirName);
                }
            });
        }
        CreateElementActionBase.MyInputValidator myInputValidator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, resSubdir);
        if (myInputValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "createValidator"));
        }
        return myInputValidator;
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        CreateTypedResourceFileAction action = this.getActionByDir(directory);
        if (action == null) {
            throw new IllegalArgumentException("Incorrect directory");
        }
        if (this.myRootElement != null && this.myRootElement.length() > 0) {
            PsiElement[] psiElementArray = action.doCreateAndNavigate(newName, directory, this.myRootElement, false, this.myNavigate);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "create"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = action.create(newName, directory);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/actions/CreateResourceFileAction", "create"));
        }
        return psiElementArray;
    }

    private CreateTypedResourceFileAction getActionByDir(PsiDirectory directory) {
        String baseDirName = directory.getName();
        int index = baseDirName.indexOf("-");
        if (index >= 0) {
            baseDirName = baseDirName.substring(0, index);
        }
        return this.mySubactions.get(baseDirName);
    }

    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    protected String getCommandName() {
        return AndroidBundle.message("new.resource.command.name", new Object[0]);
    }

    @Nullable
    protected String getActionName(PsiDirectory directory, String newName) {
        return CreateResourceFileAction.doGetActionName(directory, newName);
    }

    static String doGetActionName(PsiDirectory directory, String newName) {
        if (FileUtilRt.getExtension((String)newName).length() == 0) {
            newName = newName + ".xml";
        }
        return AndroidBundle.message("new.resource.action.name", directory.getName() + File.separator + newName);
    }

    private static class MyDialog
    extends CreateResourceFileDialog {
        private final CreateResourceFileAction myAction;
        private boolean myNavigate;

        protected MyDialog(@NotNull AndroidFacet facet, Collection<CreateTypedResourceFileAction> actions, @Nullable ResourceType predefinedResourceType, @Nullable String predefinedFileName, @Nullable String predefinedRootElement, @Nullable FolderConfiguration predefinedConfig, boolean chooseFileName, @NotNull CreateResourceFileAction action, @NotNull Module module, boolean chooseModule) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/actions/CreateResourceFileAction$MyDialog", "<init>"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/android/actions/CreateResourceFileAction$MyDialog", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/actions/CreateResourceFileAction$MyDialog", "<init>"));
            }
            super(facet, actions, predefinedResourceType, predefinedFileName, predefinedRootElement, predefinedConfig, chooseFileName, module, chooseModule);
            this.myNavigate = true;
            this.myAction = action;
        }

        @Override
        protected void doOKAction() {
            this.myAction.myRootElement = this.getRootElement();
            this.myAction.myNavigate = this.myNavigate;
            super.doOKAction();
        }

        public void setNavigate(boolean navigate) {
            this.myNavigate = navigate;
        }
    }
}

