/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCompareBranchesDialog;
import git4idea.update.GitFetchResult;
import git4idea.update.GitFetcher;
import git4idea.util.GitCommitCompareInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubBranch;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubPullRequest;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubRepoDetailed;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.ui.GithubSelectForkDialog;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubProjectSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreatePullRequestWorker {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String CANNOT_CREATE_PULL_REQUEST = "Can't Create Pull Request";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepository myGitRepository;
    @NotNull
    private final GithubAuthDataHolder myAuthHolder;
    @NotNull
    private final GithubFullPath myPath;
    @NotNull
    private final String myRemoteName;
    @NotNull
    private final String myRemoteUrl;
    @NotNull
    private final String myCurrentBranch;
    @NotNull
    private GithubFullPath mySource;
    @NotNull
    private final List<ForkInfo> myForks;
    @Nullable
    private List<GithubFullPath> myAvailableForks;

    private GithubCreatePullRequestWorker(@NotNull Project project, @NotNull Git git, @NotNull GitRepository gitRepository, @NotNull GithubAuthDataHolder authHolder, @NotNull GithubFullPath path, @NotNull String remoteName, @NotNull String remoteUrl, @NotNull String currentBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (gitRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRepository", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (authHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authHolder", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        if (currentBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentBranch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myGitRepository = gitRepository;
        this.myAuthHolder = authHolder;
        this.myPath = path;
        this.myRemoteName = remoteName;
        this.myRemoteUrl = remoteUrl;
        this.myCurrentBranch = currentBranch;
        this.myForks = new ArrayList<ForkInfo>();
    }

    @NotNull
    public String getCurrentBranch() {
        String string = this.myCurrentBranch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getCurrentBranch"));
        }
        return string;
    }

    @NotNull
    public List<ForkInfo> getForks() {
        List<ForkInfo> list = this.myForks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getForks"));
        }
        return list;
    }

    @Nullable
    public static GithubCreatePullRequestWorker create(final @NotNull Project project, final @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "create"));
        }
        return GithubUtil.computeValueInModal(project, "Loading data...", new Convertor<ProgressIndicator, GithubCreatePullRequestWorker>(){

            public GithubCreatePullRequestWorker convert(ProgressIndicator indicator) {
                GithubAuthDataHolder authHolder;
                Git git = (Git)ServiceManager.getService(Git.class);
                GitRepository gitRepository = GithubUtil.getGitRepository(project, file);
                if (gitRepository == null) {
                    GithubNotifications.showError(project, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "Can't find git repository");
                    return null;
                }
                gitRepository.update();
                Pair<GitRemote, String> remote = GithubUtil.findGithubRemote(gitRepository);
                if (remote == null) {
                    GithubNotifications.showError(project, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "Can't find GitHub remote");
                    return null;
                }
                String remoteName = ((GitRemote)remote.getFirst()).getName();
                String remoteUrl = (String)remote.getSecond();
                GithubFullPath path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remoteUrl);
                if (path == null) {
                    GithubNotifications.showError(project, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "Can't process remote: " + remoteUrl);
                    return null;
                }
                GitLocalBranch currentBranch = gitRepository.getCurrentBranch();
                if (currentBranch == null) {
                    GithubNotifications.showError(project, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "No current branch");
                    return null;
                }
                try {
                    authHolder = GithubUtil.getValidAuthDataHolderFromConfig(project, indicator);
                }
                catch (IOException e) {
                    GithubNotifications.showError(project, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, e);
                    return null;
                }
                GithubCreatePullRequestWorker worker = new GithubCreatePullRequestWorker(project, git, gitRepository, authHolder, path, remoteName, remoteUrl, currentBranch.getName());
                try {
                    worker.initForks(indicator);
                }
                catch (IOException e) {
                    GithubNotifications.showError(project, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, e);
                    return null;
                }
                return worker;
            }
        });
    }

    private void initForks(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "initForks"));
        }
        this.doLoadForksFromGithub(indicator);
        this.doLoadForksFromGit(indicator);
        this.doLoadForksFromSettings(indicator);
    }

    @Nullable
    private ForkInfo doAddFork(@NotNull GithubFullPath path, @Nullable String remoteName, @NotNull ProgressIndicator indicator) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doAddFork"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doAddFork"));
        }
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            if (fork.getRemoteName() == null && remoteName != null) {
                fork.setRemoteName(remoteName);
            }
            return fork;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = this.doLoadDefaultBranch(path, indicator);
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            if (remoteName != null) {
                fork.setRemoteName(remoteName);
            }
            return fork;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load branches for " + path.getFullName(), e);
            return null;
        }
    }

    @Nullable
    private ForkInfo doAddFork(@NotNull GithubRepo repo, @NotNull ProgressIndicator indicator) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doAddFork"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doAddFork"));
        }
        GithubFullPath path = repo.getFullPath();
        for (ForkInfo fork : this.myForks) {
            if (!fork.getPath().equals(path)) continue;
            return fork;
        }
        try {
            List<String> branches = this.loadBranches(path, indicator);
            String defaultBranch = repo.getDefaultBranch();
            ForkInfo fork = new ForkInfo(path, branches, defaultBranch);
            this.myForks.add(fork);
            return fork;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load branches for " + path.getFullName(), e);
            return null;
        }
    }

    private void doLoadForksFromSettings(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doLoadForksFromSettings"));
        }
        GithubFullPath savedRepo = GithubProjectSettings.getInstance(this.myProject).getCreatePullRequestDefaultRepo();
        if (savedRepo != null) {
            this.doAddFork(savedRepo, null, indicator);
        }
    }

    private void doLoadForksFromGit(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doLoadForksFromGit"));
        }
        block0: for (GitRemote remote : this.myGitRepository.getRemotes()) {
            for (String url : remote.getUrls()) {
                GithubFullPath path;
                if (!GithubUrlUtil.isGithubUrl(url) || (path = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url)) == null) continue;
                this.doAddFork(path, remote.getName(), indicator);
                continue block0;
            }
        }
    }

    private void doLoadForksFromGithub(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doLoadForksFromGithub"));
        }
        GithubRepoDetailed repo = GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, new ThrowableConvertor<GithubConnection, GithubRepoDetailed, IOException>(){

            @NotNull
            public GithubRepoDetailed convert(@NotNull GithubConnection connection) throws IOException {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$2", "convert"));
                }
                GithubRepoDetailed githubRepoDetailed = GithubApiUtil.getDetailedRepoInfo(connection, GithubCreatePullRequestWorker.this.myPath.getUser(), GithubCreatePullRequestWorker.this.myPath.getRepository());
                if (githubRepoDetailed == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$2", "convert"));
                }
                return githubRepoDetailed;
            }
        });
        this.doAddFork(repo, indicator);
        if (repo.getParent() != null) {
            this.doAddFork(repo.getParent(), indicator);
        }
        if (repo.getSource() != null) {
            this.doAddFork(repo.getSource(), indicator);
        }
        this.mySource = repo.getSource() == null ? repo.getFullPath() : repo.getSource().getFullPath();
    }

    @NotNull
    private List<String> loadBranches(final @NotNull GithubFullPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        if (fork == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fork", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "loadBranches"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "loadBranches"));
        }
        List list = ContainerUtil.map((Collection)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, new ThrowableConvertor<GithubConnection, List<GithubBranch>, IOException>(){

            public List<GithubBranch> convert(@NotNull GithubConnection connection) throws IOException {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$3", "convert"));
                }
                return GithubApiUtil.getRepoBranches(connection, fork.getUser(), fork.getRepository());
            }
        }), (Function)new Function<GithubBranch, String>(){

            public String fun(@NotNull GithubBranch branch) {
                if (branch == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$4", "fun"));
                }
                return branch.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "loadBranches"));
        }
        return list;
    }

    @Nullable
    private String doLoadDefaultBranch(final @NotNull GithubFullPath fork, @NotNull ProgressIndicator indicator) throws IOException {
        if (fork == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fork", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doLoadDefaultBranch"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doLoadDefaultBranch"));
        }
        GithubRepo repo = GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, new ThrowableConvertor<GithubConnection, GithubRepo, IOException>(){

            public GithubRepo convert(@NotNull GithubConnection connection) throws IOException {
                if (connection == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$5", "convert"));
                }
                return GithubApiUtil.getDetailedRepoInfo(connection, fork.getUser(), fork.getRepository());
            }
        });
        return repo.getDefaultBranch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchFetchRemote(final @NotNull ForkInfo fork) {
        if (fork == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fork", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "launchFetchRemote"));
        }
        if (fork.getRemoteName() == null) {
            return;
        }
        if (fork.getFetchTask() != null) {
            return;
        }
        Object object = fork.LOCK;
        synchronized (object) {
            if (fork.getFetchTask() != null) {
                return;
            }
            final MasterFutureTask<Void> task = new MasterFutureTask<Void>(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GithubCreatePullRequestWorker.this.doFetchRemote(fork);
                    return null;
                }
            });
            fork.setFetchTask(task);
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    task.run();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchLoadDiffInfo(final @NotNull BranchInfo branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "launchLoadDiffInfo"));
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            return;
        }
        if (branch.getDiffInfoTask() != null) {
            return;
        }
        Object object = branch.LOCK;
        synchronized (object) {
            if (branch.getDiffInfoTask() != null) {
                return;
            }
            this.launchFetchRemote(branch.getForkInfo());
            MasterFutureTask<Void> masterTask = branch.getForkInfo().getFetchTask();
            assert (masterTask != null);
            final SlaveFutureTask<DiffInfo> task = new SlaveFutureTask<DiffInfo>(masterTask, new Callable<DiffInfo>(){

                @Override
                public DiffInfo call() throws VcsException {
                    return GithubCreatePullRequestWorker.this.doLoadDiffInfo(branch);
                }
            });
            branch.setDiffInfoTask(task);
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    task.run();
                }
            });
        }
    }

    @Nullable
    public DiffInfo getDiffInfo(@NotNull BranchInfo branch) throws IOException {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDiffInfo"));
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            return null;
        }
        this.launchLoadDiffInfo(branch);
        assert (branch.getDiffInfoTask() != null);
        try {
            return (DiffInfo)branch.getDiffInfoTask().get();
        }
        catch (InterruptedException e) {
            throw new GithubOperationCanceledException(e);
        }
        catch (ExecutionException e) {
            Throwable ex = e.getCause();
            if (ex instanceof VcsException) {
                throw new IOException(ex);
            }
            LOG.error(ex);
            return null;
        }
    }

    private boolean doFetchRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fork", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doFetchRemote"));
        }
        if (fork.getRemoteName() == null) {
            return false;
        }
        GitFetchResult result = new GitFetcher(this.myProject, (ProgressIndicator)new EmptyProgressIndicator(), false).fetch(this.myGitRepository.getRoot(), fork.getRemoteName(), null);
        if (!result.isSuccess()) {
            GitFetcher.displayFetchResult((Project)this.myProject, (GitFetchResult)result, null, (Collection)result.getErrors());
            return false;
        }
        return true;
    }

    @NotNull
    private DiffInfo doLoadDiffInfo(@NotNull BranchInfo branch) throws VcsException {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doLoadDiffInfo"));
        }
        String currentBranch = this.myCurrentBranch;
        String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
        List commits1 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{".." + targetBranch});
        List commits2 = GitHistoryUtils.history((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String[])new String[]{targetBranch + ".."});
        Collection diff = GitChangeUtils.getDiff((Project)this.myProject, (VirtualFile)this.myGitRepository.getRoot(), (String)targetBranch, (String)this.myCurrentBranch, null);
        GitCommitCompareInfo info = new GitCommitCompareInfo(GitCommitCompareInfo.InfoType.BRANCH_TO_HEAD);
        info.put(this.myGitRepository, diff);
        info.put(this.myGitRepository, (Pair)Couple.of((Object)commits1, (Object)commits2));
        DiffInfo diffInfo = new DiffInfo(info, currentBranch, targetBranch);
        if (diffInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doLoadDiffInfo"));
        }
        return diffInfo;
    }

    private void doConfigureRemote(@NotNull ForkInfo fork) {
        if (fork == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fork", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doConfigureRemote"));
        }
        if (fork.getRemoteName() != null) {
            return;
        }
        GithubFullPath path = fork.getPath();
        String url = GithubUrlUtil.getCloneUrl(path);
        if (GithubUtil.addGithubRemote(this.myProject, this.myGitRepository, path.getUser(), url)) {
            fork.setRemoteName(path.getUser());
        }
    }

    public void configureRemote(final @NotNull ForkInfo fork) {
        if (fork == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fork", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "configureRemote"));
        }
        GithubUtil.computeValueInModal(this.myProject, "Creating remote..", false, new Consumer<ProgressIndicator>(){

            public void consume(ProgressIndicator indicator) {
                GithubCreatePullRequestWorker.this.doConfigureRemote(fork);
            }
        });
    }

    @NotNull
    public Couple<String> getDefaultDescriptionMessage(final @NotNull BranchInfo branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
        }
        Couple<String> message = branch.getDefaultMessage();
        if (message != null) {
            Couple<String> couple = message;
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
            }
            return couple;
        }
        if (branch.getForkInfo().getRemoteName() == null) {
            Couple<String> couple = this.getSimpleDefaultDescriptionMessage(branch);
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
            }
            return couple;
        }
        Couple<String> couple = GithubUtil.computeValueInModal(this.myProject, "Collecting additional data...", false, new Convertor<ProgressIndicator, Couple<String>>(){

            public Couple<String> convert(ProgressIndicator o) {
                String localBranch = GithubCreatePullRequestWorker.this.myCurrentBranch;
                String targetBranch = branch.getForkInfo().getRemoteName() + "/" + branch.getRemoteName();
                try {
                    List commits = GitHistoryUtils.readLastCommits((Project)GithubCreatePullRequestWorker.this.myProject, (VirtualFile)GithubCreatePullRequestWorker.this.myGitRepository.getRoot(), (String[])new String[]{localBranch, targetBranch});
                    if (commits == null) {
                        return GithubCreatePullRequestWorker.this.getSimpleDefaultDescriptionMessage(branch);
                    }
                    VcsCommitMetadata localCommit = (VcsCommitMetadata)commits.get(0);
                    VcsCommitMetadata targetCommit = (VcsCommitMetadata)commits.get(1);
                    if (localCommit.getParents().contains(targetCommit.getId())) {
                        return Couple.of((Object)localCommit.getSubject(), (Object)localCommit.getFullMessage());
                    }
                    return GithubCreatePullRequestWorker.this.getSimpleDefaultDescriptionMessage(branch);
                }
                catch (VcsException e) {
                    GithubNotifications.showWarning(GithubCreatePullRequestWorker.this.myProject, "Can't collect additional data", (Exception)((Object)e));
                    return GithubCreatePullRequestWorker.this.getSimpleDefaultDescriptionMessage(branch);
                }
            }
        });
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getDefaultDescriptionMessage"));
        }
        return couple;
    }

    @NotNull
    public Couple<String> getSimpleDefaultDescriptionMessage(@NotNull BranchInfo branch) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getSimpleDefaultDescriptionMessage"));
        }
        Couple message = Couple.of((Object)this.myCurrentBranch, (Object)"");
        branch.setDefaultMessage((Couple<String>)message);
        Couple couple = message;
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getSimpleDefaultDescriptionMessage"));
        }
        return couple;
    }

    public boolean checkAction(final @Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, CANNOT_CREATE_PULL_REQUEST, "Target branch is not selected");
            return false;
        }
        try {
            info = GithubUtil.computeValueInModal(this.myProject, "Collecting diff data...", new ThrowableConvertor<ProgressIndicator, DiffInfo, IOException>(){

                public DiffInfo convert(ProgressIndicator indicator) throws IOException {
                    return GithubUtil.runInterruptable(indicator, new ThrowableComputable<DiffInfo, IOException>(){

                        public DiffInfo compute() throws IOException {
                            return GithubCreatePullRequestWorker.this.getDiffInfo(branch);
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't collect diff data", e);
            return true;
        }
        if (info == null) {
            return true;
        }
        ForkInfo fork = branch.getForkInfo();
        String localBranchName = "'" + this.myCurrentBranch + "'";
        String targetBranchName = "'" + fork.getRemoteName() + "/" + branch.getRemoteName() + "'";
        if (info.getInfo().getBranchToHeadCommits(this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, "Do you want to proceed anyway?", "Empty pull request: the branch " + localBranchName + " is fully merged to the branch " + targetBranchName);
        }
        if (!info.getInfo().getHeadToBranchCommits(this.myGitRepository).isEmpty()) {
            return GithubNotifications.showYesNoDialog(this.myProject, "Do you want to proceed anyway?", "The branch " + targetBranchName + " is not fully merged to the branch " + localBranchName);
        }
        return true;
    }

    public void createPullRequest(final @NotNull BranchInfo branch, final @NotNull String title, final @NotNull String description) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "createPullRequest"));
        }
        new Task.Backgroundable(this.myProject, "Creating pull request..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$13", "run"));
                }
                LOG.info("Pushing current branch");
                indicator.setText("Pushing current branch...");
                GitCommandResult result = GithubCreatePullRequestWorker.this.myGit.push(GithubCreatePullRequestWorker.this.myGitRepository, GithubCreatePullRequestWorker.this.myRemoteName, GithubCreatePullRequestWorker.this.myRemoteUrl, GithubCreatePullRequestWorker.this.myCurrentBranch, true, new GitLineHandlerListener[0]);
                if (!result.success()) {
                    GithubNotifications.showError(this.myProject, GithubCreatePullRequestWorker.CANNOT_CREATE_PULL_REQUEST, "Push failed:<br/>" + result.getErrorOutputAsHtmlString());
                    return;
                }
                LOG.info("Creating pull request");
                indicator.setText("Creating pull request...");
                GithubPullRequest request = GithubCreatePullRequestWorker.this.doCreatePullRequest(indicator, branch, title, description);
                if (request == null) {
                    return;
                }
                GithubNotifications.showInfoURL(this.myProject, "Successfully created pull request", "Pull request #" + request.getNumber(), request.getHtmlUrl());
            }
        }.queue();
    }

    @Nullable
    private GithubPullRequest doCreatePullRequest(@NotNull ProgressIndicator indicator, @NotNull BranchInfo branch, final @NotNull String title, final @NotNull String description) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doCreatePullRequest"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doCreatePullRequest"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doCreatePullRequest"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "doCreatePullRequest"));
        }
        final ForkInfo fork = branch.getForkInfo();
        final String head = this.myPath.getUser() + ":" + this.myCurrentBranch;
        final String base = branch.getRemoteName();
        try {
            return GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, new ThrowableConvertor<GithubConnection, GithubPullRequest, IOException>(){

                @NotNull
                public GithubPullRequest convert(@NotNull GithubConnection connection) throws IOException {
                    if (connection == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$14", "convert"));
                    }
                    GithubPullRequest githubPullRequest = GithubApiUtil.createPullRequest(connection, fork.getPath().getUser(), fork.getPath().getRepository(), title, description, head, base);
                    if (githubPullRequest == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$14", "convert"));
                    }
                    return githubPullRequest;
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, CANNOT_CREATE_PULL_REQUEST, e);
            return null;
        }
    }

    public void showDiffDialog(final @Nullable BranchInfo branch) {
        DiffInfo info;
        if (branch == null) {
            GithubNotifications.showWarningDialog(this.myProject, "Can't Show Diff", "Target branch is not selected");
            return;
        }
        try {
            info = GithubUtil.computeValueInModal(this.myProject, "Collecting diff data...", new ThrowableConvertor<ProgressIndicator, DiffInfo, IOException>(){

                public DiffInfo convert(ProgressIndicator indicator) throws IOException {
                    return GithubUtil.runInterruptable(indicator, new ThrowableComputable<DiffInfo, IOException>(){

                        public DiffInfo compute() throws IOException {
                            return GithubCreatePullRequestWorker.this.getDiffInfo(branch);
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't collect diff data", e);
            return;
        }
        if (info == null) {
            GithubNotifications.showErrorDialog(this.myProject, "Can't Show Diff", "Can't collect diff data");
            return;
        }
        GitCompareBranchesDialog dialog = new GitCompareBranchesDialog(this.myProject, info.getTo(), info.getFrom(), info.getInfo(), this.myGitRepository, true);
        dialog.show();
    }

    @Nullable
    public ForkInfo showTargetDialog() {
        if (this.myAvailableForks == null) {
            this.myAvailableForks = GithubUtil.computeValueInModal(this.myProject, this.myCurrentBranch, new Convertor<ProgressIndicator, List<GithubFullPath>>(){

                public List<GithubFullPath> convert(ProgressIndicator indicator) {
                    return GithubCreatePullRequestWorker.this.getAvailableForks(indicator);
                }
            });
        }
        Convertor<String, ForkInfo> getForkPath = new Convertor<String, ForkInfo>(){

            @Nullable
            public ForkInfo convert(final @NotNull String user) {
                if (user == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$17", "convert"));
                }
                return GithubUtil.computeValueInModal(GithubCreatePullRequestWorker.this.myProject, "Access to GitHub", new Convertor<ProgressIndicator, ForkInfo>(){

                    @Nullable
                    public ForkInfo convert(ProgressIndicator indicator) {
                        return GithubCreatePullRequestWorker.this.findRepositoryByUser(indicator, user);
                    }
                });
            }
        };
        GithubSelectForkDialog dialog = new GithubSelectForkDialog(this.myProject, this.myAvailableForks, getForkPath);
        DialogManager.show((DialogWrapper)dialog);
        if (!dialog.isOK()) {
            return null;
        }
        return dialog.getPath();
    }

    @Nullable
    private List<GithubFullPath> getAvailableForks(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "getAvailableForks"));
        }
        try {
            List forks = ContainerUtil.map((Collection)GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, new ThrowableConvertor<GithubConnection, List<GithubRepo>, IOException>(){

                @NotNull
                public List<GithubRepo> convert(@NotNull GithubConnection connection) throws IOException {
                    if (connection == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$18", "convert"));
                    }
                    List<GithubRepo> list = GithubApiUtil.getForks(connection, GithubCreatePullRequestWorker.this.mySource.getUser(), GithubCreatePullRequestWorker.this.mySource.getRepository());
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$18", "convert"));
                    }
                    return list;
                }
            }), (Function)new Function<GithubRepo, GithubFullPath>(){

                public GithubFullPath fun(GithubRepo repo) {
                    return repo.getFullPath();
                }
            });
            if (!forks.contains(this.mySource)) {
                return ContainerUtil.concat((boolean)true, (List)forks, (Object[])new GithubFullPath[]{this.mySource});
            }
            return forks;
        }
        catch (IOException e) {
            GithubNotifications.showWarning(this.myProject, "Can't load available forks", e);
            return null;
        }
    }

    @Nullable
    private ForkInfo findRepositoryByUser(@NotNull ProgressIndicator indicator, final @NotNull String user) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker", "findRepositoryByUser"));
        }
        for (ForkInfo fork : this.myForks) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)user, (CharSequence)fork.getPath().getUser())) continue;
            return fork;
        }
        try {
            GithubRepo repo = GithubUtil.runTask(this.myProject, this.myAuthHolder, indicator, new ThrowableConvertor<GithubConnection, GithubRepo, IOException>(){

                @Nullable
                public GithubRepo convert(@NotNull GithubConnection connection) throws IOException {
                    if (connection == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$20", "convert"));
                    }
                    try {
                        GithubRepoDetailed target = GithubApiUtil.getDetailedRepoInfo(connection, user, GithubCreatePullRequestWorker.this.mySource.getRepository());
                        if (target.getSource() != null && StringUtil.equals((CharSequence)target.getSource().getUserName(), (CharSequence)GithubCreatePullRequestWorker.this.mySource.getUser())) {
                            return target;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return GithubApiUtil.findForkByUser(connection, GithubCreatePullRequestWorker.this.mySource.getUser(), GithubCreatePullRequestWorker.this.mySource.getRepository(), user);
                }
            });
            if (repo == null) {
                return null;
            }
            return this.doAddFork(repo, indicator);
        }
        catch (IOException e) {
            GithubNotifications.showError(this.myProject, "Can't find repository", e);
            return null;
        }
    }

    public static class MasterFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final Object LOCK;
        private boolean myDone;
        @Nullable
        private List<SlaveFutureTask> mySlaves;

        public MasterFutureTask(@NotNull Callable<T> callable) {
            if (callable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$MasterFutureTask", "<init>"));
            }
            super(callable);
            this.LOCK = new Object();
            this.myDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSlave(@NotNull SlaveFutureTask slave) {
            if (slave == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$MasterFutureTask", "addSlave"));
            }
            if (this.isDone()) {
                return false;
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (this.myDone) {
                    return false;
                }
                if (this.mySlaves == null) {
                    this.mySlaves = new ArrayList<SlaveFutureTask>();
                }
                this.mySlaves.add(slave);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            Object object = this.LOCK;
            synchronized (object) {
                this.myDone = true;
                if (this.mySlaves != null) {
                    for (SlaveFutureTask slave : this.mySlaves) {
                        this.runSlave(slave);
                    }
                    this.mySlaves = null;
                }
            }
        }

        protected void runSlave(final @NotNull SlaveFutureTask slave) {
            if (slave == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slave", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$MasterFutureTask", "runSlave"));
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    slave.run();
                }
            });
        }
    }

    public static class SlaveFutureTask<T>
    extends FutureTask<T> {
        @NotNull
        private final MasterFutureTask myMaster;

        public SlaveFutureTask(@NotNull MasterFutureTask master, @NotNull Callable<T> callable) {
            if (master == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$SlaveFutureTask", "<init>"));
            }
            if (callable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$SlaveFutureTask", "<init>"));
            }
            super(callable);
            this.myMaster = master;
        }

        @Override
        public void run() {
            if (this.myMaster.isDone()) {
                super.run();
            } else if (!this.myMaster.addSlave(this)) {
                super.run();
            }
        }

        public T safeGet() {
            try {
                return (T)super.get();
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (CancellationException e) {
                return null;
            }
            catch (ExecutionException e) {
                return null;
            }
        }
    }

    public static class DiffInfo {
        @NotNull
        private final GitCommitCompareInfo myInfo;
        @NotNull
        private final String myFrom;
        @NotNull
        private final String myTo;

        private DiffInfo(@NotNull GitCommitCompareInfo info, @NotNull String from, @NotNull String to) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "<init>"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "<init>"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "<init>"));
            }
            this.myInfo = info;
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public GitCommitCompareInfo getInfo() {
            GitCommitCompareInfo gitCommitCompareInfo = this.myInfo;
            if (gitCommitCompareInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "getInfo"));
            }
            return gitCommitCompareInfo;
        }

        @NotNull
        public String getFrom() {
            String string = this.myFrom;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "getFrom"));
            }
            return string;
        }

        @NotNull
        public String getTo() {
            String string = this.myTo;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$DiffInfo", "getTo"));
            }
            return string;
        }
    }

    public static class BranchInfo {
        @NotNull
        public final Object LOCK;
        @NotNull
        private final ForkInfo myForkInfo;
        @NotNull
        private final String myRemoteName;
        @Nullable
        private SlaveFutureTask<DiffInfo> myDiffInfoTask;
        @Nullable
        private Couple<String> myDefaultMessage;

        public BranchInfo(@NotNull String remoteName, @NotNull ForkInfo fork) {
            if (remoteName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo", "<init>"));
            }
            if (fork == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fork", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo", "<init>"));
            }
            this.LOCK = new Object();
            this.myRemoteName = remoteName;
            this.myForkInfo = fork;
        }

        @NotNull
        public ForkInfo getForkInfo() {
            ForkInfo forkInfo = this.myForkInfo;
            if (forkInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo", "getForkInfo"));
            }
            return forkInfo;
        }

        @NotNull
        public String getRemoteName() {
            String string = this.myRemoteName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo", "getRemoteName"));
            }
            return string;
        }

        @Nullable
        public SlaveFutureTask<DiffInfo> getDiffInfoTask() {
            return this.myDiffInfoTask;
        }

        public void setDiffInfoTask(@NotNull SlaveFutureTask<DiffInfo> diffInfoTask) {
            if (diffInfoTask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffInfoTask", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo", "setDiffInfoTask"));
            }
            this.myDiffInfoTask = diffInfoTask;
        }

        @Nullable
        public Couple<String> getDefaultMessage() {
            return this.myDefaultMessage;
        }

        public void setDefaultMessage(@NotNull Couple<String> message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$BranchInfo", "setDefaultMessage"));
            }
            this.myDefaultMessage = message;
        }

        public String toString() {
            return this.myRemoteName;
        }
    }

    public static class ForkInfo {
        @NotNull
        public final Object LOCK;
        @NotNull
        private final GithubFullPath myPath;
        @NotNull
        private final String myDefaultBranch;
        @NotNull
        private final List<BranchInfo> myBranches;
        @Nullable
        private String myRemoteName;
        private boolean myProposedToCreateRemote;
        @Nullable
        private MasterFutureTask<Void> myFetchTask;

        public ForkInfo(@NotNull GithubFullPath path, @NotNull List<String> branches, @Nullable String defaultBranch) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo", "<init>"));
            }
            if (branches == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo", "<init>"));
            }
            this.LOCK = new Object();
            this.myPath = path;
            this.myDefaultBranch = defaultBranch == null ? "master" : defaultBranch;
            this.myBranches = new ArrayList<BranchInfo>();
            for (String branchName : branches) {
                this.myBranches.add(new BranchInfo(branchName, this));
            }
        }

        @NotNull
        public GithubFullPath getPath() {
            GithubFullPath githubFullPath = this.myPath;
            if (githubFullPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo", "getPath"));
            }
            return githubFullPath;
        }

        @Nullable
        public String getRemoteName() {
            return this.myRemoteName;
        }

        @NotNull
        public String getDefaultBranch() {
            String string = this.myDefaultBranch;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo", "getDefaultBranch"));
            }
            return string;
        }

        @NotNull
        public List<BranchInfo> getBranches() {
            List<BranchInfo> list = this.myBranches;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo", "getBranches"));
            }
            return list;
        }

        public void setRemoteName(@NotNull String remoteName) {
            if (remoteName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo", "setRemoteName"));
            }
            this.myRemoteName = remoteName;
        }

        public boolean isProposedToCreateRemote() {
            return this.myProposedToCreateRemote;
        }

        public void setProposedToCreateRemote(boolean proposedToCreateRemote) {
            this.myProposedToCreateRemote = proposedToCreateRemote;
        }

        @Nullable
        public MasterFutureTask<Void> getFetchTask() {
            return this.myFetchTask;
        }

        public void setFetchTask(@NotNull MasterFutureTask<Void> fetchTask) {
            if (fetchTask == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetchTask", "org/jetbrains/plugins/github/GithubCreatePullRequestWorker$ForkInfo", "setFetchTask"));
            }
            this.myFetchTask = fetchTask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForkInfo info = (ForkInfo)o;
            return this.myPath.equals(info.myPath);
        }

        public int hashCode() {
            return this.myPath.hashCode();
        }

        public String toString() {
            return this.myPath.getUser() + ":" + this.myPath.getRepository();
        }
    }
}

