/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.AntFilesProvider;
import com.intellij.lang.ant.dom.AntDomFilesProviderImpl;
import com.intellij.lang.ant.dom.AntDomPattern;
import com.intellij.lang.ant.dom.AntPathConverter;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.GenericAttributeValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AntDomFileSet
extends AntDomFilesProviderImpl {
    @Attribute(value="dir")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getDir();

    @Attribute(value="file")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getFile();

    @Override
    @NotNull
    protected List<File> getFiles(@Nullable AntDomPattern pattern, Set<AntFilesProvider> processed) {
        File root;
        assert (pattern != null);
        File singleFile = this.getCanonicalFile(this.getFile().getStringValue());
        if ((singleFile == null || pattern.hasIncludePatterns()) && (root = this.getCanonicalFile(this.getDir().getStringValue())) != null) {
            ArrayList<File> files = new ArrayList<File>();
            if (singleFile != null) {
                files.add(singleFile);
            }
            new FilesCollector().collectFiles(files, root, "", pattern);
            ArrayList<File> arrayList = files;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileSet", "getFiles"));
            }
            return arrayList;
        }
        if (singleFile != null) {
            List<File> list = Collections.singletonList(singleFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileSet", "getFiles"));
            }
            return list;
        }
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ant/dom/AntDomFileSet", "getFiles"));
        }
        return list;
    }

    private static class FilesCollector {
        private static final int MAX_DIRS_TO_PROCESS = 100;
        private int myDirsProcessed = 0;
        private boolean myDirCheckEnabled = false;

        private FilesCollector() {
        }

        public void collectFiles(List<File> container, File from, String relativePath, AntDomPattern pattern) {
            if (this.myDirsProcessed > 100) {
                return;
            }
            File[] children = from.listFiles();
            if (children != null && children.length > 0) {
                if (this.myDirCheckEnabled) {
                    if (!pattern.couldBeIncluded(relativePath)) {
                        return;
                    }
                } else {
                    this.myDirCheckEnabled = true;
                }
                ++this.myDirsProcessed;
                for (File child : children) {
                    String childPath = FilesCollector.makePath(relativePath, child.getName());
                    if (pattern.acceptPath(childPath)) {
                        container.add(child);
                    }
                    this.collectFiles(container, child, childPath, pattern);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String makePath(String parentPath, String name) {
            if (parentPath.length() == 0) {
                return name;
            }
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                String string = builder.append(parentPath).append("/").append(name).toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
    }
}

