/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;

public class CustomMaven3Artifact
implements Artifact {
    private static final Map<String, File> ourStubCache = new THashMap();
    private static final ReentrantReadWriteLock ourCacheLock = new ReentrantReadWriteLock();
    private static final Lock ourCacheReadLock = ourCacheLock.readLock();
    private static final Lock ourCacheWriteLock = ourCacheLock.writeLock();
    private final Artifact myWrapee;
    private volatile boolean isStub;

    public CustomMaven3Artifact(Artifact a) {
        this.myWrapee = a;
    }

    public String getGroupId() {
        return this.myWrapee.getGroupId();
    }

    public String getArtifactId() {
        return this.myWrapee.getArtifactId();
    }

    public String getVersion() {
        return this.myWrapee.getVersion();
    }

    public void setVersion(String version) {
        this.myWrapee.setVersion(version);
    }

    public String getScope() {
        return this.myWrapee.getScope();
    }

    public String getType() {
        return this.myWrapee.getType();
    }

    public String getClassifier() {
        return this.myWrapee.getClassifier();
    }

    public boolean hasClassifier() {
        return this.myWrapee.hasClassifier();
    }

    public File getFile() {
        this.update();
        return this.myWrapee.getFile();
    }

    private void update() {
        if ("pom".equals(this.getType()) && this.isResolved()) {
            this.ensurePomFileExists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensurePomFileExists() {
        File f = this.myWrapee.getFile();
        if (f == null || f.exists()) {
            return;
        }
        this.isStub = true;
        ourCacheReadLock.lock();
        try {
            f = ourStubCache.get(this.getId());
        }
        finally {
            ourCacheReadLock.unlock();
        }
        if (f != null) {
            this.myWrapee.setFile(f);
            return;
        }
        ourCacheWriteLock.lock();
        try {
            f = ourStubCache.get(this.getId());
            if (f != null) {
                this.myWrapee.setFile(f);
                return;
            }
            f = FileUtil.createTempFile((String)"idea.maven.stub", (String)".pom");
            f.deleteOnExit();
            FileOutputStream s = new FileOutputStream(f);
            try {
                PrintWriter w = new PrintWriter(s);
                w.println("<project>");
                w.println("<modelVersion>4.0.0</modelVersion>");
                w.println("<packaging>pom</packaging>");
                w.println("<groupId>" + this.getGroupId() + "</groupId>");
                w.println("<artifactId>" + this.getArtifactId() + "</artifactId>");
                w.println("<version>" + this.getVersion() + "</version>");
                w.println("</project>");
                w.flush();
            }
            finally {
                s.close();
            }
            this.myWrapee.setFile(f);
            ourStubCache.put(this.getId(), f);
        }
        catch (IOException iOException) {
        }
        finally {
            ourCacheWriteLock.unlock();
        }
    }

    public void setFile(File destination) {
        this.myWrapee.setFile(destination);
    }

    public boolean isStub() {
        return this.isStub;
    }

    public String getBaseVersion() {
        return this.myWrapee.getBaseVersion();
    }

    public void setBaseVersion(String baseVersion) {
        this.myWrapee.setBaseVersion(baseVersion);
    }

    public String getId() {
        try {
            return this.myWrapee.getId();
        }
        catch (NullPointerException e) {
            VersionRange range;
            if (e.getMessage() != null && e.getMessage().contains("version was null") && (range = this.getVersionRange()) != null) {
                this.setBaseVersion(range.toString());
                return this.myWrapee.getId();
            }
            throw e;
        }
    }

    public String getDependencyConflictId() {
        return this.myWrapee.getDependencyConflictId();
    }

    public void addMetadata(ArtifactMetadata metadata) {
        this.myWrapee.addMetadata(metadata);
    }

    public Collection<ArtifactMetadata> getMetadataList() {
        return this.myWrapee.getMetadataList();
    }

    public void setRepository(ArtifactRepository remoteRepository) {
        this.myWrapee.setRepository(remoteRepository);
    }

    public ArtifactRepository getRepository() {
        return this.myWrapee.getRepository();
    }

    public void updateVersion(String version, ArtifactRepository localRepository) {
        this.myWrapee.updateVersion(version, localRepository);
    }

    public String getDownloadUrl() {
        return this.myWrapee.getDownloadUrl();
    }

    public void setDownloadUrl(String downloadUrl) {
        this.myWrapee.setDownloadUrl(downloadUrl);
    }

    public ArtifactFilter getDependencyFilter() {
        return this.myWrapee.getDependencyFilter();
    }

    public void setDependencyFilter(ArtifactFilter artifactFilter) {
        this.myWrapee.setDependencyFilter(artifactFilter);
    }

    public ArtifactHandler getArtifactHandler() {
        return this.myWrapee.getArtifactHandler();
    }

    public List<String> getDependencyTrail() {
        return this.myWrapee.getDependencyTrail();
    }

    public void setDependencyTrail(List<String> dependencyTrail) {
        this.myWrapee.setDependencyTrail(dependencyTrail);
    }

    public void setScope(String scope) {
        this.myWrapee.setScope(scope);
    }

    public VersionRange getVersionRange() {
        return this.myWrapee.getVersionRange();
    }

    public void setVersionRange(VersionRange newRange) {
        this.myWrapee.setVersionRange(newRange);
    }

    public void selectVersion(String version) {
        this.myWrapee.selectVersion(version);
    }

    public void setGroupId(String groupId) {
        this.myWrapee.setGroupId(groupId);
    }

    public void setArtifactId(String artifactId) {
        this.myWrapee.setArtifactId(artifactId);
    }

    public boolean isSnapshot() {
        return this.myWrapee.isSnapshot();
    }

    public void setResolved(boolean resolved) {
        this.myWrapee.setResolved(resolved);
    }

    public boolean isResolved() {
        return this.myWrapee.isResolved();
    }

    public void setResolvedVersion(String version) {
        this.myWrapee.setResolvedVersion(version);
    }

    public void setArtifactHandler(ArtifactHandler handler) {
        this.myWrapee.setArtifactHandler(handler);
    }

    public boolean isRelease() {
        return this.myWrapee.isRelease();
    }

    public void setRelease(boolean release) {
        this.myWrapee.setRelease(release);
    }

    public List<ArtifactVersion> getAvailableVersions() {
        return this.myWrapee.getAvailableVersions();
    }

    public void setAvailableVersions(List<ArtifactVersion> versions) {
        this.myWrapee.setAvailableVersions(versions);
    }

    public boolean isOptional() {
        return this.myWrapee.isOptional();
    }

    public void setOptional(boolean optional) {
        this.myWrapee.setOptional(optional);
    }

    public ArtifactVersion getSelectedVersion() throws OverConstrainedVersionException {
        return this.myWrapee.getSelectedVersion();
    }

    public boolean isSelectedVersionKnown() throws OverConstrainedVersionException {
        return this.myWrapee.isSelectedVersionKnown();
    }

    public int compareTo(Artifact o) {
        if (o instanceof CustomMaven3Artifact) {
            o = ((CustomMaven3Artifact)o).myWrapee;
        }
        return this.myWrapee.compareTo((Object)o);
    }

    public String toString() {
        return this.myWrapee.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CustomMaven3Artifact) {
            obj = ((CustomMaven3Artifact)obj).myWrapee;
        }
        return this.myWrapee.equals(obj);
    }

    public int hashCode() {
        return this.myWrapee.hashCode();
    }
}

