/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.packaging;

import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Base64Converter;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationClassBrowser;
import org.jetbrains.plugins.javaFX.packaging.JavaFxArtifactProperties;
import org.jetbrains.plugins.javaFX.packaging.JavaFxEditCertificatesDialog;
import org.jetbrains.plugins.javaFX.packaging.JavaFxManifestAttribute;
import org.jetbrains.plugins.javaFX.packaging.JavaFxPackagerConstants;

public class JavaFxArtifactPropertiesEditor
extends ArtifactPropertiesEditor {
    private final JavaFxArtifactProperties myProperties;
    private JPanel myWholePanel;
    private JTextField myTitleTF;
    private JTextField myVendorTF;
    private JEditorPane myDescriptionEditorPane;
    private TextFieldWithBrowseButton myAppClass;
    private JTextField myWidthTF;
    private JTextField myHeightTF;
    private TextFieldWithBrowseButton myHtmlParams;
    private TextFieldWithBrowseButton myParams;
    private JCheckBox myUpdateInBackgroundCB;
    private JCheckBox myEnableSigningCB;
    private JButton myEditSignCertificateButton;
    private JCheckBox myConvertCssToBinCheckBox;
    private JComboBox myNativeBundleCB;
    private JButton myEditAttributesButton;
    private JavaFxEditCertificatesDialog myDialog;
    private CustomManifestAttributesDialog myManifestAttributesDialog;
    private List<JavaFxManifestAttribute> myCustomManifestAttributes;

    public JavaFxArtifactPropertiesEditor(JavaFxArtifactProperties properties, final Project project, Artifact artifact) {
        this.myProperties = properties;
        this.$$$setupUI$$$();
        new JavaFxApplicationClassBrowser(project, artifact).setField((ComponentWithBrowseButton)this.myAppClass);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)StdFileTypes.PROPERTIES);
        this.myHtmlParams.addBrowseFolderListener("Choose Properties File", "Parameters for the resulting application to run standalone.", project, descriptor);
        this.myParams.addBrowseFolderListener("Choose Properties File", "Parameters for the resulting application to run in the browser.", project, descriptor);
        this.myEditSignCertificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFxArtifactPropertiesEditor.this.myDialog = new JavaFxEditCertificatesDialog(JavaFxArtifactPropertiesEditor.this.myWholePanel, JavaFxArtifactPropertiesEditor.this.myProperties, project);
                JavaFxArtifactPropertiesEditor.this.myDialog.show();
            }
        });
        this.myEnableSigningCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFxArtifactPropertiesEditor.this.myEditSignCertificateButton.setEnabled(JavaFxArtifactPropertiesEditor.this.myEnableSigningCB.isSelected());
            }
        });
        this.myEditAttributesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaFxArtifactPropertiesEditor.this.myManifestAttributesDialog = new CustomManifestAttributesDialog(JavaFxArtifactPropertiesEditor.this.myWholePanel, JavaFxArtifactPropertiesEditor.this.myCustomManifestAttributes);
                JavaFxArtifactPropertiesEditor.this.myManifestAttributesDialog.show();
                if (JavaFxArtifactPropertiesEditor.this.myManifestAttributesDialog.isOK()) {
                    JavaFxArtifactPropertiesEditor.this.myCustomManifestAttributes = JavaFxArtifactPropertiesEditor.this.myManifestAttributesDialog.getAttrs();
                }
            }
        });
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (JavaFxPackagerConstants.NativeBundles bundle : JavaFxPackagerConstants.NativeBundles.values()) {
            bundleNames.add(bundle.name());
        }
        this.myNativeBundleCB.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(bundleNames)));
    }

    public String getTabName() {
        return "Java FX";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getTitle(), this.myTitleTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getVendor(), this.myVendorTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getDescription(), this.myDescriptionEditorPane)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getWidth(), this.myWidthTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getHeight(), this.myHeightTF)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getAppClass(), this.myAppClass)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getHtmlParamFile(), this.myHtmlParams)) {
            return true;
        }
        if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getParamFile(), this.myParams)) {
            return true;
        }
        if (!Comparing.equal((Object)this.myNativeBundleCB.getSelectedItem(), (Object)this.myProperties.getNativeBundle())) {
            return true;
        }
        boolean inBackground = Comparing.strEqual((String)this.myProperties.getUpdateMode(), (String)"background");
        if (inBackground != this.myUpdateInBackgroundCB.isSelected()) {
            return true;
        }
        if (this.myProperties.isEnabledSigning() != this.myEnableSigningCB.isSelected()) {
            return true;
        }
        if (this.myProperties.isConvertCss2Bin() != this.myConvertCssToBinCheckBox.isSelected()) {
            return true;
        }
        if (this.myDialog != null) {
            if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getAlias(), this.myDialog.myPanel.myAliasTF)) {
                return true;
            }
            if (JavaFxArtifactPropertiesEditor.isModified(this.myProperties.getKeystore(), this.myDialog.myPanel.myKeystore)) {
                return true;
            }
            String keypass = this.myProperties.getKeypass();
            if (JavaFxArtifactPropertiesEditor.isModified(keypass != null ? Base64Converter.decode((String)keypass) : "", this.myDialog.myPanel.myKeypassTF)) {
                return true;
            }
            String storepass = this.myProperties.getStorepass();
            if (JavaFxArtifactPropertiesEditor.isModified(storepass != null ? Base64Converter.decode((String)storepass) : "", this.myDialog.myPanel.myStorePassTF)) {
                return true;
            }
            if (this.myProperties.isSelfSigning() != this.myDialog.myPanel.mySelfSignedRadioButton.isSelected()) {
                return true;
            }
        }
        return this.myManifestAttributesDialog != null && !Comparing.equal(this.myManifestAttributesDialog.getAttrs(), this.myProperties.getCustomManifestAttributes());
    }

    private static boolean isModified(String title, JTextComponent tf) {
        return !Comparing.strEqual((String)title, (String)tf.getText().trim());
    }

    private static boolean isModified(String title, TextFieldWithBrowseButton tf) {
        return !Comparing.strEqual((String)title, (String)tf.getText().trim());
    }

    public void apply() {
        this.myProperties.setTitle(this.myTitleTF.getText());
        this.myProperties.setVendor(this.myVendorTF.getText());
        this.myProperties.setDescription(this.myDescriptionEditorPane.getText());
        this.myProperties.setAppClass(this.myAppClass.getText());
        this.myProperties.setWidth(this.myWidthTF.getText());
        this.myProperties.setHeight(this.myHeightTF.getText());
        this.myProperties.setHtmlParamFile(this.myHtmlParams.getText());
        this.myProperties.setParamFile(this.myParams.getText());
        this.myProperties.setUpdateMode(this.myUpdateInBackgroundCB.isSelected() ? "background" : "always");
        this.myProperties.setEnabledSigning(this.myEnableSigningCB.isSelected());
        this.myProperties.setConvertCss2Bin(this.myConvertCssToBinCheckBox.isSelected());
        this.myProperties.setNativeBundle((String)this.myNativeBundleCB.getSelectedItem());
        if (this.myDialog != null) {
            this.myProperties.setSelfSigning(this.myDialog.myPanel.mySelfSignedRadioButton.isSelected());
            this.myProperties.setAlias(this.myDialog.myPanel.myAliasTF.getText());
            this.myProperties.setKeystore(this.myDialog.myPanel.myKeystore.getText());
            String keyPass = String.valueOf(this.myDialog.myPanel.myKeypassTF.getPassword());
            this.myProperties.setKeypass(!StringUtil.isEmptyOrSpaces((String)keyPass) ? Base64Converter.encode((String)keyPass) : null);
            String storePass = String.valueOf(this.myDialog.myPanel.myStorePassTF.getPassword());
            this.myProperties.setStorepass(!StringUtil.isEmptyOrSpaces((String)storePass) ? Base64Converter.encode((String)storePass) : null);
        }
        if (this.myManifestAttributesDialog != null) {
            this.myProperties.setCustomManifestAttributes(this.myManifestAttributesDialog.getAttrs());
        }
    }

    @Nullable
    public String getHelpId() {
        return "Project_Structure_Artifacts_Java_FX_tab";
    }

    public void reset() {
        JavaFxArtifactPropertiesEditor.setText(this.myTitleTF, this.myProperties.getTitle());
        JavaFxArtifactPropertiesEditor.setText(this.myVendorTF, this.myProperties.getVendor());
        JavaFxArtifactPropertiesEditor.setText(this.myDescriptionEditorPane, this.myProperties.getDescription());
        JavaFxArtifactPropertiesEditor.setText(this.myWidthTF, this.myProperties.getWidth());
        JavaFxArtifactPropertiesEditor.setText(this.myHeightTF, this.myProperties.getHeight());
        JavaFxArtifactPropertiesEditor.setText(this.myAppClass, this.myProperties.getAppClass());
        JavaFxArtifactPropertiesEditor.setText(this.myHtmlParams, this.myProperties.getHtmlParamFile());
        JavaFxArtifactPropertiesEditor.setText(this.myParams, this.myProperties.getParamFile());
        this.myNativeBundleCB.setSelectedItem(this.myProperties.getNativeBundle());
        this.myUpdateInBackgroundCB.setSelected(Comparing.strEqual((String)this.myProperties.getUpdateMode(), (String)"background"));
        this.myEnableSigningCB.setSelected(this.myProperties.isEnabledSigning());
        this.myConvertCssToBinCheckBox.setSelected(this.myProperties.isConvertCss2Bin());
        this.myEditSignCertificateButton.setEnabled(this.myProperties.isEnabledSigning());
        this.myCustomManifestAttributes = this.myProperties.getCustomManifestAttributes();
    }

    private static void setText(TextFieldWithBrowseButton tf, String title) {
        if (title != null) {
            tf.setText(title.trim());
        }
    }

    private static void setText(JTextComponent tf, String title) {
        if (title != null) {
            tf.setText(title.trim());
        }
    }

    public void disposeUIResources() {
        if (this.myDialog != null) {
            this.myDialog.myPanel = null;
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JButton jButton2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JTextField jTextField;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JEditorPane jEditorPane;
        JTextField jTextField3;
        JTextField jTextField4;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Title:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTitleTF = jTextField4 = new JTextField();
        jPanel2.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Vendor:");
        jLabel2.setDisplayedMnemonic('V');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVendorTF = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        this.myDescriptionEditorPane = jEditorPane = new JEditorPane();
        jBScrollPane.setViewportView(jEditorPane);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Description:");
        jLabel3.setDisplayedMnemonic('D');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Application class:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppClass = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Width:");
        jLabel5.setDisplayedMnemonic('W');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWidthTF = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Height:");
        jLabel6.setDisplayedMnemonic('H');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeightTF = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("HTML Parameters:");
        jLabel7.setDisplayedMnemonic('L');
        jLabel7.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlParams = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(6, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Application Parameters:");
        jLabel8.setDisplayedMnemonic('R');
        jLabel8.setDisplayedMnemonicIndex(14);
        jPanel2.add((Component)jLabel8, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParams = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(7, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUpdateInBackgroundCB = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Update in background");
        jCheckBox3.setMnemonic('B');
        jCheckBox3.setDisplayedMnemonicIndex(10);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(8, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEnableSigningCB = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable signing");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(11, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEditSignCertificateButton = jButton2 = new JButton();
        jButton2.setText("Edit Cerificates");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(5);
        jPanel3.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConvertCssToBinCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Convert css to bin");
        jPanel2.add((Component)jCheckBox, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Native bundle:");
        jLabel9.setDisplayedMnemonic('I');
        jLabel9.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jLabel9, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNativeBundleCB = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(9, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Custom manifest attributes");
        jPanel2.add((Component)jLabel10, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(12, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEditAttributesButton = jButton = new JButton();
        jButton.setText("Edit  Attributes");
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jTextField4);
        jLabel2.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jEditorPane);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton3);
        jLabel5.setLabelFor(jTextField2);
        jLabel6.setLabelFor(jTextField);
        jLabel7.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel8.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel9.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private static class CustomManifestAttributesDialog
    extends DialogWrapper {
        private final JPanel myWholePanel = new JPanel(new BorderLayout());
        private final AttributesTable myTable = new AttributesTable();

        protected CustomManifestAttributesDialog(JPanel panel, List<JavaFxManifestAttribute> attrs) {
            super((Component)panel, true);
            this.myTable.setValues(attrs);
            this.myWholePanel.add((Component)this.myTable.getComponent(), "Center");
            this.setTitle("Edit Custom Manifest Attributes");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myWholePanel;
        }

        protected void doOKAction() {
            this.myTable.stopEditing();
            super.doOKAction();
        }

        List<JavaFxManifestAttribute> getAttrs() {
            return this.myTable.getAttrs();
        }

        private static class AttributesTable
        extends ListTableWithButtons<JavaFxManifestAttribute> {
            private AttributesTable() {
            }

            protected ListTableModel createListModel() {
                ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute> name = new ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute>("Name"){

                    @Nullable
                    public String valueOf(JavaFxManifestAttribute attribute) {
                        return attribute.getName();
                    }

                    public boolean isCellEditable(JavaFxManifestAttribute attr) {
                        return true;
                    }

                    public void setValue(JavaFxManifestAttribute attr, String value) {
                        attr.setName(value);
                    }

                    @Nullable
                    protected String getDescription(JavaFxManifestAttribute element) {
                        return element.getName();
                    }
                };
                ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute> value = new ListTableWithButtons.ElementsColumnInfoBase<JavaFxManifestAttribute>("Value"){

                    public String valueOf(JavaFxManifestAttribute attr) {
                        return attr.getValue();
                    }

                    public boolean isCellEditable(JavaFxManifestAttribute attr) {
                        return true;
                    }

                    public void setValue(JavaFxManifestAttribute attr, String s) {
                        attr.setValue(s);
                    }

                    @Nullable
                    protected String getDescription(JavaFxManifestAttribute attr) {
                        return attr.getValue();
                    }
                };
                return new ListTableModel(new ColumnInfo[]{name, value});
            }

            protected JavaFxManifestAttribute createElement() {
                return new JavaFxManifestAttribute("", "");
            }

            protected boolean isEmpty(JavaFxManifestAttribute element) {
                return StringUtil.isEmpty((String)element.getName()) && StringUtil.isEmpty((String)element.getValue());
            }

            protected JavaFxManifestAttribute cloneElement(JavaFxManifestAttribute attribute) {
                return new JavaFxManifestAttribute(attribute.getName(), attribute.getValue());
            }

            protected boolean canDeleteElement(JavaFxManifestAttribute selection) {
                return true;
            }

            public List<JavaFxManifestAttribute> getAttrs() {
                return this.getElements();
            }
        }
    }
}

