/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SystemImage;
import com.android.sdklib.internal.androidTarget.AddOnTarget;
import com.android.sdklib.internal.androidTarget.PlatformTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.repository.packages.AddonPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescAddon;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalAddonSysImgPkgInfo;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalPlatformPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.utils.Pair;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalAddonPkgInfo
extends LocalPlatformPkgInfo {
    private static final Pattern PATTERN_LIB_DATA = Pattern.compile("^([a-zA-Z0-9._-]+\\.jar);(.*)$", 2);
    private static final Pattern PATTERN_USB_IDS = Pattern.compile("^0x[a-f0-9]{4}$", 2);
    @NonNull
    private final IPkgDescAddon mAddonDesc;

    public LocalAddonPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull AndroidVersion version, @NonNull MajorRevision revision, @NonNull IdDisplay vendor, @NonNull IdDisplay name) {
        super(localSdk, localDir, sourceProps, version, revision, FullRevision.NOT_SPECIFIED);
        this.mAddonDesc = (IPkgDescAddon)PkgDesc.Builder.newAddon(version, revision, vendor, name).create();
    }

    @Override
    @NonNull
    public IPkgDesc getDesc() {
        return this.mAddonDesc;
    }

    @Override
    @NonNull
    public String getTargetHash() {
        return this.getDesc().getPath();
    }

    public static String sanitizeDisplayToNameId(@NonNull String displayName) {
        String name = displayName.toLowerCase(Locale.US);
        name = name.replaceAll("[^a-z0-9_-]+", "_");
        if ((name = name.replaceAll("_+", "_")).length() > 1) {
            name = name.replaceAll("^_+", "");
        }
        if (name.length() > 1) {
            name = name.replaceAll("_+$", "");
        }
        return name;
    }

    @Override
    @Nullable
    protected Package createPackage() {
        IAndroidTarget target = this.getAndroidTarget();
        if (target != null) {
            return AddonPackage.create(target, this.getSourceProperties());
        }
        return null;
    }

    @Override
    @Nullable
    protected IAndroidTarget createAndroidTarget() {
        LocalSdk sdk = this.getLocalSdk();
        IFileOp fileOp = sdk.getFileOp();
        Pair<Map<String, String>, String> infos = this.parseAddonProperties();
        Map propertyMap = (Map)infos.getFirst();
        String error = (String)infos.getSecond();
        if (error != null) {
            this.appendLoadError("Ignoring add-on '%1$s': %2$s", this.getLocalDir().getName(), error);
            return null;
        }
        try {
            String[] libraries;
            assert (propertyMap != null);
            String api = (String)propertyMap.get("api");
            String name = (String)propertyMap.get("name");
            String vendor = (String)propertyMap.get("vendor");
            assert (api != null);
            assert (name != null);
            assert (vendor != null);
            PlatformTarget baseTarget = null;
            LocalPkgInfo plat = sdk.getPkgInfo(PkgType.PKG_PLATFORM, this.getDesc().getAndroidVersion());
            if (plat instanceof LocalPlatformPkgInfo) {
                baseTarget = (PlatformTarget)((LocalPlatformPkgInfo)plat).getAndroidTarget();
            }
            assert (baseTarget != null);
            String description = (String)propertyMap.get("description");
            int revisionValue = 1;
            String revision = (String)propertyMap.get("revision");
            if (revision == null) {
                revision = (String)propertyMap.get("version");
            }
            if (revision != null) {
                revisionValue = Integer.parseInt(revision);
            }
            String librariesValue = (String)propertyMap.get("libraries");
            HashMap<String, String[]> libMap = null;
            if (librariesValue != null && !(librariesValue = librariesValue.trim()).isEmpty() && (libraries = librariesValue.split(";")).length > 0) {
                libMap = new HashMap<String, String[]>();
                for (String libName : libraries) {
                    String libData = (String)propertyMap.get(libName = libName.trim());
                    if (libData != null) {
                        Matcher m = PATTERN_LIB_DATA.matcher(libData);
                        if (m.matches()) {
                            libMap.put(libName, new String[]{m.group(1), m.group(2)});
                            continue;
                        }
                        this.appendLoadError("Ignoring library '%1$s', property value has wrong format\n\t%2$s", libName, libData);
                        continue;
                    }
                    this.appendLoadError("Ignoring library '%1$s', missing property value", libName, libData);
                }
            }
            ISystemImage[] systemImages = this.getAddonSystemImages(fileOp);
            boolean hasRenderingLibrary = false;
            boolean hasRenderingResources = false;
            File dataFolder = new File(this.getLocalDir(), "data");
            if (fileOp.isDirectory(dataFolder)) {
                hasRenderingLibrary = fileOp.isFile(new File(dataFolder, "layoutlib.jar"));
                hasRenderingResources = fileOp.isDirectory(new File(dataFolder, "res")) && fileOp.isDirectory(new File(dataFolder, "fonts"));
            }
            AddOnTarget target = new AddOnTarget(this.getLocalDir().getAbsolutePath(), name, vendor, revisionValue, description, systemImages, libMap, hasRenderingLibrary, hasRenderingResources, baseTarget);
            File targetSkinFolder = target.getFile(5);
            TreeMap<String, File> skinsMap = new TreeMap<String, File>();
            for (File f : this.parseSkinFolder(targetSkinFolder)) {
                skinsMap.put(f.getName().toLowerCase(Locale.US), f);
            }
            for (ISystemImage si : systemImages) {
                for (File f : si.getSkins()) {
                    skinsMap.put(f.getName().toLowerCase(Locale.US), f);
                }
            }
            ArrayList skins = new ArrayList(skinsMap.values());
            Collections.sort(skins);
            File defaultSkin = null;
            String defaultSkinName = (String)propertyMap.get("skin");
            defaultSkin = defaultSkinName != null ? new File(targetSkinFolder, defaultSkinName) : (skins.size() == 1 ? (File)skins.get(0) : baseTarget.getDefaultSkin());
            int usbVendorId = this.convertId((String)propertyMap.get("usb-vendor"));
            if (usbVendorId != 0) {
                target.setUsbVendorId(usbVendorId);
            }
            target.setSkins(skins.toArray(new File[skins.size()]), defaultSkin);
            return target;
        }
        catch (Exception e) {
            this.appendLoadError("Ignoring add-on '%1$s': error %2$s.", this.getLocalDir().getName(), e.toString());
            return null;
        }
    }

    @NonNull
    private Pair<Map<String, String>, String> parseAddonProperties() {
        String error;
        Map<String, String> propertyMap;
        block8: {
            block13: {
                String api;
                block12: {
                    block11: {
                        block10: {
                            block7: {
                                File addOnManifest;
                                IFileOp fileOp;
                                block9: {
                                    propertyMap = null;
                                    error = null;
                                    fileOp = this.getLocalSdk().getFileOp();
                                    if (fileOp.isFile(addOnManifest = new File(this.getLocalDir(), "manifest.ini"))) break block9;
                                    error = String.format("File not found: %1$s", "manifest.ini");
                                    break block8;
                                }
                                try {
                                    propertyMap = ProjectProperties.parsePropertyStream(fileOp.newFileInputStream(addOnManifest), addOnManifest.getPath(), null);
                                    if (propertyMap != null) break block7;
                                    error = String.format("Failed to parse properties from %1$s", "manifest.ini");
                                    break block8;
                                }
                                catch (FileNotFoundException ignore) {
                                    // empty catch block
                                }
                            }
                            assert (propertyMap != null);
                            String name = (String)propertyMap.get("name");
                            if (name != null) break block10;
                            error = LocalAddonPkgInfo.addonManifestWarning("name");
                            break block8;
                        }
                        String vendor = propertyMap.get("vendor");
                        if (vendor != null) break block11;
                        error = LocalAddonPkgInfo.addonManifestWarning("vendor");
                        break block8;
                    }
                    api = propertyMap.get("api");
                    if (api != null) break block12;
                    error = LocalAddonPkgInfo.addonManifestWarning("api");
                    break block8;
                }
                IAndroidTarget baseTarget = null;
                LocalPkgInfo plat = this.getLocalSdk().getPkgInfo(PkgType.PKG_PLATFORM, this.getDesc().getAndroidVersion());
                if (plat instanceof LocalPlatformPkgInfo) {
                    baseTarget = ((LocalPlatformPkgInfo)plat).getAndroidTarget();
                }
                if (baseTarget != null) break block13;
                error = String.format("Unable to find base platform with API level '%1$s'", api);
                break block8;
            }
            String revision = propertyMap.get("revision");
            if (revision == null) {
                revision = propertyMap.get("version");
            }
            if (revision == null) break block8;
            try {
                Integer.parseInt(revision);
            }
            catch (NumberFormatException e) {
                error = String.format("%1$s is not a valid number in %2$s.", "revision", "build.prop");
            }
        }
        return Pair.of(propertyMap, (Object)error);
    }

    @NonNull
    private static String addonManifestWarning(@NonNull String valueName) {
        return String.format("'%1$s' is missing from %2$s.", valueName, "manifest.ini");
    }

    private int convertId(@Nullable String value) {
        if (value != null && !value.isEmpty() && PATTERN_USB_IDS.matcher(value).matches()) {
            String v = value.substring(2);
            try {
                return Integer.parseInt(v, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @NonNull
    private ISystemImage[] getAddonSystemImages(IFileOp fileOp) {
        File[] files;
        LocalPkgInfo[] sysImgInfos;
        TreeSet<SystemImage> found = new TreeSet<SystemImage>();
        TreeMultimap tagToAbiFound = TreeMultimap.create();
        for (LocalPkgInfo pkg : sysImgInfos = this.getLocalSdk().getPkgsInfos(PkgType.PKG_ADDON_SYS_IMAGE)) {
            IPkgDesc d = pkg.getDesc();
            if (!(pkg instanceof LocalAddonSysImgPkgInfo) || !d.hasVendor() || !this.mAddonDesc.getVendor().equals(d.getVendor()) || !this.mAddonDesc.getName().equals(d.getTag())) continue;
            IdDisplay tag = this.mAddonDesc.getName();
            String abi = d.getPath();
            if (abi == null || tagToAbiFound.containsEntry((Object)tag, (Object)abi)) continue;
            List<File> parsedSkins = this.parseSkinFolder(new File(pkg.getLocalDir(), "skins"));
            File[] skins = FileOp.EMPTY_FILE_ARRAY;
            if (!parsedSkins.isEmpty()) {
                skins = parsedSkins.toArray(new File[parsedSkins.size()]);
            }
            found.add(new SystemImage(pkg.getLocalDir(), ISystemImage.LocationType.IN_SYSTEM_IMAGE, tag, this.mAddonDesc.getVendor(), abi, skins));
            tagToAbiFound.put((Object)tag, (Object)abi);
        }
        boolean useLegacy = true;
        boolean hasImgFiles = false;
        IdDisplay defaultTag = SystemImage.DEFAULT_TAG;
        File imagesDir = new File(this.getLocalDir(), SdkConstants.OS_IMAGES_FOLDER);
        for (File file : files = fileOp.listFiles(imagesDir)) {
            if (fileOp.isDirectory(file)) {
                useLegacy = false;
                String abi = file.getName();
                if (tagToAbiFound.containsEntry((Object)defaultTag, (Object)abi)) continue;
                found.add(new SystemImage(file, ISystemImage.LocationType.IN_IMAGES_SUBFOLDER, SystemImage.DEFAULT_TAG, this.mAddonDesc.getVendor(), abi, FileOp.EMPTY_FILE_ARRAY));
                tagToAbiFound.put((Object)defaultTag, (Object)abi);
                continue;
            }
            if (hasImgFiles || !fileOp.isFile(file) || !file.getName().endsWith(".img")) continue;
            hasImgFiles = true;
        }
        if (useLegacy && hasImgFiles && fileOp.isDirectory(imagesDir) && !tagToAbiFound.containsEntry((Object)defaultTag, (Object)"armeabi")) {
            found.add(new SystemImage(imagesDir, ISystemImage.LocationType.IN_LEGACY_FOLDER, SystemImage.DEFAULT_TAG, "armeabi", FileOp.EMPTY_FILE_ARRAY));
        }
        return found.toArray(new ISystemImage[found.size()]);
    }
}

