/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.overrideImplement;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementExploreUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyChangeContextUtil;

public class GroovyOverrideImplementUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementUtil");

    private GroovyOverrideImplementUtil() {
    }

    public static GrMethod generateMethodPrototype(GrTypeDefinition aClass, PsiMethod method, PsiSubstitutor substitutor) {
        Project project = aClass.getProject();
        boolean isAbstract = method.hasModifierProperty("abstract");
        String templName = isAbstract ? "Implemented Method Body.java" : "Overridden Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance().getCodeTemplate(templName);
        GrMethod result = (GrMethod)GenerateMembersUtil.substituteGenericMethod((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiElement)aClass);
        GroovyOverrideImplementUtil.setupModifierList(result);
        GroovyOverrideImplementUtil.setupOverridingMethodBody(project, method, result, template, substitutor);
        GroovyOverrideImplementUtil.setupReturnType(result, method);
        GroovyOverrideImplementUtil.setupAnnotations(aClass, method, result);
        GroovyChangeContextUtil.encodeContextInfo(result);
        return result;
    }

    public static GrMethod generateTraitMethodPrototype(GrTypeDefinition aClass, GrTraitMethod method, PsiSubstitutor substitutor) {
        Project project = aClass.getProject();
        GrMethod result = (GrMethod)GenerateMembersUtil.substituteGenericMethod((PsiMethod)method, (PsiSubstitutor)substitutor, (PsiElement)aClass);
        GroovyOverrideImplementUtil.setupModifierList(result);
        GroovyOverrideImplementUtil.setupTraitMethodBody(project, result, method);
        GroovyOverrideImplementUtil.setupReturnType(result, method);
        GroovyOverrideImplementUtil.setupAnnotations(aClass, method, result);
        GroovyChangeContextUtil.encodeContextInfo(result);
        return result;
    }

    private static void setupReturnType(GrMethod result, PsiMethod method) {
        if (method instanceof GrMethod && ((GrMethod)method).getReturnTypeElementGroovy() == null) {
            result.setReturnType(null);
            GrModifierList modifierList = result.getModifierList();
            if (!modifierList.hasExplicitVisibilityModifiers()) {
                modifierList.setModifierProperty("def", true);
            }
        }
    }

    private static void setupAnnotations(@NotNull GrTypeDefinition aClass, @NotNull PsiMethod method, @NotNull GrMethod result) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "setupAnnotations"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "setupAnnotations"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "setupAnnotations"));
        }
        if (OverrideImplementUtil.isInsertOverride((PsiMethod)method, (PsiClass)aClass)) {
            result.getModifierList().addAnnotation("java.lang.Override");
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
        PsiParameter[] originalParams = method.getParameterList().getParameters();
        GrParameter[] parameters = result.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            GrParameter parameter = parameters[i];
            PsiParameter original = originalParams[i];
            for (PsiAnnotation annotation : original.getModifierList().getAnnotations()) {
                GrModifierList modifierList = parameter.getModifierList();
                String qname = annotation.getQualifiedName();
                if (qname == null || modifierList.findAnnotation(qname) != null) continue;
                if (annotation instanceof GrAnnotation) {
                    modifierList.add((PsiElement)annotation);
                    continue;
                }
                modifierList.add(factory.createAnnotationFromText(annotation.getText()));
            }
        }
    }

    private static void setupModifierList(GrMethod result) {
        GrModifierList modifierList = result.getModifierList();
        modifierList.setModifierProperty("abstract", false);
        modifierList.setModifierProperty("native", false);
    }

    @Nullable
    private static PsiType getSuperReturnType(@NotNull PsiMethod superMethod) {
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "getSuperReturnType"));
        }
        if (superMethod instanceof GrMethod) {
            GrTypeElement element = ((GrMethod)superMethod).getReturnTypeElementGroovy();
            return element != null ? element.getType() : null;
        }
        return superMethod.getReturnType();
    }

    private static void setupOverridingMethodBody(Project project, PsiMethod method, GrMethod resultMethod, FileTemplate template, PsiSubstitutor substitutor) {
        PsiType returnType = substitutor.substitute(GroovyOverrideImplementUtil.getSuperReturnType(method));
        String returnTypeText = "";
        if (returnType != null) {
            returnTypeText = returnType.getPresentableText();
        }
        Properties properties = FileTemplateManager.getInstance().getDefaultProperties(project);
        properties.setProperty("RETURN_TYPE", returnTypeText);
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType));
        properties.setProperty("CALL_SUPER", GroovyOverrideImplementUtil.callSuper(method, resultMethod));
        JavaTemplateUtil.setClassAndMethodNameProperties((Properties)properties, (PsiClass)method.getContainingClass(), (PsiMethod)resultMethod);
        try {
            String bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
            GroovyFile file = GroovyPsiElementFactory.getInstance(project).createGroovyFile("\n " + bodyText + "\n", false, null);
            GrOpenBlock block = resultMethod.getBlock();
            block.getNode().addChildren(file.getFirstChild().getNode(), null, block.getRBrace().getNode());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void setupTraitMethodBody(Project project, GrMethod resultMethod, GrTraitMethod traitMethod) {
        GrParameter[] parameters;
        PsiClass traitClass = traitMethod.getPrototype().getContainingClass();
        StringBuilder builder = new StringBuilder();
        builder.append("\nreturn ");
        builder.append(traitClass.getQualifiedName());
        builder.append(".super.");
        builder.append(traitMethod.getName());
        builder.append("(");
        for (GrParameter parameter : parameters = resultMethod.getParameters()) {
            builder.append(parameter.getName()).append(",");
        }
        if (parameters.length > 0) {
            builder.replace(builder.length() - 1, builder.length(), ")\n");
        } else {
            builder.append(")\n");
        }
        GroovyFile file = GroovyPsiElementFactory.getInstance(project).createGroovyFile(builder, false, null);
        GrOpenBlock block = resultMethod.getBlock();
        block.getNode().addChildren(file.getFirstChild().getNode(), null, block.getRBrace().getNode());
    }

    public static void chooseAndOverrideMethods(@NotNull Project project, @NotNull Editor editor, @NotNull GrTypeDefinition aClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndOverrideMethods"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndOverrideMethods"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndOverrideMethods"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        GroovyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, false);
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull GrTypeDefinition aClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndImplementMethods"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndImplementMethods"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndImplementMethods"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        GroovyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, true);
    }

    public static void chooseAndOverrideOrImplementMethods(@NotNull Project project, final @NotNull Editor editor, final @NotNull GrTypeDefinition aClass, boolean toImplement) {
        MemberChooser chooser;
        ArrayList secondary;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "chooseAndOverrideOrImplementMethods"));
        }
        LOG.assertTrue(aClass.isValid());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<CandidateInfo> candidates = GroovyOverrideImplementExploreUtil.getMethodsToOverrideImplement(aClass, toImplement);
        Collection<Object> collection = secondary = toImplement || aClass.isInterface() ? ContainerUtil.newArrayList() : GroovyOverrideImplementExploreUtil.getMethodsToOverrideImplement(aClass, true);
        if (toImplement) {
            Iterator<CandidateInfo> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                GrMethod method;
                CandidateInfo candidate = iterator.next();
                PsiElement element = candidate.getElement();
                if (!(element instanceof GrMethod) || !GrTraitUtil.isTrait((method = (GrMethod)element).getContainingClass()) || GrTraitUtil.isMethodAbstract(method)) continue;
                iterator.remove();
                secondary.add(candidate);
            }
        }
        if ((chooser = OverrideImplementUtil.showOverrideImplementChooser((Editor)editor, (PsiElement)aClass, (boolean)toImplement, candidates, (Collection)secondary)) == null) {
            return;
        }
        final List selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        new WriteCommandAction(project, new PsiFile[]{aClass.getContainingFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil$1", "run"));
                }
                OverrideImplementUtil.overrideOrImplementMethodsInRightPlace((Editor)editor, (PsiClass)aClass, (Collection)selectedElements, (boolean)chooser.isCopyJavadoc(), (boolean)chooser.isInsertOverrideAnnotation());
            }
        }.execute();
    }

    @NotNull
    private static String callSuper(PsiMethod superMethod, PsiMethod overriding) {
        StringBuilder buffer = new StringBuilder();
        if (!superMethod.isConstructor() && superMethod.getReturnType() != PsiType.VOID) {
            buffer.append("return ");
        }
        buffer.append("super");
        PsiParameter[] parms = overriding.getParameterList().getParameters();
        if (!superMethod.isConstructor()) {
            buffer.append(".");
            buffer.append(superMethod.getName());
        }
        buffer.append("(");
        for (int i = 0; i < parms.length; ++i) {
            String name = parms[i].getName();
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(name);
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil", "callSuper"));
        }
        return string;
    }
}

