/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgLogSingleCommitAction;
import org.zmlx.hg4idea.action.HgUpdateToAction;
import org.zmlx.hg4idea.branch.HgBranchPopupActions;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCreateNewBranchFromLogAction
extends HgLogSingleCommitAction {
    protected void actionPerformed(final @NotNull HgRepository repository, @NotNull VcsFullCommitDetails commit) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/action/HgCreateNewBranchFromLogAction", "actionPerformed"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "org/zmlx/hg4idea/action/HgCreateNewBranchFromLogAction", "actionPerformed"));
        }
        final Hash revisionHash = (Hash)commit.getId();
        final Project project = repository.getProject();
        FileDocumentManager.getInstance().saveAllDocuments();
        String shortHash = revisionHash.toShortString();
        final String name = HgUtil.getNewBranchNameFromUser(repository, "Create New Branch From " + shortHash);
        if (name != null) {
            new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.progress.updatingTo", shortHash)){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/HgCreateNewBranchFromLogAction$1", "run"));
                    }
                    if (HgUpdateToAction.updateTo(project, repository.getRoot(), revisionHash.asString(), false)) {
                        new HgBranchPopupActions.HgNewBranchAction(project, Collections.singletonList(repository), repository).createNewBranch(name);
                    }
                }
            }.queue();
        }
    }
}

