/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.arrangement.additional.ForceArrangementPanel;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProviderImpl;
import com.intellij.application.options.codeStyle.arrangement.group.ArrangementGroupingRulesPanel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementColorsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArrangementSettingsPanel
extends CodeStyleAbstractPanel {
    @NotNull
    private final JPanel myContent;
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ArrangementStandardSettingsAware mySettingsAware;
    @NotNull
    private final ArrangementGroupingRulesPanel myGroupingRulesPanel;
    @NotNull
    private final ArrangementMatchingRulesPanel myMatchingRulesPanel;
    @Nullable
    private final ForceArrangementPanel myForceArrangementPanel;

    public ArrangementSettingsPanel(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "<init>"));
        }
        super(settings);
        this.myContent = new JPanel(new GridBagLayout());
        this.myLanguage = language;
        Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(language);
        assert (rearranger instanceof ArrangementStandardSettingsAware);
        this.mySettingsAware = (ArrangementStandardSettingsAware)rearranger;
        ArrangementColorsProviderImpl colorsProvider = rearranger instanceof ArrangementColorsAware ? new ArrangementColorsProviderImpl((ArrangementColorsAware)rearranger) : new ArrangementColorsProviderImpl(null);
        ArrangementStandardSettingsManager settingsManager = new ArrangementStandardSettingsManager(this.mySettingsAware, (ArrangementColorsProvider)colorsProvider);
        this.myGroupingRulesPanel = new ArrangementGroupingRulesPanel(settingsManager, colorsProvider);
        this.myMatchingRulesPanel = new ArrangementMatchingRulesPanel(this.myLanguage, settingsManager, colorsProvider);
        this.myContent.add((Component)this.myGroupingRulesPanel, new GridBag().coverLine().fillCellHorizontally().weightx(1.0));
        this.myContent.add((Component)this.myMatchingRulesPanel, new GridBag().fillCell().weightx(1.0).weighty(1.0).coverLine());
        if (settings.getCommonSettings(this.myLanguage).isForceArrangeMenuAvailable()) {
            this.myForceArrangementPanel = new ForceArrangementPanel();
            this.myForceArrangementPanel.setSelectedMode(settings.getCommonSettings((Language)language).FORCE_REARRANGE_MODE);
            this.myContent.add((Component)this.myForceArrangementPanel.getPanel(), new GridBag().anchor(17).coverLine().fillCellHorizontally());
        } else {
            this.myForceArrangementPanel = null;
        }
        List groupingTokens = settingsManager.getSupportedGroupingTokens();
        this.myGroupingRulesPanel.setVisible(groupingTokens != null && !groupingTokens.isEmpty());
        this.registerShortcut("Arrangement.Rule.Add", CommonShortcuts.getNew(), this.myMatchingRulesPanel);
        this.registerShortcut("Arrangement.Rule.Remove", CommonShortcuts.getDelete(), this.myMatchingRulesPanel);
        this.registerShortcut("Arrangement.Rule.Match.Condition.Move.Up", CommonShortcuts.MOVE_UP, this.myMatchingRulesPanel);
        this.registerShortcut("Arrangement.Rule.Match.Condition.Move.Down", CommonShortcuts.MOVE_DOWN, this.myMatchingRulesPanel);
        CustomShortcutSet edit = new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0));
        this.registerShortcut("Arrangement.Rule.Edit", (ShortcutSet)edit, this.myMatchingRulesPanel);
        this.registerShortcut("Arrangement.Rule.Group.Condition.Move.Up", CommonShortcuts.MOVE_UP, this.myGroupingRulesPanel);
        this.registerShortcut("Arrangement.Rule.Group.Condition.Move.Down", CommonShortcuts.MOVE_DOWN, this.myGroupingRulesPanel);
    }

    private void registerShortcut(@NotNull String actionId, @NotNull ShortcutSet shortcut, @NotNull JComponent component) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "registerShortcut"));
        }
        if (shortcut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcut", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "registerShortcut"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "registerShortcut"));
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        if (action != null) {
            action.registerCustomShortcutSet(shortcut, component, (Disposable)this);
        }
    }

    @Override
    @Nullable
    public JComponent getPanel() {
        return this.myContent;
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return null;
    }

    @Nullable
    private StdArrangementSettings getSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "getSettings"));
        }
        StdArrangementSettings result = (StdArrangementSettings)settings.getCommonSettings(this.myLanguage).getArrangementSettings();
        if (result == null) {
            result = this.mySettingsAware.getDefaultSettings();
        }
        return result;
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.myLanguage);
        commonSettings.setArrangementSettings((ArrangementSettings)this.createSettings());
        if (this.myForceArrangementPanel != null) {
            commonSettings.FORCE_REARRANGE_MODE = this.myForceArrangementPanel.getRearrangeMode();
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        StdArrangementSettings s = this.createSettings();
        return !Comparing.equal((Object)this.getSettings(settings), (Object)s) || this.myForceArrangementPanel != null && settings.getCommonSettings((Language)this.myLanguage).FORCE_REARRANGE_MODE != this.myForceArrangementPanel.getRearrangeMode();
    }

    private StdArrangementSettings createSettings() {
        List<ArrangementGroupingRule> groupingRules = this.myGroupingRulesPanel.getRules();
        return new StdArrangementSettings(groupingRules, this.myMatchingRulesPanel.getSections());
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        StdArrangementSettings s = this.getSettings(settings);
        if (s == null) {
            this.myGroupingRulesPanel.setRules(null);
            this.myMatchingRulesPanel.setSections(null);
        } else {
            List groupings = s.getGroupings();
            this.myGroupingRulesPanel.setRules(ContainerUtilRt.newArrayList((Iterable)groupings));
            this.myMatchingRulesPanel.setSections(ArrangementSettingsPanel.copy(s.getSections()));
            if (this.myForceArrangementPanel != null) {
                this.myForceArrangementPanel.setSelectedMode(settings.getCommonSettings((Language)this.myLanguage).FORCE_REARRANGE_MODE);
            }
        }
    }

    @NotNull
    private static List<ArrangementSectionRule> copy(@NotNull List<ArrangementSectionRule> rules) {
        if (rules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "copy"));
        }
        ArrayList<ArrangementSectionRule> result = new ArrayList<ArrangementSectionRule>();
        for (ArrangementSectionRule rule : rules) {
            result.add(rule.clone());
        }
        ArrayList<ArrangementSectionRule> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/ArrangementSettingsPanel", "copy"));
        }
        return arrayList;
    }

    @Override
    protected String getTabTitle() {
        return ApplicationBundle.message((String)"arrangement.title.settings.tab", (Object[])new Object[0]);
    }
}

