/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.reference.UnusedDeclarationFixProvider;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.findUsages.JavaPackageFindUsagesOptions;
import com.intellij.find.findUsages.JavaVariableFindUsagesOptions;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.Predicate;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class PostHighlightingPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PostHighlightingPass");
    private static final Key<Long> LAST_POST_PASS_TIMESTAMP = Key.create((String)"LAST_POST_PASS_TIMESTAMP");
    private final LanguageLevel myLanguageLevel;
    private RefCountHolder myRefCountHolder;
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final Predicate<PsiElement> myIsEntryPointPredicate;
    private final int myStartOffset;
    private final int myEndOffset;
    private Collection<HighlightInfo> myHighlights;
    private boolean myHasRedundantImports;
    private int myCurrentEntryIndex;
    private boolean myHasMissortedImports;
    private static final ImplicitUsageProvider[] ourImplicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);
    private UnusedSymbolLocalInspectionBase myUnusedSymbolInspection;
    private HighlightDisplayKey myUnusedSymbolKey;
    private boolean myInLibrary;
    private HighlightDisplayKey myDeadCodeKey;
    private HighlightInfoType myDeadCodeInfoType;

    public PostHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor, @NotNull Predicate<PsiElement> isEntryPoint) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "<init>"));
        }
        if (isEntryPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isEntryPoint", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "<init>"));
        }
        super(project, document, "Unused symbols", file, editor, file.getTextRange(), true, highlightInfoProcessor);
        this.myFile = file;
        this.myEditor = editor;
        this.myIsEntryPointPredicate = isEntryPoint;
        this.myStartOffset = 0;
        this.myEndOffset = file.getTextLength();
        this.myCurrentEntryIndex = -1;
        this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)file);
    }

    static boolean isUpToDate(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isUpToDate"));
        }
        Long lastStamp = (Long)file.getUserData(LAST_POST_PASS_TIMESTAMP);
        long currentStamp = PsiModificationTracker.SERVICE.getInstance((Project)file.getProject()).getModificationCount();
        return lastStamp != null && lastStamp == currentStamp || !ProblemHighlightFilter.shouldHighlightFile((PsiFile)file);
    }

    private static void markFileUpToDate(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "markFileUpToDate"));
        }
        long lastStamp = PsiModificationTracker.SERVICE.getInstance((Project)file.getProject()).getModificationCount();
        file.putUserData(LAST_POST_PASS_TIMESTAMP, (Object)lastStamp);
    }

    private static boolean isInjected(@NotNull Project project, @NotNull PsiModifierListOwner modifierListOwner) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isInjected"));
        }
        if (modifierListOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isInjected"));
        }
        return EntryPointsManagerBase.getInstance(project).isEntryPoint((PsiElement)modifierListOwner);
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        VirtualFile virtualFile;
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "collectInformationWithProgress"));
        }
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap fileStatusMap = daemonCodeAnalyzer.getFileStatusMap();
        ArrayList highlights = new ArrayList();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        THashSet elementSet = new THashSet();
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)psiRoot)) continue;
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, this.myStartOffset, this.myEndOffset);
            elementSet.addAll(elements);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myInLibrary = fileIndex.isInLibraryClasses(virtualFile = viewProvider.getVirtualFile()) || fileIndex.isInLibrarySource(virtualFile);
        this.myRefCountHolder = RefCountHolder.endUsing(this.myFile, progress);
        boolean r = true;
        if (this.myRefCountHolder == null || !(r = this.myRefCountHolder.retrieveUnusedReferencesInfo(progress, new Runnable((Set)elementSet, highlights, progress, fileStatusMap){
            final /* synthetic */ Set val$elementSet;
            final /* synthetic */ List val$highlights;
            final /* synthetic */ ProgressIndicator val$progress;
            final /* synthetic */ FileStatusMap val$fileStatusMap;
            {
                this.val$elementSet = set;
                this.val$highlights = list;
                this.val$progress = progressIndicator;
                this.val$fileStatusMap = fileStatusMap;
            }

            @Override
            public void run() {
                boolean errorFound = PostHighlightingPass.this.collectHighlights(this.val$elementSet, this.val$highlights, this.val$progress);
                PostHighlightingPass.this.myHighlights = this.val$highlights;
                if (errorFound) {
                    this.val$fileStatusMap.setErrorFoundFlag(PostHighlightingPass.this.myDocument, true);
                }
            }
        }))) {
            FileStatusMap.log("myRefCountHolder: ", this.myRefCountHolder, "; retrieved: ", r);
            fileStatusMap.markFileScopeDirty(this.getDocument(), 4);
            GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject, this);
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        Collection<HighlightInfo> infos = this.myHighlights;
        ArrayList<HighlightInfo> arrayList = infos == null ? Collections.emptyList() : new ArrayList<HighlightInfo>(infos);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "getInfos"));
        }
        return arrayList;
    }

    @Override
    protected void applyInformationWithProgress() {
        if (this.myHighlights == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myStartOffset, this.myEndOffset, this.myHighlights, this.getColorsScheme(), 5);
        PostHighlightingPass.markFileUpToDate(this.myFile);
        Editor editor = this.myEditor;
        if (editor != null) {
            this.optimizeImportsOnTheFly(editor);
        }
    }

    private void optimizeImportsOnTheFly(@NotNull Editor editor) {
        IntentionAction optimizeImportsFix;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "optimizeImportsOnTheFly"));
        }
        if ((this.myHasRedundantImports || this.myHasMissortedImports) && (optimizeImportsFix = QuickFixFactory.getInstance().createOptimizeImportsFix(true)).isAvailable(this.myProject, editor, this.myFile) && this.myFile.isWritable()) {
            optimizeImportsFix.invoke(this.myProject, editor, this.myFile);
        }
    }

    private boolean collectHighlights(@NotNull Collection<PsiElement> elements, @NotNull List<HighlightInfo> result, @NotNull ProgressIndicator progress) throws ProcessCanceledException {
        PsiImportList importList;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "collectHighlights"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "collectHighlights"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "collectHighlights"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        this.myUnusedSymbolKey = HighlightDisplayKey.find((String)"UNUSED_SYMBOL");
        boolean unusedSymbolEnabled = profile.isToolEnabled(this.myUnusedSymbolKey, (PsiElement)this.myFile);
        this.myUnusedSymbolInspection = (UnusedSymbolLocalInspectionBase)profile.getUnwrappedTool("UNUSED_SYMBOL", (PsiElement)this.myFile);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || this.myUnusedSymbolInspection != null);
        this.myDeadCodeKey = HighlightDisplayKey.find((String)"UnusedDeclaration");
        HighlightDisplayKey unusedImportKey = HighlightDisplayKey.find((String)"UNUSED_IMPORT");
        this.myDeadCodeInfoType = this.myDeadCodeKey == null ? HighlightInfoType.UNUSED_SYMBOL : new HighlightInfoType.HighlightInfoTypeImpl(profile.getErrorLevel(this.myDeadCodeKey, (PsiElement)this.myFile).getSeverity(), HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
        GlobalUsageHelper helper = new GlobalUsageHelper(){

            @Override
            public boolean shouldCheckUsages(@NotNull PsiMember member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass$2", "shouldCheckUsages"));
                }
                return !PostHighlightingPass.this.myInLibrary && !PostHighlightingPass.this.myIsEntryPointPredicate.apply((Object)member);
            }

            @Override
            public boolean isCurrentFileAlreadyChecked() {
                return true;
            }

            @Override
            public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass$2", "isLocallyUsed"));
                }
                return PostHighlightingPass.this.myRefCountHolder.isReferenced(member);
            }
        };
        boolean errorFound = false;
        if (unusedSymbolEnabled) {
            for (PsiElement element : elements) {
                PsiIdentifier identifier;
                HighlightInfo info;
                progress.checkCanceled();
                if (!(element instanceof PsiIdentifier) || (info = this.processIdentifier(identifier = (PsiIdentifier)element, progress, helper)) == null) continue;
                errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                result.add(info);
            }
        }
        if (this.isUnusedImportEnabled(unusedImportKey) && (importList = ((PsiJavaFile)this.myFile).getImportList()) != null) {
            PsiImportStatementBase[] imports;
            for (PsiImportStatementBase statement : imports = importList.getAllImportStatements()) {
                progress.checkCanceled();
                HighlightInfo info = this.processImport(statement, unusedImportKey);
                if (info == null) continue;
                errorFound |= info.getSeverity() == HighlightSeverity.ERROR;
                result.add(info);
            }
        }
        return errorFound;
    }

    protected boolean isUnusedImportEnabled(HighlightDisplayKey unusedImportKey) {
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        if (!profile.isToolEnabled(unusedImportKey, (PsiElement)this.myFile)) {
            return false;
        }
        return this.myFile instanceof PsiJavaFile && HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)this.myFile);
    }

    @Nullable
    private HighlightInfo processIdentifier(@NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processIdentifier"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processIdentifier"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processIdentifier"));
        }
        if (SuppressionUtil.inspectionResultSuppressed((PsiElement)identifier, (LocalInspectionTool)this.myUnusedSymbolInspection)) {
            return null;
        }
        PsiElement parent = identifier.getParent();
        if (PsiUtilCore.hasErrorElementChild((PsiElement)parent)) {
            return null;
        }
        if (parent instanceof PsiLocalVariable && this.myUnusedSymbolInspection.LOCAL_VARIABLE) {
            return this.processLocalVariable((PsiLocalVariable)parent, identifier, progress);
        }
        if (parent instanceof PsiField && this.myUnusedSymbolInspection.FIELD) {
            return this.processField(this.myProject, (PsiField)parent, identifier, progress, helper);
        }
        if (parent instanceof PsiParameter && this.myUnusedSymbolInspection.PARAMETER) {
            if (SuppressionUtil.isSuppressed((PsiElement)identifier, "UnusedParameters")) {
                return null;
            }
            return this.processParameter(this.myProject, (PsiParameter)parent, identifier, progress);
        }
        if (parent instanceof PsiMethod && this.myUnusedSymbolInspection.METHOD) {
            return this.processMethod(this.myProject, (PsiMethod)parent, identifier, progress, helper);
        }
        if (parent instanceof PsiClass && this.myUnusedSymbolInspection.CLASS) {
            return this.processClass(this.myProject, (PsiClass)parent, identifier, progress, helper);
        }
        return null;
    }

    @Nullable
    private HighlightInfo processLocalVariable(@NotNull PsiLocalVariable variable, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processLocalVariable"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processLocalVariable"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processLocalVariable"));
        }
        if (variable instanceof PsiResourceVariable && PsiUtil.isIgnoredName((String)variable.getName())) {
            return null;
        }
        if (PostHighlightingPass.isImplicitUsage(this.myProject, (PsiModifierListOwner)variable, progress)) {
            return null;
        }
        if (!this.myRefCountHolder.isReferenced((PsiNamedElement)variable)) {
            String message = JavaErrorMessages.message("local.variable.is.never.used", identifier.getText());
            HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
            IntentionAction fix = variable instanceof PsiResourceVariable ? QuickFixFactory.getInstance().createRenameToIgnoredFix((PsiNamedElement)variable) : QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable);
            QuickFixAction.registerQuickFixAction(highlightInfo, fix, this.myUnusedSymbolKey);
            return highlightInfo;
        }
        boolean referenced = this.myRefCountHolder.isReferencedForRead((PsiVariable)variable);
        if (!referenced && !PostHighlightingPass.isImplicitRead(this.myProject, (PsiVariable)variable, progress)) {
            String message = JavaErrorMessages.message("local.variable.is.not.used.for.reading", identifier.getText());
            HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)variable), this.myUnusedSymbolKey);
            return highlightInfo;
        }
        if (!(variable.hasInitializer() || (referenced = this.myRefCountHolder.isReferencedForWrite((PsiVariable)variable)) || PostHighlightingPass.isImplicitWrite(this.myProject, (PsiVariable)variable, progress))) {
            String message = JavaErrorMessages.message("local.variable.is.not.assigned", identifier.getText());
            HighlightInfo unusedSymbolInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
            QuickFixAction.registerQuickFixAction(unusedSymbolInfo, new EmptyIntentionAction(UnusedSymbolLocalInspectionBase.DISPLAY_NAME), this.myUnusedSymbolKey);
            return unusedSymbolInfo;
        }
        return null;
    }

    public static boolean isImplicitUsage(@NotNull Project project, @NotNull PsiModifierListOwner element, @NotNull ProgressIndicator progress) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitUsage"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitUsage"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitUsage"));
        }
        if (PostHighlightingPass.isInjected(project, element)) {
            return true;
        }
        for (ImplicitUsageProvider provider : ourImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitUsage((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    private static boolean isImplicitRead(@NotNull Project project, @NotNull PsiVariable element, @NotNull ProgressIndicator progress) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitRead"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitRead"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitRead"));
        }
        for (ImplicitUsageProvider provider : ourImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitRead((PsiElement)element)) continue;
            return true;
        }
        return PostHighlightingPass.isInjected(project, (PsiModifierListOwner)element);
    }

    private static boolean isImplicitWrite(@NotNull Project project, @NotNull PsiVariable element, @NotNull ProgressIndicator progress) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitWrite"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitWrite"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isImplicitWrite"));
        }
        for (ImplicitUsageProvider provider : ourImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitWrite((PsiElement)element)) continue;
            return true;
        }
        return PostHighlightingPass.isInjected(project, (PsiModifierListOwner)element);
    }

    @Nullable
    public static HighlightInfo createUnusedSymbolInfo(@NotNull PsiElement element, @NotNull String message, @NotNull HighlightInfoType highlightInfoType) {
        UnusedDeclarationFixProvider[] fixProviders;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "createUnusedSymbolInfo"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "createUnusedSymbolInfo"));
        }
        if (highlightInfoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoType", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "createUnusedSymbolInfo"));
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(highlightInfoType).range(element).descriptionAndTooltip(message).create();
        if (info == null) {
            return null;
        }
        for (UnusedDeclarationFixProvider provider : fixProviders = (UnusedDeclarationFixProvider[])Extensions.getExtensions((ExtensionPointName)UnusedDeclarationFixProvider.EP_NAME)) {
            IntentionAction[] fixes;
            for (IntentionAction fix : fixes = provider.getQuickFixes(element)) {
                QuickFixAction.registerQuickFixAction(info, fix);
            }
        }
        return info;
    }

    @Nullable
    private HighlightInfo processField(final @NotNull Project project, @NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processField"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processField"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processField"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processField"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processField"));
        }
        if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
            return null;
        }
        if (field.hasModifierProperty("private")) {
            if (!this.myRefCountHolder.isReferenced((PsiNamedElement)field) && !PostHighlightingPass.isImplicitUsage(this.myProject, (PsiModifierListOwner)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.used", identifier.getText());
                HighlightInfo highlightInfo = this.suggestionsToMakeFieldUsed(field, identifier, message);
                if (!field.hasInitializer()) {
                    QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), QuickFixFactory.getInstance().createCreateConstructorParameterFromFieldFix(field));
                }
                return highlightInfo;
            }
            boolean readReferenced = this.myRefCountHolder.isReferencedForRead((PsiVariable)field);
            if (!readReferenced && !PostHighlightingPass.isImplicitRead(project, (PsiVariable)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.used.for.reading", identifier.getText());
                return this.suggestionsToMakeFieldUsed(field, identifier, message);
            }
            if (field.hasInitializer()) {
                return null;
            }
            boolean writeReferenced = this.myRefCountHolder.isReferencedForWrite((PsiVariable)field);
            if (!writeReferenced && !PostHighlightingPass.isImplicitWrite(project, (PsiVariable)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.assigned", identifier.getText());
                final HighlightInfo info = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
                QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(false, true, field), this.myUnusedSymbolKey);
                QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange((PsiElement)field), QuickFixFactory.getInstance().createCreateConstructorParameterFromFieldFix(field));
                SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)field, new Processor<String>(){

                    public boolean process(String annoName) {
                        QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, annoName, "fields"));
                        return true;
                    }
                });
                return info;
            }
        } else {
            if (PostHighlightingPass.isImplicitUsage(this.myProject, (PsiModifierListOwner)field, progress)) {
                return null;
            }
            if (PostHighlightingPass.isFieldUnused(this.myProject, this.myFile, field, progress, helper)) {
                return PostHighlightingPass.formatUnusedSymbolHighlightInfo(project, "field.is.not.used", (PsiNameIdentifierOwner)field, "fields", this.myDeadCodeKey, this.myDeadCodeInfoType, (PsiElement)identifier);
            }
        }
        return null;
    }

    public static boolean isFieldUnused(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiField field, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isFieldUnused"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isFieldUnused"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isFieldUnused"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isFieldUnused"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isFieldUnused"));
        }
        if (helper.isLocallyUsed((PsiNamedElement)field) || !PostHighlightingPass.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)field, progress, helper)) {
            return false;
        }
        return !(field instanceof PsiEnumConstant) || !PostHighlightingPass.isEnumValuesMethodUsed(project, containingFile, (PsiMember)field, progress, helper);
    }

    private HighlightInfo suggestionsToMakeFieldUsed(@NotNull PsiField field, @NotNull PsiIdentifier identifier, @NotNull String message) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "suggestionsToMakeFieldUsed"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "suggestionsToMakeFieldUsed"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "suggestionsToMakeFieldUsed"));
        }
        HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)field), this.myUnusedSymbolKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, false, field), this.myUnusedSymbolKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(false, true, field), this.myUnusedSymbolKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createCreateGetterOrSetterFix(true, true, field), this.myUnusedSymbolKey);
        return highlightInfo;
    }

    private static boolean isOverriddenOrOverrides(PsiMethod method) {
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    @Nullable
    private HighlightInfo processParameter(@NotNull Project project, @NotNull PsiParameter parameter, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress) {
        HighlightInfo highlightInfo;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processParameter"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processParameter"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processParameter"));
        }
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)declarationScope;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
                return null;
            }
            if ((method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || !method.hasModifierProperty("abstract") && this.myUnusedSymbolInspection.REPORT_PARAMETER_FOR_PUBLIC_METHODS && !PostHighlightingPass.isOverriddenOrOverrides(method)) && !method.hasModifierProperty("native") && !JavaHighlightUtil.isSerializationRelatedMethod(method, method.getContainingClass()) && !PsiClassImplUtil.isMainOrPremainMethod(method)) {
                if (PostHighlightingPass.isInjected(project, (PsiModifierListOwner)method)) {
                    return null;
                }
                HighlightInfo highlightInfo2 = this.checkUnusedParameter(parameter, identifier, progress);
                if (highlightInfo2 != null) {
                    QuickFixFactory.getInstance().registerFixesForUnusedParameter(parameter, (Object)highlightInfo2);
                    return highlightInfo2;
                }
            }
        } else if (declarationScope instanceof PsiForeachStatement && !PsiUtil.isIgnoredName((String)parameter.getName()) && (highlightInfo = this.checkUnusedParameter(parameter, identifier, progress)) != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createRenameToIgnoredFix((PsiNamedElement)parameter), this.myUnusedSymbolKey);
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private HighlightInfo checkUnusedParameter(@NotNull PsiParameter parameter, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "checkUnusedParameter"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "checkUnusedParameter"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "checkUnusedParameter"));
        }
        if (!this.myRefCountHolder.isReferenced((PsiNamedElement)parameter) && !PostHighlightingPass.isImplicitUsage(this.myProject, (PsiModifierListOwner)parameter, progress)) {
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiMethod && this.myRefCountHolder.isReferencedByMethodReference((PsiMethod)declarationScope, this.myLanguageLevel)) {
                return null;
            }
            String message = JavaErrorMessages.message("parameter.is.not.used", identifier.getText());
            return PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
        }
        return null;
    }

    @Nullable
    private HighlightInfo processMethod(final @NotNull Project project, @NotNull PsiMethod method, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        String key;
        HighlightDisplayKey highlightDisplayKey;
        HighlightInfoType highlightInfoType;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processMethod"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processMethod"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processMethod"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processMethod"));
        }
        if (PostHighlightingPass.isMethodReferenced(this.myProject, this.myFile, method, progress, helper)) {
            return null;
        }
        if (method.hasModifierProperty("private")) {
            highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
            highlightDisplayKey = this.myUnusedSymbolKey;
            key = method.isConstructor() ? "private.constructor.is.not.used" : "private.method.is.not.used";
        } else {
            highlightInfoType = this.myDeadCodeInfoType;
            highlightDisplayKey = this.myDeadCodeKey;
            key = method.isConstructor() ? "constructor.is.not.used" : "method.is.not.used";
        }
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)method, PsiSubstitutor.EMPTY);
        String message = JavaErrorMessages.message(key, symbolName);
        final HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, highlightInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)method), highlightDisplayKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)method, new Processor<String>(){

            public boolean process(String annoName) {
                IntentionAction fix = QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, annoName, "methods");
                QuickFixAction.registerQuickFixAction(highlightInfo, fix);
                return true;
            }
        });
        return highlightInfo;
    }

    public static boolean isMethodReferenced(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMethod method, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isMethodReferenced"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isMethodReferenced"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isMethodReferenced"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isMethodReferenced"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isMethodReferenced"));
        }
        if (helper.isLocallyUsed((PsiNamedElement)method)) {
            return true;
        }
        boolean aPrivate = method.hasModifierProperty("private");
        PsiClass containingClass = method.getContainingClass();
        if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
            return true;
        }
        if (aPrivate) {
            if (PostHighlightingPass.isIntentionalPrivateConstructor(method, containingClass)) {
                return true;
            }
            if (PostHighlightingPass.isImplicitUsage(project, (PsiModifierListOwner)method, progress)) {
                return true;
            }
            if (!helper.isCurrentFileAlreadyChecked()) {
                return !PostHighlightingPass.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, progress, helper);
            }
        } else {
            if (containingClass != null && method.isConstructor() && containingClass.getConstructors().length == 1 && PostHighlightingPass.isClassUsed(project, containingFile, containingClass, progress, helper)) {
                return true;
            }
            if (PostHighlightingPass.isImplicitUsage(project, (PsiModifierListOwner)method, progress)) {
                return true;
            }
            if (method.findSuperMethods().length != 0) {
                return true;
            }
            if (!PostHighlightingPass.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)method, progress, helper)) {
                return true;
            }
        }
        return false;
    }

    private static boolean weAreSureThereAreNoUsages(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        FindUsagesOptions options;
        PsiFile ignoreFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "weAreSureThereAreNoUsages"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "weAreSureThereAreNoUsages"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "weAreSureThereAreNoUsages"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "weAreSureThereAreNoUsages"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "weAreSureThereAreNoUsages"));
        }
        if (!helper.shouldCheckUsages(member)) {
            return false;
        }
        String name = member.getName();
        if (name == null) {
            return false;
        }
        SearchScope useScope = member.getUseScope();
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)project);
        Object object = ignoreFile = helper.isCurrentFileAlreadyChecked() ? containingFile : null;
        if (useScope instanceof GlobalSearchScope) {
            SearchScope fileScope;
            String propertyName;
            PsiSearchHelper.SearchCostResult cheapEnough;
            if (member instanceof PsiClass) {
                useScope = GlobalSearchScope.projectScope((Project)project).uniteWith((GlobalSearchScope)useScope);
            }
            PsiSearchHelper.SearchCostResult searchCostResult = cheapEnough = RefResolveService.ENABLED && RefResolveService.getInstance((Project)project).isUpToDate() ? PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES : searchHelper.isCheapEnoughToSearch(name, (GlobalSearchScope)useScope, ignoreFile, progress);
            if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return false;
            }
            if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && !PostHighlightingPass.canBeReferencedViaWeirdNames(member, containingFile)) {
                return true;
            }
            if (member instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)member)) != null && (fileScope = containingFile.getUseScope()) instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(propertyName, (GlobalSearchScope)fileScope, ignoreFile, progress) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return false;
            }
        }
        if (member instanceof PsiPackage) {
            options = new JavaPackageFindUsagesOptions(project);
        } else if (member instanceof PsiClass) {
            options = new JavaClassFindUsagesOptions(project);
        } else if (member instanceof PsiMethod) {
            JavaMethodFindUsagesOptions o = new JavaMethodFindUsagesOptions(project);
            options = o;
        } else {
            options = member instanceof PsiVariable ? new JavaVariableFindUsagesOptions(project) : new FindUsagesOptions(project);
        }
        options.isSearchForTextOccurrences = true;
        options.isUsages = true;
        boolean foundUsage = !JavaFindUsagesHelper.processElementUsages((PsiElement)member, options, new Processor<UsageInfo>(){

            public boolean process(UsageInfo info) {
                PsiFile psiFile = info.getFile();
                if (psiFile == ignoreFile || psiFile == null) {
                    return true;
                }
                int offset = info.getNavigationOffset();
                if (offset == -1) {
                    return true;
                }
                PsiElement element = psiFile.findElementAt(offset);
                return element instanceof PsiComment;
            }
        });
        return !foundUsage;
    }

    private static boolean isEnumValuesMethodUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isEnumValuesMethodUsed"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isEnumValuesMethodUsed"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isEnumValuesMethodUsed"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isEnumValuesMethodUsed"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isEnumValuesMethodUsed"));
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null || !(containingClass instanceof PsiClassImpl)) {
            return true;
        }
        PsiMethod valuesMethod = ((PsiClassImpl)containingClass).getValuesMethod();
        return valuesMethod == null || PostHighlightingPass.isMethodReferenced(project, containingFile, valuesMethod, progress, helper);
    }

    private static boolean canBeReferencedViaWeirdNames(@NotNull PsiMember member, @NotNull PsiFile containingFile) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "canBeReferencedViaWeirdNames"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "canBeReferencedViaWeirdNames"));
        }
        if (member instanceof PsiClass) {
            return false;
        }
        if (!(containingFile instanceof PsiJavaFile)) {
            return true;
        }
        if (member instanceof PsiField) {
            return false;
        }
        if (member instanceof PsiMethod) {
            return PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)member));
        }
        return false;
    }

    @Nullable
    private HighlightInfo processClass(@NotNull Project project, @NotNull PsiClass aClass, @NotNull PsiIdentifier identifier, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        HighlightInfoType highlightInfoType;
        HighlightDisplayKey highlightDisplayKey;
        String pattern;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processClass"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processClass"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processClass"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processClass"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processClass"));
        }
        if (PostHighlightingPass.isClassUsed(project, this.myFile, aClass, progress, helper)) {
            return null;
        }
        if (aClass.getContainingClass() != null && aClass.hasModifierProperty("private")) {
            pattern = aClass.isInterface() ? "private.inner.interface.is.not.used" : "private.inner.class.is.not.used";
            highlightDisplayKey = this.myUnusedSymbolKey;
            highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
        } else if (aClass.getParent() instanceof PsiDeclarationStatement) {
            pattern = "local.class.is.not.used";
            highlightDisplayKey = this.myUnusedSymbolKey;
            highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
        } else if (aClass instanceof PsiTypeParameter) {
            pattern = "type.parameter.is.not.used";
            highlightDisplayKey = this.myUnusedSymbolKey;
            highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
        } else {
            pattern = "class.is.not.used";
            highlightDisplayKey = this.myDeadCodeKey;
            highlightInfoType = this.myDeadCodeInfoType;
        }
        return PostHighlightingPass.formatUnusedSymbolHighlightInfo(this.myProject, pattern, (PsiNameIdentifierOwner)aClass, "classes", highlightDisplayKey, highlightInfoType, (PsiElement)identifier);
    }

    public static boolean isClassUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isClassUsed"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isClassUsed"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isClassUsed"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isClassUsed"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isClassUsed"));
        }
        Boolean result = helper.unusedClassCache.get(aClass);
        if (result == null) {
            result = PostHighlightingPass.isReallyUsed(project, containingFile, aClass, progress, helper);
            helper.unusedClassCache.put(aClass, result);
        }
        return result;
    }

    private static boolean isReallyUsed(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiClass aClass, @NotNull ProgressIndicator progress, @NotNull GlobalUsageHelper helper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isReallyUsed"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isReallyUsed"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isReallyUsed"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isReallyUsed"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isReallyUsed"));
        }
        if (PostHighlightingPass.isImplicitUsage(project, (PsiModifierListOwner)aClass, progress) || helper.isLocallyUsed((PsiNamedElement)aClass)) {
            return true;
        }
        if (helper.isCurrentFileAlreadyChecked() && (aClass.getContainingClass() != null && aClass.hasModifierProperty("private") || aClass.getParent() instanceof PsiDeclarationStatement || aClass instanceof PsiTypeParameter)) {
            return false;
        }
        return !PostHighlightingPass.weAreSureThereAreNoUsages(project, containingFile, (PsiMember)aClass, progress, helper);
    }

    private static HighlightInfo formatUnusedSymbolHighlightInfo(final @NotNull Project project, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorMessages") String pattern, @NotNull PsiNameIdentifierOwner aClass, final @NotNull String element, HighlightDisplayKey highlightDisplayKey, @NotNull HighlightInfoType highlightInfoType, @NotNull PsiElement identifier) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "formatUnusedSymbolHighlightInfo"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "formatUnusedSymbolHighlightInfo"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "formatUnusedSymbolHighlightInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "formatUnusedSymbolHighlightInfo"));
        }
        if (highlightInfoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoType", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "formatUnusedSymbolHighlightInfo"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "formatUnusedSymbolHighlightInfo"));
        }
        String symbolName = aClass.getName();
        String message = JavaErrorMessages.message(pattern, symbolName);
        final HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo(identifier, message, highlightInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)aClass), highlightDisplayKey);
        SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes((PsiModifierListOwner)aClass, new Processor<String>(){

            public boolean process(String annoName) {
                QuickFixAction.registerQuickFixAction(highlightInfo, QuickFixFactory.getInstance().createAddToDependencyInjectionAnnotationsFix(project, annoName, element));
                return true;
            }
        });
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processImport"));
        }
        if (unusedImportKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unusedImportKey", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "processImport"));
        }
        if (importStatement.isForeignFileImport()) {
            return null;
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)importStatement)) {
            return null;
        }
        boolean isRedundant = this.myRefCountHolder.isRedundant(importStatement);
        if (!isRedundant && !(importStatement instanceof PsiImportStaticStatement)) {
            String qName;
            PsiElement resolved;
            String packageName = ((PsiClassOwner)importStatement.getContainingFile()).getPackageName();
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            PsiElement psiElement = resolved = reference == null ? null : reference.resolve();
            if (resolved instanceof PsiPackage) {
                isRedundant = packageName.equals(((PsiQualifiedNamedElement)resolved).getQualifiedName());
            } else if (resolved instanceof PsiClass && !importStatement.isOnDemand() && (qName = ((PsiClass)resolved).getQualifiedName()) != null) {
                String name = ((PomNamedTarget)resolved).getName();
                isRedundant = qName.equals(packageName + '.' + name);
            }
        }
        if (isRedundant) {
            return this.registerRedundantImport(importStatement, unusedImportKey);
        }
        int entryIndex = JavaCodeStyleManager.getInstance((Project)this.myProject).findEntryIndex(importStatement);
        if (entryIndex < this.myCurrentEntryIndex) {
            this.myHasMissortedImports = true;
        }
        this.myCurrentEntryIndex = entryIndex;
        return null;
    }

    private HighlightInfo registerRedundantImport(@NotNull PsiImportStatementBase importStatement, @NotNull HighlightDisplayKey unusedImportKey) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "registerRedundantImport"));
        }
        if (unusedImportKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unusedImportKey", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "registerRedundantImport"));
        }
        String description = InspectionsBundle.message((String)"unused.import.statement", (Object[])new Object[0]);
        HighlightInfo info = HighlightInfo.newHighlightInfo(JavaHighlightInfoTypes.UNUSED_IMPORT).range((PsiElement)importStatement).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createOptimizeImportsFix(false), unusedImportKey);
        QuickFixAction.registerQuickFixAction(info, QuickFixFactory.getInstance().createEnableOptimizeImportsOnTheFlyFix(), unusedImportKey);
        this.myHasRedundantImports = true;
        return info;
    }

    private static boolean isIntentionalPrivateConstructor(@NotNull PsiMethod method, PsiClass containingClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/PostHighlightingPass", "isIntentionalPrivateConstructor"));
        }
        return method.isConstructor() && method.getParameterList().getParametersCount() == 0 && containingClass != null && containingClass.getConstructors().length == 1;
    }
}

