/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class EnterBetweenXmlTagsHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/EnterBetweenXmlTagsHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/EnterBetweenXmlTagsHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/codeInsight/editorActions/EnterBetweenXmlTagsHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/EnterBetweenXmlTagsHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/EnterBetweenXmlTagsHandler", "preprocessEnter"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (file instanceof XmlFile && EnterBetweenXmlTagsHandler.isBetweenXmlTags(project, editor, file, (Integer)caretOffset.get())) {
            originalHandler.execute(editor, dataContext);
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean isBetweenXmlTags(Project project, Editor editor, PsiFile file, int offset) {
        if (offset == 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (chars.charAt(offset - 1) != '>') {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset - 1);
        if (iterator.getTokenType() != XmlTokenType.XML_TAG_END) {
            return false;
        }
        if (EnterBetweenXmlTagsHandler.isAtTheEndOfEmptyTag(project, editor, file, iterator)) {
            return false;
        }
        iterator.retreat();
        int retrieveCount = 1;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == XmlTokenType.XML_END_TAG_START) {
                return false;
            }
            if (tokenType == XmlTokenType.XML_START_TAG_START) break;
            ++retrieveCount;
            iterator.retreat();
        }
        for (int i = 0; i < retrieveCount; ++i) {
            iterator.advance();
        }
        iterator.advance();
        return !iterator.atEnd() && iterator.getTokenType() == XmlTokenType.XML_END_TAG_START;
    }

    private static boolean isAtTheEndOfEmptyTag(Project project, Editor editor, PsiFile file, HighlighterIterator iterator) {
        if (iterator.getTokenType() != XmlTokenType.XML_TAG_END) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement element = file.findElementAt(iterator.getStart());
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof XmlTag && parent.getTextRange().getEndOffset() == iterator.getEnd();
    }
}

