/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.ParameterNameFoldingManager;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaFoldingBuilderBase
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.JavaFoldingBuilder");
    private static final String SMILEY = "<~>";

    private static String getPlaceholderText(PsiElement element) {
        if (element instanceof PsiImportList) {
            return "...";
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiClass) {
            return "{...}";
        }
        if (element instanceof PsiDocComment) {
            return "/**...*/";
        }
        if (element instanceof PsiFile) {
            return "/.../";
        }
        if (element instanceof PsiAnnotation) {
            return "@{...}";
        }
        if (element instanceof PsiReferenceParameterList) {
            return SMILEY;
        }
        if (element instanceof PsiComment) {
            return "//...";
        }
        return "...";
    }

    private static boolean areOnAdjacentLines(PsiElement e1, PsiElement e2, Document document) {
        return document.getLineNumber(e1.getTextRange().getEndOffset()) + 1 == document.getLineNumber(e2.getTextRange().getStartOffset());
    }

    private static boolean isSimplePropertyAccessor(PsiMethod method) {
        PsiExpression expr;
        PsiCodeBlock body = method.getBody();
        if (body == null || body.getLBrace() == null || body.getRBrace() == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) {
            if (statement instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement).getReturnValue() instanceof PsiReferenceExpression;
            }
            return false;
        }
        if (statements.length > 1 && !(statements[1] instanceof PsiReturnStatement)) {
            return false;
        }
        if (statement instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            return lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression && !((PsiReferenceExpression)rhs).isQualified() && PropertyUtil.isSimplePropertySetter((PsiMethod)method);
        }
        return false;
    }

    @Nullable
    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof SyntheticElement) {
            return null;
        }
        if (element instanceof PsiMethod) {
            PsiCodeBlock body = ((PsiMethod)element).getBody();
            if (body == null) {
                return null;
            }
            return body.getTextRange();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody().getTextRange();
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiElement lBrace = aClass.getLBrace();
            if (lBrace == null) {
                return null;
            }
            PsiElement rBrace = aClass.getRBrace();
            if (rBrace == null) {
                return null;
            }
            return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
        }
        if (element instanceof PsiJavaFile) {
            return JavaFoldingBuilderBase.getFileHeader((PsiJavaFile)element);
        }
        if (element instanceof PsiImportList) {
            PsiImportList list = (PsiImportList)element;
            PsiImportStatementBase[] statements = list.getAllImportStatements();
            if (statements.length == 0) {
                return null;
            }
            PsiElement importKeyword = statements[0].getFirstChild();
            if (importKeyword == null) {
                return null;
            }
            int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
            int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            if (!JavaFoldingBuilderBase.hasErrorElementsNearby(element.getContainingFile(), startOffset, endOffset)) {
                return new TextRange(startOffset, endOffset);
            }
        }
        if (element instanceof PsiDocComment) {
            return element.getTextRange();
        }
        if (element instanceof PsiAnnotation) {
            int startOffset = element.getTextRange().getStartOffset();
            PsiElement last = element;
            while (element instanceof PsiAnnotation) {
                last = element;
                element = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            }
            return new TextRange(startOffset, last.getTextRange().getEndOffset());
        }
        return null;
    }

    public static boolean hasErrorElementsNearby(PsiFile file, int startOffset, int endOffset) {
        endOffset = CharArrayUtil.shiftForward((CharSequence)file.getViewProvider().getContents(), (int)endOffset, (String)" \t\n");
        for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file, startOffset, endOffset)) {
            if (!(element instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static TextRange getFileHeader(PsiJavaFile file) {
        PsiElement first = file.getFirstChild();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element = first;
        while (element instanceof PsiComment && (element = element.getNextSibling()) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return null;
        }
        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element == null || element.equals(first)) {
            return null;
        }
        return new UnfairTextRange(first.getTextOffset(), element.getTextOffset());
    }

    private void addAnnotationsToFold(PsiModifierList modifierList, List<FoldingDescriptor> foldElements, Document document) {
        if (modifierList == null) {
            return;
        }
        PsiElement[] children = modifierList.getChildren();
        for (int i = 0; i < children.length; ++i) {
            PsiElement nextChild;
            int j;
            PsiElement child = children[i];
            if (!(child instanceof PsiAnnotation)) continue;
            this.addToFold(foldElements, child, document, false);
            for (j = i + 1; j < children.length && !((nextChild = children[j]) instanceof PsiModifier); ++j) {
            }
            i = j;
        }
    }

    private static void addCommentFolds(@NotNull PsiComment comment, @NotNull Set<PsiElement> processedComments, @NotNull List<FoldingDescriptor> foldElements) {
        ASTNode node;
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCommentFolds"));
        }
        if (processedComments.contains(comment) || comment.getTokenType() != JavaTokenType.END_OF_LINE_COMMENT) {
            return;
        }
        PsiElement end = null;
        boolean containsCustomRegionMarker = JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)comment);
        for (PsiElement current = comment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaTokenType.END_OF_LINE_COMMENT) {
                end = current;
                processedComments.add(current);
                containsCustomRegionMarker |= JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end != null && !containsCustomRegionMarker) {
            foldElements.add(new FoldingDescriptor((PsiElement)comment, new TextRange(comment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset())));
        }
    }

    private static void addMethodGenericParametersFolding(PsiMethodCallExpression expression, List<FoldingDescriptor> foldElements, Document document, boolean quick) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiReferenceParameterList list = methodExpression.getParameterList();
        if (list == null || list.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element = expression;
        while (true) {
            if (!quick && !JavaFoldingBuilderBase.resolvesCorrectly(element.getMethodExpression())) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) break;
            element = (PsiMethodCallExpression)parent.getParent();
        }
        JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 3, quick);
    }

    private static boolean resolvesCorrectly(PsiReferenceExpression expression) {
        for (JavaResolveResult result : expression.multiResolve(true)) {
            if (result.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(PsiNewExpression expression, List<FoldingDescriptor> foldElements, Document document, boolean quick) {
        PsiReferenceParameterList list;
        PsiAnonymousClass anonymousClass;
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters = ((PsiClassType)declType).getParameters();
        if (parameters.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression.getClassReference();
        if (classReference == null && (anonymousClass = expression.getAnonymousClass()) != null) {
            classReference = anonymousClass.getBaseClassReference();
            if (quick || JavaFoldingBuilderBase.seemsLikeLambda(anonymousClass.getSuperClass())) {
                return;
            }
        }
        if (classReference != null && (list = classReference.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !list.getText().equals(declList.getText()) : !Arrays.equals(list.getTypeArguments(), parameters)) {
                return;
            }
            JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 5, quick);
        }
    }

    private static void addTypeParametersFolding(List<FoldingDescriptor> foldElements, Document document, PsiReferenceParameterList list, int ifLongerThan, boolean quick) {
        String text;
        if (!quick) {
            for (PsiType type : list.getTypeArguments()) {
                if (!type.isValid()) {
                    return;
                }
                if (!(type instanceof PsiClassType) && !(type instanceof PsiArrayType) || PsiUtil.resolveClassInType((PsiType)type) != null) continue;
                return;
            }
        }
        if ((text = list.getText()).startsWith("<") && text.endsWith(">") && text.length() > ifLongerThan) {
            TextRange range = list.getTextRange();
            JavaFoldingBuilderBase.addFoldRegion(foldElements, (PsiElement)list, document, true, range);
        }
    }

    private static boolean hasOnlyOneLambdaMethod(@NotNull PsiAnonymousClass anonymousClass, boolean checkResolve) {
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "hasOnlyOneLambdaMethod"));
        }
        PsiField[] fields = anonymousClass.getFields();
        if (!(fields.length == 0 || fields.length == 1 && "serialVersionUID".equals(fields[0].getName()) && fields[0].hasModifierProperty("static"))) {
            return false;
        }
        if (anonymousClass.getInitializers().length != 0) {
            return false;
        }
        if (anonymousClass.getInnerClasses().length != 0) {
            return false;
        }
        if (anonymousClass.getMethods().length != 1) {
            return false;
        }
        PsiMethod method = anonymousClass.getMethods()[0];
        if (method.hasModifierProperty("synchronized")) {
            return false;
        }
        if (checkResolve) {
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiClassType type : throwsList.getReferencedTypes()) {
                if (type.resolve() != null) continue;
                return false;
            }
        }
        return true;
    }

    private String getOptionalLambdaType(PsiAnonymousClass anonymousClass, PsiNewExpression expression) {
        String baseClassName;
        if (this.shouldShowExplicitLambdaType(anonymousClass, expression) && (baseClassName = ((PsiClass)ObjectUtils.assertNotNull((Object)anonymousClass.getBaseClassType().resolve())).getName()) != null) {
            return "(" + baseClassName + ") ";
        }
        return "";
    }

    protected abstract boolean shouldShowExplicitLambdaType(PsiAnonymousClass var1, PsiNewExpression var2);

    private static boolean seemsLikeLambda(@Nullable PsiClass baseClass) {
        return baseClass != null && PsiUtil.hasDefaultConstructor((PsiClass)baseClass, (boolean)true);
    }

    private static boolean isImplementingLambdaMethod(PsiClass baseClass) {
        if (!baseClass.hasModifierProperty("abstract")) {
            return false;
        }
        for (PsiMethod method : baseClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return true;
        }
        try {
            return !OverrideImplementExploreUtil.getMethodSignaturesToImplement(baseClass).isEmpty();
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    private boolean addToFold(List<FoldingDescriptor> list, PsiElement elementToFold, Document document, boolean allowOneLiners) {
        PsiUtilCore.ensureValid((PsiElement)elementToFold);
        TextRange range = this.getRangeToFold(elementToFold);
        if (range == null) {
            return false;
        }
        return JavaFoldingBuilderBase.addFoldRegion(list, elementToFold, document, allowOneLiners, range);
    }

    private static boolean addFoldRegion(List<FoldingDescriptor> list, PsiElement elementToFold, Document document, boolean allowOneLiners, TextRange range) {
        TextRange fileRange = elementToFold.getContainingFile().getTextRange();
        if (range.equals((Object)fileRange)) {
            return false;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (range.getStartOffset() < 0 || range.getEndOffset() > fileRange.getEndOffset()) {
            return false;
        }
        if (!allowOneLiners) {
            int endLine;
            int startLine = document.getLineNumber(range.getStartOffset());
            if (startLine < (endLine = document.getLineNumber(range.getEndOffset() - 1)) && range.getLength() > 1) {
                list.add(new FoldingDescriptor(elementToFold, range));
                return true;
            }
            return false;
        }
        if (range.getLength() > JavaFoldingBuilderBase.getPlaceholderText(elementToFold).length()) {
            list.add(new FoldingDescriptor(elementToFold, range));
            return true;
        }
        return false;
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        PsiClass[] classes;
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "buildLanguageFoldRegions"));
        }
        if (!(root instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file = (PsiJavaFile)root;
        PsiImportList importList = file.getImportList();
        if (importList != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = this.getRangeToFold((PsiElement)importList)) != null && rangeToFold.getLength() > 1) {
            descriptors.add(new FoldingDescriptor((PsiElement)importList, rangeToFold));
        }
        for (PsiClass aClass : classes = file.getClasses()) {
            ProgressIndicatorProvider.checkCanceled();
            this.addElementsToFold(descriptors, aClass, document, true, quick);
        }
        TextRange range = JavaFoldingBuilderBase.getFileHeader(file);
        if (range != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            ASTNode node;
            PsiJavaFile anchorElementToUse = file;
            PsiElement candidate = file.getFirstChild();
            if (candidate != null && candidate.getTextRange().equals((Object)range) && (node = candidate.getNode()) != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
                anchorElementToUse = candidate;
            }
            descriptors.add(new FoldingDescriptor((PsiElement)anchorElementToUse, range));
        }
    }

    private void addElementsToFold(List<FoldingDescriptor> list, PsiClass aClass, Document document, boolean foldJavaDocs, boolean quick) {
        PsiDocComment docComment;
        if (!(aClass.getParent() instanceof PsiJavaFile) || ((PsiJavaFile)aClass.getParent()).getClasses().length > 1) {
            this.addToFold(list, (PsiElement)aClass, document, true);
        }
        if (foldJavaDocs && (docComment = aClass.getDocComment()) != null) {
            this.addToFold(list, (PsiElement)docComment, document, true);
        }
        this.addAnnotationsToFold(aClass.getModifierList(), list, document);
        PsiElement[] children = aClass.getChildren();
        HashSet<PsiElement> processedComments = new HashSet<PsiElement>();
        for (PsiElement child : children) {
            ProgressIndicatorProvider.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiCodeBlock body;
                PsiMethod method = (PsiMethod)child;
                boolean oneLiner = this.addOneLineMethodFolding(list, method);
                if (!oneLiner) {
                    this.addToFold(list, (PsiElement)method, document, true);
                }
                this.addAnnotationsToFold(method.getModifierList(), list, document);
                if (foldJavaDocs && (docComment = method.getDocComment()) != null) {
                    this.addToFold(list, (PsiElement)docComment, document, true);
                }
                if ((body = method.getBody()) == null || oneLiner) continue;
                this.addCodeBlockFolds((PsiElement)body, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                if (foldJavaDocs && (docComment = field.getDocComment()) != null) {
                    this.addToFold(list, (PsiElement)docComment, document, true);
                }
                this.addAnnotationsToFold(field.getModifierList(), list, document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds((PsiElement)initializer, list, processedComments, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds((PsiElement)field, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)child;
                this.addToFold(list, (PsiElement)initializer, document, true);
                this.addCodeBlockFolds((PsiElement)initializer, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClass) {
                this.addElementsToFold(list, (PsiClass)child, document, true, quick);
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            JavaFoldingBuilderBase.addCommentFolds((PsiComment)child, processedComments, list);
        }
    }

    private boolean addOneLineMethodFolding(List<FoldingDescriptor> descriptorList, PsiMethod method) {
        if (!JavaCodeFoldingSettings.getInstance().isCollapseOneLineMethods()) {
            return false;
        }
        Document document = method.getContainingFile().getViewProvider().getDocument();
        PsiCodeBlock body = method.getBody();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (body == null || document == null || nameIdentifier == null) {
            return false;
        }
        if (document.getLineNumber(nameIdentifier.getTextRange().getStartOffset()) != document.getLineNumber(method.getParameterList().getTextRange().getEndOffset())) {
            return false;
        }
        PsiJavaToken lBrace = body.getLBrace();
        PsiJavaToken rBrace = body.getRBrace();
        PsiStatement[] statements = body.getStatements();
        if (lBrace == null || rBrace == null || statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (statement.textContains('\n')) {
            return false;
        }
        if (!JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)lBrace, (PsiElement)statement, document) || !JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)statement, (PsiElement)rBrace, document)) {
            return false;
        }
        int leftStart = method.getParameterList().getTextRange().getEndOffset();
        int bodyStart = body.getTextRange().getStartOffset();
        if (bodyStart > leftStart && !StringUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence().subSequence(leftStart + 1, bodyStart))) {
            return false;
        }
        int leftEnd = statement.getTextRange().getStartOffset();
        int rightStart = statement.getTextRange().getEndOffset();
        int rightEnd = body.getTextRange().getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        String leftText = " { ";
        String rightText = " }";
        if (!this.fitsRightMargin((PsiElement)method, document, leftStart, rightEnd, rightStart - leftEnd + leftText.length() + rightText.length())) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        descriptorList.add(new NamedFoldingDescriptor((PsiElement)lBrace, leftStart, leftEnd, group, leftText));
        descriptorList.add(new NamedFoldingDescriptor((PsiElement)rBrace, rightStart, rightEnd, group, rightText));
        return true;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "getLanguagePlaceholderText"));
        }
        return JavaFoldingBuilderBase.getPlaceholderText(SourceTreeToPsiMap.treeElementToPsi(node));
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "isRegionCollapsedByDefault"));
        }
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(node);
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (element instanceof PsiNewExpression || element instanceof PsiJavaToken && element.getParent() instanceof PsiAnonymousClass) {
            return settings.isCollapseLambdas();
        }
        if (element instanceof PsiJavaToken && element.getParent() instanceof PsiCodeBlock && element.getParent().getParent() instanceof PsiMethod) {
            return settings.isCollapseOneLineMethods();
        }
        if (element instanceof PsiReferenceParameterList) {
            return settings.isCollapseConstructorGenericParameters();
        }
        if (element instanceof PsiImportList) {
            return settings.isCollapseImports();
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiCodeBlock) {
            if (element instanceof PsiMethod && JavaFoldingBuilderBase.isSimplePropertyAccessor((PsiMethod)element)) {
                return settings.isCollapseAccessors();
            }
            return settings.isCollapseMethods();
        }
        if (element instanceof PsiAnonymousClass) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiClass) {
            return !(element.getParent() instanceof PsiFile) && settings.isCollapseInnerClasses();
        }
        if (element instanceof PsiDocComment) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiJavaFile) {
                if (((PsiJavaFile)parent).getName().equals("package-info.java")) {
                    return false;
                }
                PsiElement firstChild = parent.getFirstChild();
                if (firstChild instanceof PsiWhiteSpace) {
                    firstChild = firstChild.getNextSibling();
                }
                if (element.equals(firstChild)) {
                    return settings.isCollapseFileHeader();
                }
            }
            return settings.isCollapseJavadocs();
        }
        if (element instanceof PsiJavaFile) {
            return settings.isCollapseFileHeader();
        }
        if (element instanceof PsiAnnotation) {
            return settings.isCollapseAnnotations();
        }
        if (element instanceof PsiComment) {
            return settings.isCollapseEndOfLineComments();
        }
        if (ParameterNameFoldingManager.isLiteralExpression(element) && element.getParent() instanceof PsiExpressionList && (element.getParent().getParent() instanceof PsiCallExpression || element.getParent().getParent() instanceof PsiAnonymousClass)) {
            return settings.isInlineParameterNamesForLiteralCallArguments();
        }
        LOG.error("Unknown element:" + element);
        return false;
    }

    private void addCodeBlockFolds(PsiElement scope, final List<FoldingDescriptor> foldElements, final @NotNull Set<PsiElement> processedComments, final Document document, final boolean quick) {
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addCodeBlockFolds"));
        }
        final boolean dumb = DumbService.isDumb((Project)scope.getProject());
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (dumb || !JavaFoldingBuilderBase.this.addClosureFolding(aClass, document, foldElements, processedComments, quick)) {
                    JavaFoldingBuilderBase.this.addToFold(foldElements, (PsiElement)aClass, document, true);
                    JavaFoldingBuilderBase.this.addElementsToFold(foldElements, aClass, document, false, quick);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addMethodGenericParametersFolding(expression, foldElements, document, quick);
                    JavaFoldingBuilderBase.inlineLiteralArgumentsNames((PsiCallExpression)expression, foldElements, quick);
                }
                super.visitMethodCallExpression(expression);
            }

            public void visitNewExpression(PsiNewExpression expression) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addGenericParametersFolding(expression, foldElements, document, quick);
                    JavaFoldingBuilderBase.inlineLiteralArgumentsNames((PsiCallExpression)expression, foldElements, quick);
                }
                super.visitNewExpression(expression);
            }

            public void visitComment(PsiComment comment) {
                JavaFoldingBuilderBase.addCommentFolds(comment, processedComments, foldElements);
                super.visitComment(comment);
            }
        });
    }

    private static void inlineLiteralArgumentsNames(@NotNull PsiCallExpression expression, @NotNull List<FoldingDescriptor> foldElements, boolean quick) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "inlineLiteralArgumentsNames"));
        }
        if (foldElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldElements", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "inlineLiteralArgumentsNames"));
        }
        if (quick || !JavaCodeFoldingSettings.getInstance().isInlineParameterNamesForLiteralCallArguments()) {
            return;
        }
        ParameterNameFoldingManager manager = new ParameterNameFoldingManager(expression);
        foldElements.addAll(manager.buildDescriptors());
    }

    private boolean addClosureFolding(PsiClass aClass, Document document, List<FoldingDescriptor> foldElements, @NotNull Set<PsiElement> processedComments, boolean quick) {
        PsiNewExpression expression;
        PsiExpressionList argumentList;
        PsiAnonymousClass anonymousClass;
        PsiElement element;
        if (processedComments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedComments", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "addClosureFolding"));
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        boolean isClosure = false;
        if (aClass instanceof PsiAnonymousClass && (element = (anonymousClass = (PsiAnonymousClass)aClass).getParent()) instanceof PsiNewExpression && (argumentList = (expression = (PsiNewExpression)element).getArgumentList()) != null && argumentList.getExpressions().length == 0) {
            PsiMethod method;
            PsiCodeBlock body;
            PsiMethod[] methods = anonymousClass.getMethods();
            PsiClass baseClass = anonymousClass.getBaseClassType().resolve();
            if (JavaFoldingBuilderBase.hasOnlyOneLambdaMethod(anonymousClass, !quick) && JavaFoldingBuilderBase.seemsLikeLambda(baseClass) && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)anonymousClass) && (body = (method = methods[0]).getBody()) != null) {
                int lastLineEnd;
                int firstLineStart;
                int methodEndLine;
                int methodEndLineStart;
                PsiJavaToken rbrace;
                isClosure = true;
                int rangeStart = body.getTextRange().getStartOffset();
                int rangeEnd = body.getTextRange().getEndOffset();
                PsiJavaToken lbrace = body.getLBrace();
                if (lbrace != null) {
                    rangeStart = lbrace.getTextRange().getEndOffset();
                }
                if ((rbrace = body.getRBrace()) != null) {
                    rangeEnd = rbrace.getTextRange().getStartOffset();
                }
                CharSequence seq = document.getCharsSequence();
                PsiElement classRBrace = anonymousClass.getRBrace();
                if (classRBrace != null && rbrace != null && "}".equals(((Object)seq.subSequence(methodEndLineStart = document.getLineStartOffset(methodEndLine = document.getLineNumber(rangeEnd)), document.getLineEndOffset(methodEndLine))).toString().trim())) {
                    int classEndStart = classRBrace.getTextRange().getStartOffset();
                    int classEndCol = classEndStart - document.getLineStartOffset(document.getLineNumber(classEndStart));
                    rangeEnd = classEndCol + methodEndLineStart;
                }
                if ((firstLineStart = CharArrayUtil.shiftForward((CharSequence)seq, (int)rangeStart, (String)" \t")) < seq.length() - 1 && seq.charAt(firstLineStart) == '\n') {
                    ++firstLineStart;
                }
                if ((lastLineEnd = CharArrayUtil.shiftBackward((CharSequence)seq, (int)(rangeEnd - 1), (String)" \t")) > 0 && seq.charAt(lastLineEnd) == '\n') {
                    --lastLineEnd;
                }
                if (lastLineEnd < firstLineStart) {
                    return false;
                }
                String type = quick ? "" : this.getOptionalLambdaType(anonymousClass, expression);
                String methodName = quick || !JavaFoldingBuilderBase.isImplementingLambdaMethod(baseClass) ? method.getName() : "";
                String params = StringUtil.join((Object[])method.getParameterList().getParameters(), (Function)new Function<PsiParameter, String>(){

                    public String fun(PsiParameter psiParameter) {
                        return psiParameter.getName();
                    }
                }, (String)", ");
                String arrow = this.rightArrow();
                String lambdas = type + methodName + "(" + params + ") " + arrow + " {";
                int closureStart = expression.getTextRange().getStartOffset();
                int closureEnd = expression.getTextRange().getEndOffset();
                boolean oneLine = false;
                String contents = ((Object)seq.subSequence(firstLineStart, lastLineEnd)).toString();
                if (contents.indexOf(10) < 0 && this.fitsRightMargin((PsiElement)aClass, document, closureStart, closureEnd, lambdas.length() + contents.length() + 5)) {
                    rangeStart = CharArrayUtil.shiftForward((CharSequence)seq, (int)rangeStart, (String)" \n\t");
                    rangeEnd = CharArrayUtil.shiftBackward((CharSequence)seq, (int)(rangeEnd - 1), (String)" \n\t") + 1;
                    oneLine = true;
                }
                if (rangeStart >= rangeEnd) {
                    return false;
                }
                FoldingGroup group = FoldingGroup.newGroup((String)"lambda");
                String prettySpace = oneLine ? " " : "";
                foldElements.add(new NamedFoldingDescriptor((PsiElement)expression, closureStart, rangeStart, group, lambdas + prettySpace));
                if (classRBrace != null && rangeEnd + 1 < closureEnd) {
                    foldElements.add(new NamedFoldingDescriptor(classRBrace, rangeEnd, closureEnd, group, prettySpace + "}"));
                }
                this.addCodeBlockFolds((PsiElement)body, foldElements, processedComments, document, quick);
            }
        }
        return isClosure;
    }

    @NotNull
    protected String rightArrow() {
        if ("->" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase", "rightArrow"));
        }
        return "->";
    }

    private boolean fitsRightMargin(PsiElement element, Document document, int foldingStart, int foldingEnd, int collapsedLength) {
        int beforeLength = foldingStart - document.getLineStartOffset(document.getLineNumber(foldingStart));
        int afterLength = document.getLineEndOffset(document.getLineNumber(foldingEnd)) - foldingEnd;
        return this.isBelowRightMargin(element.getProject(), beforeLength + collapsedLength + afterLength);
    }

    protected abstract boolean isBelowRightMargin(Project var1, int var2);

    protected boolean isCustomFoldingCandidate(ASTNode node) {
        return node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(ASTNode node) {
        IElementType nodeType = node.getElementType();
        if (nodeType == JavaElementType.CLASS) {
            ASTNode parent = node.getTreeParent();
            return parent == null || parent.getElementType() != JavaElementType.CLASS;
        }
        return nodeType == JavaElementType.CODE_BLOCK;
    }
}

