/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.PlatformIcons;

public class ExpressionLookupItem
extends LookupItem<PsiExpression>
implements TypedLookupItem {
    public ExpressionLookupItem(PsiExpression expression) {
        super(expression, expression.getText());
        PsiReferenceExpression referenceExpression;
        PsiElement element;
        if (expression instanceof PsiReferenceExpression && (element = (referenceExpression = (PsiReferenceExpression)expression).resolve()) != null) {
            this.setIcon(element.getIcon(0));
        }
        if (expression instanceof PsiMethodCallExpression) {
            this.setIcon(PlatformIcons.METHOD_ICON);
        }
    }

    @Override
    public PsiType getType() {
        return ((PsiExpression)this.getObject()).getType();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ExpressionLookupItem && this.getLookupString().equals(((ExpressionLookupItem)o).getLookupString());
    }

    @Override
    public int hashCode() {
        return this.getLookupString().hashCode();
    }
}

