/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.actions.InspectionListCellRenderer;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ListCellRenderer;

public class GotoInspectionModel
extends SimpleChooseByNameModel {
    private static final InspectionToolWrapper[] EMPTY_WRAPPERS_ARRAY = new InspectionToolWrapper[0];
    private final Map<String, InspectionToolWrapper> myToolNames = new HashMap<String, InspectionToolWrapper>();
    private final String[] myNames;
    private final InspectionListCellRenderer myListCellRenderer = new InspectionListCellRenderer();

    public GotoInspectionModel(Project project) {
        super(project, IdeBundle.message((String)"prompt.goto.inspection.enter.name", (Object[])new Object[0]), "goto.inspection.help.id");
        InspectionProfileImpl rootProfile = (InspectionProfileImpl)InspectionProfileManager.getInstance().getRootProfile();
        for (ScopeToolState state : rootProfile.getAllTools(project)) {
            InspectionToolWrapper tool = state.getTool();
            if (tool instanceof LocalInspectionToolWrapper && ((LocalInspectionToolWrapper)tool).isUnfair()) continue;
            String name = tool.getDisplayName() + " " + StringUtil.join((String[])tool.getGroupPath(), (String)" ");
            this.myToolNames.put(name, tool);
        }
        Set<String> strings = this.myToolNames.keySet();
        this.myNames = strings.toArray(new String[strings.size()]);
    }

    public ListCellRenderer getListCellRenderer() {
        return this.myListCellRenderer;
    }

    @Override
    public String[] getNames() {
        return this.myNames;
    }

    @Override
    public Object[] getElementsByName(String name, String pattern) {
        InspectionToolWrapper tool = this.myToolNames.get(name);
        if (tool == null) {
            return EMPTY_WRAPPERS_ARRAY;
        }
        return new InspectionToolWrapper[]{tool};
    }

    public String getElementName(Object element) {
        if (element instanceof InspectionToolWrapper) {
            InspectionToolWrapper entry = (InspectionToolWrapper)element;
            return entry.getDisplayName() + " " + StringUtil.join((String[])entry.getGroupPath(), (String)" ");
        }
        return null;
    }
}

