/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefMethodImpl
extends RefJavaElementImpl
implements RefMethod {
    private static final List<RefMethod> EMPTY_METHOD_LIST = Collections.emptyList();
    private static final RefParameter[] EMPTY_PARAMS_ARRAY = new RefParameter[0];
    private static final int IS_APPMAIN_MASK = 65536;
    private static final int IS_LIBRARY_OVERRIDE_MASK = 131072;
    private static final int IS_CONSTRUCTOR_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_BODY_EMPTY_MASK = 0x100000;
    private static final int IS_ONLY_CALLS_SUPER_MASK = 0x200000;
    private static final int IS_RETURN_VALUE_USED_MASK = 0x400000;
    private static final int IS_TEST_METHOD_MASK = 0x4000000;
    private static final int IS_CALLED_ON_SUBCLASS = 0x8000000;
    private static final String RETURN_VALUE_UNDEFINED = "#";
    private List<RefMethod> mySuperMethods;
    private List<RefMethod> myDerivedMethods;
    private List<String> myUnThrownExceptions;
    private RefParameter[] myParameters;
    private String myReturnValueTemplate;
    protected final RefClass myOwnerClass;

    RefMethodImpl(@NotNull RefClass ownerClass, PsiMethod method, RefManager manager) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reference/RefMethodImpl", "<init>"));
        }
        super((PsiModifierListOwner)method, manager);
        ((RefClassImpl)ownerClass).add(this);
        this.myOwnerClass = ownerClass;
    }

    protected RefMethodImpl(String name, @NotNull RefClass ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/codeInspection/reference/RefMethodImpl", "<init>"));
        }
        super(name, (RefJavaElement)ownerClass);
        this.myOwnerClass = ownerClass;
        ((RefClassImpl)ownerClass).add(this);
        this.addOutReference((RefElement)this.getOwnerClass());
        ((RefClassImpl)this.getOwnerClass()).addInReference(this);
        this.setConstructor(true);
    }

    @Override
    public void add(RefEntity child) {
        if (child instanceof RefParameter) {
            return;
        }
        super.add(child);
    }

    @Override
    public List<RefEntity> getChildren() {
        List<RefEntity> superChildren = super.getChildren();
        if (this.myParameters == null) {
            return superChildren;
        }
        if (superChildren == null || superChildren.isEmpty()) {
            return Arrays.asList(this.myParameters);
        }
        ArrayList<RefEntity> allChildren = new ArrayList<RefEntity>(superChildren.size() + this.myParameters.length);
        allChildren.addAll(superChildren);
        Collections.addAll(allChildren, this.myParameters);
        return allChildren;
    }

    @Override
    protected void initialize() {
        PsiParameter[] paramList;
        PsiMethod method = (PsiMethod)this.getElement();
        LOG.assertTrue(method != null);
        this.setConstructor(method.isConstructor());
        PsiType returnType = method.getReturnType();
        this.setFlag(returnType == null || PsiType.VOID.equals((Object)returnType) || returnType.equalsToText("java.lang.Void"), 0x400000);
        if (!this.isReturnValueUsed()) {
            this.myReturnValueTemplate = RETURN_VALUE_UNDEFINED;
        }
        if (this.isConstructor()) {
            this.addReference((RefElement)this.getOwnerClass(), (PsiElement)this.getOwnerClass().getElement(), (PsiElement)method, false, true, null);
        }
        if (this.getOwnerClass().isInterface()) {
            this.setAbstract(false);
        } else {
            this.setAbstract(method.hasModifierProperty("abstract"));
        }
        this.setAppMain(RefMethodImpl.isAppMain(method, this));
        this.setLibraryOverride(method.hasModifierProperty("native"));
        this.initializeSuperMethods(method);
        if (this.isExternalOverride()) {
            ((RefClassImpl)this.getOwnerClass()).addLibraryOverrideMethod(this);
        }
        String name = method.getName();
        if (this.getOwnerClass().isTestCase() && name.startsWith("test")) {
            this.setTestMethod(true);
        }
        if ((paramList = method.getParameterList().getParameters()).length > 0) {
            this.myParameters = new RefParameterImpl[paramList.length];
            for (int i = 0; i < paramList.length; ++i) {
                PsiParameter parameter = paramList[i];
                this.myParameters[i] = this.getRefJavaManager().getParameterReference(parameter, i);
            }
        }
        if (method.hasModifierProperty("native")) {
            this.updateReturnValueTemplate(null);
            this.updateThrowsList(null);
        }
        this.collectUncaughtExceptions(method);
    }

    private static boolean isAppMain(PsiMethod psiMethod, RefMethod refMethod) {
        if (!refMethod.isStatic()) {
            return false;
        }
        if (!PsiType.VOID.equals((Object)psiMethod.getReturnType())) {
            return false;
        }
        PsiMethod appMainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppMainPattern();
        if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appMainPattern)) {
            return true;
        }
        PsiMethod appPremainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppPremainPattern();
        if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appPremainPattern)) {
            return true;
        }
        PsiMethod appAgentmainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppAgentmainPattern();
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appAgentmainPattern);
    }

    private void checkForSuperCall(PsiMethod method) {
        if (this.isConstructor()) {
            String text;
            PsiExpression qualifierExpression;
            PsiExpression firstExpression;
            PsiStatement first;
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            boolean isBaseExplicitlyCalled = false;
            if (statements.length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (firstExpression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && (qualifierExpression = ((PsiMethodCallExpression)firstExpression).getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression && ("super".equals(text = qualifierExpression.getText()) || text.equals("this"))) {
                isBaseExplicitlyCalled = true;
            }
            if (!isBaseExplicitlyCalled) {
                for (RefClass superClass : this.getOwnerClass().getBaseClasses()) {
                    RefMethodImpl superDefaultConstructor = (RefMethodImpl)superClass.getDefaultConstructor();
                    if (superDefaultConstructor == null) continue;
                    superDefaultConstructor.addInReference(this);
                    this.addOutReference(superDefaultConstructor);
                }
            }
        }
    }

    @NotNull
    public Collection<RefMethod> getSuperMethods() {
        if (this.mySuperMethods == null) {
            List<RefMethod> list = EMPTY_METHOD_LIST;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getSuperMethods"));
            }
            return list;
        }
        if (this.mySuperMethods.size() > 10) {
            LOG.info("method: " + this.getName() + " owner:" + this.getOwnerClass().getQualifiedName());
        }
        List<RefMethod> list = this.mySuperMethods;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getSuperMethods"));
        }
        return list;
    }

    @NotNull
    public Collection<RefMethod> getDerivedMethods() {
        if (this.myDerivedMethods == null) {
            List<RefMethod> list = EMPTY_METHOD_LIST;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getDerivedMethods"));
            }
            return list;
        }
        List<RefMethod> list = this.myDerivedMethods;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getDerivedMethods"));
        }
        return list;
    }

    public boolean isBodyEmpty() {
        return this.checkFlag(0x100000);
    }

    public boolean isOnlyCallsSuper() {
        return this.checkFlag(0x200000);
    }

    public boolean hasBody() {
        return !this.isAbstract() && !this.getOwnerClass().isInterface() || !this.isBodyEmpty();
    }

    private void initializeSuperMethods(PsiMethod method) {
        for (PsiMethod psiSuperMethod : method.findSuperMethods()) {
            if (this.getRefManager().belongsToScope((PsiElement)psiSuperMethod)) {
                RefMethodImpl refSuperMethod = (RefMethodImpl)this.getRefManager().getReference((PsiElement)psiSuperMethod);
                if (refSuperMethod == null) continue;
                this.addSuperMethod(refSuperMethod);
                refSuperMethod.markExtended(this);
                continue;
            }
            this.setLibraryOverride(true);
        }
    }

    public void addSuperMethod(RefMethodImpl refSuperMethod) {
        if (!this.getSuperMethods().contains(refSuperMethod) && !refSuperMethod.getSuperMethods().contains(this)) {
            if (this.mySuperMethods == null) {
                this.mySuperMethods = new ArrayList<RefMethod>(1);
            }
            this.mySuperMethods.add(refSuperMethod);
        }
    }

    public void markExtended(RefMethodImpl method) {
        if (!this.getDerivedMethods().contains(method) && !method.getDerivedMethods().contains(this)) {
            if (this.myDerivedMethods == null) {
                this.myDerivedMethods = new ArrayList<RefMethod>(1);
            }
            this.myDerivedMethods.add(method);
        }
    }

    @NotNull
    public RefParameter[] getParameters() {
        if (this.myParameters == null) {
            if (EMPTY_PARAMS_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getParameters"));
            }
            return EMPTY_PARAMS_ARRAY;
        }
        if (this.myParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getParameters"));
        }
        return this.myParameters;
    }

    @Override
    public void buildReferences() {
        PsiMethod method = (PsiMethod)this.getElement();
        if (method == null) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        refUtil.addReferences((PsiModifierListOwner)method, (RefJavaElement)this, (PsiElement)body);
        refUtil.addReferences((PsiModifierListOwner)method, (RefJavaElement)this, (PsiElement)method.getModifierList());
        this.checkForSuperCall(method);
        this.setOnlyCallsSuper(refUtil.isMethodOnlyCallsSuper(method));
        this.setBodyEmpty(this.isOnlyCallsSuper() || !this.isExternalOverride() && (body == null || body.getStatements().length == 0));
        PsiType retType = method.getReturnType();
        if (retType != null) {
            RefClassImpl refClass;
            PsiClass psiClass;
            PsiType psiType = retType;
            RefClass ownerClass = refUtil.getOwnerClass((RefManager)this.getRefManager(), (PsiElement)method);
            if (ownerClass != null && (psiType = psiType.getDeepComponentType()) instanceof PsiClassType && (psiClass = PsiUtil.resolveClassInType((PsiType)psiType)) != null && this.getRefManager().belongsToScope((PsiElement)psiClass) && (refClass = (RefClassImpl)this.getRefManager().getReference((PsiElement)psiClass)) != null) {
                refClass.addTypeReference((RefJavaElement)ownerClass);
                refClass.addClassExporter(this);
            }
        }
        for (RefParameter parameter : this.getParameters()) {
            refUtil.setIsFinal((RefJavaElement)parameter, parameter.getElement().hasModifierProperty("final"));
        }
        this.getRefManager().fireBuildReferences(this);
    }

    private void collectUncaughtExceptions(@NotNull PsiMethod method) {
        PsiCodeBlock body;
        PsiClassType[] throwsList;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/reference/RefMethodImpl", "collectUncaughtExceptions"));
        }
        if (this.isExternalOverride()) {
            return;
        }
        String name = method.getName();
        if (this.getOwnerClass().isTestCase() && name.startsWith("test")) {
            return;
        }
        if (this.getSuperMethods().isEmpty() && (throwsList = method.getThrowsList().getReferencedTypes()).length > 0) {
            this.myUnThrownExceptions = throwsList.length == 1 ? new SmartList() : new ArrayList(throwsList.length);
            for (PsiClassType type : throwsList) {
                String fqn;
                PsiClass aClass = type.resolve();
                String string = fqn = aClass == null ? null : aClass.getQualifiedName();
                if (fqn == null) continue;
                this.myUnThrownExceptions.add(fqn);
            }
        }
        if ((body = method.getBody()) == null) {
            return;
        }
        Collection<PsiClassType> exceptionTypes = ExceptionUtil.collectUnhandledExceptions((PsiElement)body, (PsiElement)method, false);
        for (PsiClassType exceptionType : exceptionTypes) {
            this.updateThrowsList(exceptionType);
        }
    }

    public void removeUnThrownExceptions(PsiClass unThrownException) {
        if (this.myUnThrownExceptions != null) {
            this.myUnThrownExceptions.remove(unThrownException.getQualifiedName());
        }
    }

    @Override
    public void accept(final @NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefMethodImpl", "accept"));
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    ((RefJavaVisitor)visitor).visitMethod((RefMethod)RefMethodImpl.this);
                }
            });
        } else {
            super.accept(visitor);
        }
    }

    public boolean isExternalOverride() {
        return this.isLibraryOverride(new HashSet<RefMethod>());
    }

    private boolean isLibraryOverride(Collection<RefMethod> processed) {
        if (processed.contains(this)) {
            return false;
        }
        processed.add(this);
        if (this.checkFlag(131072)) {
            return true;
        }
        for (RefMethod superMethod : this.getSuperMethods()) {
            if (!((RefMethodImpl)superMethod).isLibraryOverride(processed)) continue;
            this.setFlag(true, 131072);
            return true;
        }
        return false;
    }

    public boolean isAppMain() {
        return this.checkFlag(65536);
    }

    public boolean isAbstract() {
        return this.checkFlag(524288);
    }

    public boolean hasSuperMethods() {
        return !this.getSuperMethods().isEmpty() || this.isExternalOverride();
    }

    @Override
    public boolean isReferenced() {
        for (RefElement refCaller : this.getInReferences()) {
            if (this.getDerivedMethods().contains(refCaller)) continue;
            return true;
        }
        return this.isExternalOverride();
    }

    @Override
    public boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious() || this.getDerivedMethods().contains(refCaller)) continue;
            return true;
        }
        if (this.isExternalOverride()) {
            return true;
        }
        if (!this.isStatic() && !this.isConstructor()) {
            if (((RefClassImpl)this.getOwnerClass()).isSuspicious()) {
                return true;
            }
            for (RefMethod refSuper : this.getSuperMethods()) {
                if (!((RefMethodImpl)refSuper).isSuspicious()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConstructor() {
        return this.checkFlag(262144);
    }

    public RefClass getOwnerClass() {
        return (RefClass)this.getOwner();
    }

    @Override
    @NotNull
    public String getName() {
        if (this.isValid()) {
            final String[] result = new String[1];
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PsiMethod psiMethod = (PsiMethod)RefMethodImpl.this.getElement();
                    result[0] = psiMethod instanceof SyntheticElement ? psiMethod.getName() : PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
                }
            };
            ApplicationManager.getApplication().runReadAction(runnable);
            String string = result[0];
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getName"));
            }
            return string;
        }
        String string = super.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefMethodImpl", "getName"));
        }
        return string;
    }

    @Override
    public String getExternalName() {
        final String[] result = new String[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PsiMethod psiMethod = (PsiMethod)RefMethodImpl.this.getElement();
                RefElementImpl.LOG.assertTrue(psiMethod != null);
                result[0] = PsiFormatUtil.getExternalName((PsiModifierListOwner)psiMethod);
            }
        };
        ApplicationManager.getApplication().runReadAction(runnable);
        return result[0];
    }

    @Nullable
    public static RefMethod methodFromExternalName(RefManager manager, String externalName) {
        return (RefMethod)manager.getReference((PsiElement)RefMethodImpl.findPsiMethod(PsiManager.getInstance((Project)manager.getProject()), externalName));
    }

    @Nullable
    public static PsiMethod findPsiMethod(PsiManager manager, String externalName) {
        int spaceIdx = externalName.indexOf(32);
        String className = externalName.substring(0, spaceIdx);
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)className);
        if (psiClass == null) {
            return null;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory();
            String methodSignature = externalName.substring(spaceIdx + 1);
            PsiMethod patternMethod = factory.createMethodFromText(methodSignature, (PsiElement)psiClass);
            return psiClass.findMethodBySignature(patternMethod, false);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public void referenceRemoved() {
        if (this.getOwnerClass() != null) {
            ((RefClassImpl)this.getOwnerClass()).methodRemoved(this);
        }
        super.referenceRemoved();
        for (RefMethod superMethod : this.getSuperMethods()) {
            superMethod.getDerivedMethods().remove(this);
        }
        for (RefMethod subMethod : this.getDerivedMethods()) {
            subMethod.getSuperMethods().remove(this);
        }
        ArrayList<RefElement> deletedRefs = new ArrayList<RefElement>();
        for (RefParameter parameter : this.getParameters()) {
            this.getRefManager().removeRefElement((RefElement)parameter, deletedRefs);
        }
    }

    @Override
    public boolean isSuspicious() {
        if (this.isConstructor() && "private".equals(this.getAccessModifier()) && this.getParameters().length == 0 && this.getOwnerClass().getConstructors().size() == 1) {
            return false;
        }
        return super.isSuspicious();
    }

    public void setReturnValueUsed(boolean value) {
        if (this.checkFlag(0x400000) == value) {
            return;
        }
        this.setFlag(value, 0x400000);
        for (RefMethod refSuper : this.getSuperMethods()) {
            ((RefMethodImpl)refSuper).setReturnValueUsed(value);
        }
    }

    public boolean isReturnValueUsed() {
        return this.checkFlag(0x400000);
    }

    public void updateReturnValueTemplate(PsiExpression expression) {
        if (this.myReturnValueTemplate == null) {
            return;
        }
        if (!this.getSuperMethods().isEmpty()) {
            for (RefMethod refMethod : this.getSuperMethods()) {
                RefMethodImpl refSuper = (RefMethodImpl)refMethod;
                refSuper.updateReturnValueTemplate(expression);
            }
        } else {
            String newTemplate = null;
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (expression instanceof PsiLiteralExpression) {
                PsiLiteralExpression psiLiteralExpression = (PsiLiteralExpression)expression;
                newTemplate = psiLiteralExpression.getText();
            } else if (expression instanceof PsiReferenceExpression) {
                PsiField psiField;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiElement resolved = referenceExpression.resolve();
                if (resolved instanceof PsiField && (psiField = (PsiField)resolved).hasModifierProperty("static") && psiField.hasModifierProperty("final") && refUtil.compareAccess(refUtil.getAccessModifier((PsiModifierListOwner)psiField), this.getAccessModifier()) >= 0) {
                    newTemplate = PsiFormatUtil.formatVariable((PsiVariable)psiField, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                }
            } else if (refUtil.isCallToSuperMethod(expression, (PsiMethod)this.getElement())) {
                return;
            }
            if (this.myReturnValueTemplate == RETURN_VALUE_UNDEFINED) {
                this.myReturnValueTemplate = newTemplate;
            } else if (!Comparing.equal((String)this.myReturnValueTemplate, (String)newTemplate)) {
                this.myReturnValueTemplate = null;
            }
        }
    }

    public void updateParameterValues(PsiExpression[] args) {
        block4: {
            block3: {
                if (this.isExternalOverride()) {
                    return;
                }
                if (this.getSuperMethods().isEmpty()) break block3;
                for (RefMethod refSuper : this.getSuperMethods()) {
                    ((RefMethodImpl)refSuper).updateParameterValues(args);
                }
                break block4;
            }
            RefParameter[] params = this.getParameters();
            if (params.length > args.length || params.length <= 0) break block4;
            for (int i = 0; i < args.length; ++i) {
                RefParameter refParameter = params.length <= i ? params[params.length - 1] : params[i];
                ((RefParameterImpl)refParameter).updateTemplateValue(args[i]);
            }
        }
    }

    public String getReturnValueIfSame() {
        if (this.myReturnValueTemplate == RETURN_VALUE_UNDEFINED) {
            return null;
        }
        return this.myReturnValueTemplate;
    }

    public void updateThrowsList(PsiClassType exceptionType) {
        if (!this.getSuperMethods().isEmpty()) {
            for (RefMethod refSuper : this.getSuperMethods()) {
                ((RefMethodImpl)refSuper).updateThrowsList(exceptionType);
            }
        } else if (this.myUnThrownExceptions != null) {
            if (exceptionType == null) {
                this.myUnThrownExceptions = null;
                return;
            }
            PsiClass exceptionClass = exceptionType.resolve();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
            for (int i = this.myUnThrownExceptions.size() - 1; i >= 0; --i) {
                String exceptionFqn = this.myUnThrownExceptions.get(i);
                PsiClass classType = facade.findClass(exceptionFqn, GlobalSearchScope.allScope((Project)this.getRefManager().getProject()));
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)exceptionClass, (PsiClass)classType, (boolean)true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)classType, (PsiClass)exceptionClass, (boolean)true)) continue;
                this.myUnThrownExceptions.remove(i);
            }
            if (this.myUnThrownExceptions.isEmpty()) {
                this.myUnThrownExceptions = null;
            }
        }
    }

    @Nullable
    public PsiClass[] getUnThrownExceptions() {
        if (this.myUnThrownExceptions == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(this.myUnThrownExceptions.size());
        for (String exception : this.myUnThrownExceptions) {
            PsiClass element = facade.findClass(exception, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
            if (element == null) continue;
            result.add(element);
        }
        return result.toArray(new PsiClass[result.size()]);
    }

    public void setLibraryOverride(boolean libraryOverride) {
        this.setFlag(libraryOverride, 131072);
    }

    private void setAppMain(boolean appMain) {
        this.setFlag(appMain, 65536);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288);
    }

    public void setBodyEmpty(boolean bodyEmpty) {
        this.setFlag(bodyEmpty, 0x100000);
    }

    private void setOnlyCallsSuper(boolean onlyCallsSuper) {
        this.setFlag(onlyCallsSuper, 0x200000);
    }

    private void setConstructor(boolean constructor) {
        this.setFlag(constructor, 262144);
    }

    public boolean isTestMethod() {
        return this.checkFlag(0x4000000);
    }

    private void setTestMethod(boolean testMethod) {
        this.setFlag(testMethod, 0x4000000);
    }

    public PsiModifierListOwner getElement() {
        return (PsiModifierListOwner)super.getElement();
    }

    public boolean isCalledOnSubClass() {
        return this.checkFlag(0x8000000);
    }

    public void setCalledOnSubClass(boolean isCalledOnSubClass) {
        this.setFlag(isCalledOnSubClass, 0x8000000);
    }
}

