/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Value;

public class AssignmentEvaluator
implements Evaluator {
    private final Evaluator myLeftEvaluator;
    private final Evaluator myRightEvaluator;

    public AssignmentEvaluator(Evaluator leftEvaluator, Evaluator rightEvaluator) {
        this.myLeftEvaluator = leftEvaluator;
        this.myRightEvaluator = new DisableGC(rightEvaluator);
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        this.myLeftEvaluator.evaluate(context);
        Modifier modifier = this.myLeftEvaluator.getModifier();
        Object right = this.myRightEvaluator.evaluate(context);
        if (right != null && !(right instanceof Value)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.not.rvalue", (Object[])new Object[0]));
        }
        AssignmentEvaluator.assign(modifier, right, context);
        return right;
    }

    static void assign(Modifier modifier, Object right, EvaluationContextImpl context) throws EvaluateException {
        if (modifier == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.not.lvalue", (Object[])new Object[0]));
        }
        try {
            modifier.setValue((Value)right);
        }
        catch (ClassNotLoadedException e) {
            if (!context.isAutoLoadClasses()) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            try {
                context.getDebugProcess().loadClass(context, e.className(), context.getClassLoader());
            }
            catch (InvocationException e1) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e1);
            }
            catch (ClassNotLoadedException e1) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e1);
            }
            catch (IncompatibleThreadStateException e1) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e1);
            }
            catch (InvalidTypeException e1) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e1);
            }
        }
        catch (InvalidTypeException e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
    }

    @Override
    public Modifier getModifier() {
        return this.myLeftEvaluator.getModifier();
    }
}

