/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.CustomPopupFullValueEvaluator;
import com.intellij.debugger.settings.ImageObjectRenderer;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IconUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class IconObjectRenderer
extends CompoundReferenceRenderer
implements FullValueEvaluatorProvider {
    public IconObjectRenderer(NodeRendererSettings rendererSettings) {
        super(rendererSettings, "Icon", null, null);
        this.setClassName("javax.swing.Icon");
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        String res = this.calcToStringLabel(descriptor, evaluationContext, listener);
        if (res != null) {
            return res;
        }
        return super.calcLabel(descriptor, evaluationContext, listener);
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        ImageIcon icon = ImageObjectRenderer.getIcon(evaluationContext, descriptor.getValue(), "iconToBytes");
        if (icon != null) {
            return IconUtil.cropIcon((Icon)icon, (int)16, (int)16);
        }
        return null;
    }

    @Override
    @NotNull
    public XFullValueEvaluator getFullValueEvaluator(EvaluationContextImpl evaluationContext, final ValueDescriptorImpl valueDescriptor) {
        CustomPopupFullValueEvaluator customPopupFullValueEvaluator = new CustomPopupFullValueEvaluator(" (Show icon)", evaluationContext){

            @Override
            protected JComponent createComponent() {
                return new JBLabel((Icon)ImageObjectRenderer.getIcon(this.myEvaluationContext, valueDescriptor.getValue(), "iconToBytes"));
            }
        };
        if (customPopupFullValueEvaluator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/IconObjectRenderer", "getFullValueEvaluator"));
        }
        return customPopupFullValueEvaluator;
    }
}

