/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VoidType;
import org.jetbrains.annotations.NonNls;

public class PrimitiveRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "PrimitiveRenderer";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.PrimitiveRenderer");

    public PrimitiveRenderer() {
        super("Primitive");
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public void setName(String text) {
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isApplicable(Type type) {
        return type == null || type instanceof PrimitiveType || type instanceof VoidType;
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof PrimitiveValue) {
            StringBuilder buf = new StringBuilder(16);
            if (value instanceof CharValue) {
                buf.append("'");
                buf.append(DebuggerUtils.translateStringValue((String)value.toString()));
                buf.append("' ");
                long longValue = ((PrimitiveValue)value).longValue();
                buf.append(Long.toString(longValue));
            } else if (value instanceof ByteValue) {
                buf.append(value.toString());
            } else if (value instanceof ShortValue) {
                buf.append(value.toString());
            } else if (value instanceof IntegerValue) {
                buf.append(value.toString());
            } else if (value instanceof LongValue) {
                buf.append(value.toString());
            } else {
                buf.append(value.toString());
            }
            return buf.toString();
        }
        return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
    }

    @Override
    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) {
        LOG.assertTrue(false);
        return null;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }
}

