/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

class LoadingIcon
extends JBImageIcon {
    private static final String LOADING_ICON = "/icons/loading.gif";
    private static final Logger LOG = Logger.getInstance(LoadingIcon.class);
    private final int myWidth;
    private final int myHeight;
    private final int myDeltaX;
    private final int myDeltaY;

    LoadingIcon(@NotNull Image image, int width, int height) {
        if (image == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/dvcs/push/ui/LoadingIcon", "<init>"));
        }
        super(image);
        int myOriginalWidth = image.getWidth(null);
        int myOriginalHeight = image.getHeight(null);
        this.myWidth = Math.max(width, myOriginalWidth);
        this.myHeight = Math.max(height, myOriginalHeight);
        this.myDeltaX = (this.myWidth - myOriginalWidth) / 2 - 2;
        this.myDeltaY = (this.myHeight - myOriginalHeight) / 2 + 2;
    }

    @NotNull
    static LoadingIcon create(int width, int height) {
        Image image = ImageLoader.loadFromResource((String)LOADING_ICON);
        if (image == null) {
            LOG.error("Couldn't load image: /icons/loading.gif");
            LoadingIcon loadingIcon = LoadingIcon.createEmpty(width, height);
            if (loadingIcon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/LoadingIcon", "create"));
            }
            return loadingIcon;
        }
        LoadingIcon loadingIcon = new LoadingIcon(image, width, height);
        if (loadingIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/LoadingIcon", "create"));
        }
        return loadingIcon;
    }

    @NotNull
    static LoadingIcon createEmpty(int width, int height) {
        LoadingIcon loadingIcon = new LoadingIcon(UIUtil.createImage((int)width, (int)height, (int)3), width, height);
        if (loadingIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/LoadingIcon", "createEmpty"));
        }
        return loadingIcon;
    }

    void setObserver(@NotNull JTree tree, @NotNull TreeNode treeNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/dvcs/push/ui/LoadingIcon", "setObserver"));
        }
        if (treeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNode", "com/intellij/dvcs/push/ui/LoadingIcon", "setObserver"));
        }
        this.setImageObserver(new NodeImageObserver(tree, treeNode));
    }

    public final synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x + this.myDeltaX, y + this.myDeltaY);
    }

    public int getIconHeight() {
        return this.myHeight;
    }

    public int getIconWidth() {
        return this.myWidth;
    }

    private static class NodeImageObserver
    implements ImageObserver {
        @NotNull
        private final JTree myTree;
        @NotNull
        private final DefaultTreeModel myModel;
        @NotNull
        private final TreeNode myNode;

        NodeImageObserver(@NotNull JTree tree, @NotNull TreeNode node) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/dvcs/push/ui/LoadingIcon$NodeImageObserver", "<init>"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/ui/LoadingIcon$NodeImageObserver", "<init>"));
            }
            this.myTree = tree;
            this.myModel = (DefaultTreeModel)tree.getModel();
            this.myNode = node;
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
            TreePath path;
            Rectangle rect;
            Object[] pathToRoot;
            if ((flags & 0x30) != 0 && (pathToRoot = this.myModel.getPathToRoot(this.myNode)) != null && (rect = this.myTree.getPathBounds(path = new TreePath(pathToRoot))) != null) {
                this.myTree.repaint(rect);
            }
            return (flags & 0xA0) == 0;
        }
    }
}

