/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.LoadingIcon;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SingleRepositoryNode
extends RepositoryNode {
    @NotNull
    private final RepositoryWithBranchPanel myRepositoryPanel;
    private final LoadingIcon myEmptyIcon;

    public SingleRepositoryNode(@NotNull RepositoryWithBranchPanel repositoryPanel) {
        if (repositoryPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryPanel", "com/intellij/dvcs/push/ui/SingleRepositoryNode", "<init>"));
        }
        super(repositoryPanel, true);
        this.myRepositoryPanel = repositoryPanel;
        this.myEmptyIcon = LoadingIcon.createEmpty(this.myLoadingIcon.getIconWidth(), this.myLoadingIcon.getIconHeight());
    }

    @Override
    public boolean isCheckboxVisible() {
        return false;
    }

    public boolean isChecked() {
        return true;
    }

    @Override
    public void fireOnSelectionChange(boolean isSelected) {
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/dvcs/push/ui/SingleRepositoryNode", "render"));
        }
        renderer.setIcon((Icon)((Object)(this.myLoading.get() ? this.myLoadingIcon : this.myEmptyIcon)));
        renderer.setIconOnTheRight(false);
        renderer.append("");
        renderer.appendFixedTextFragmentWidth(this.myLoadingIconWidth);
        renderer.append(this.myRepositoryPanel.getSourceName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(this.myRepositoryPanel.getArrow(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        PushTargetPanel pushTargetPanel = this.myRepositoryPanel.getTargetPanel();
        pushTargetPanel.render(renderer);
    }
}

