/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.VcsLinkedText;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class TextWithLinkNode
extends DefaultMutableTreeNode
implements CustomRenderedTreeNode {
    @NotNull
    protected VcsLinkedText myLinkedText;

    public TextWithLinkNode(@NotNull VcsLinkedText linkedText) {
        if (linkedText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkedText", "com/intellij/dvcs/push/ui/TextWithLinkNode", "<init>"));
        }
        this.myLinkedText = linkedText;
    }

    public void fireOnClick(@NotNull TextWithLinkNode relatedNode) {
        if (relatedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relatedNode", "com/intellij/dvcs/push/ui/TextWithLinkNode", "fireOnClick"));
        }
        TreeNode parent = relatedNode.getParent();
        if (parent instanceof RepositoryNode) {
            this.myLinkedText.hyperLinkActivate((DefaultMutableTreeNode)((Object)((RepositoryNode)((Object)parent))));
        }
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/dvcs/push/ui/TextWithLinkNode", "render"));
        }
        renderer.append(this.myLinkedText.getTextBefore(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String linkedText = this.myLinkedText.getLinkText();
        if (!StringUtil.isEmptyOrSpaces((String)linkedText)) {
            renderer.append(" ");
            renderer.append(this.myLinkedText.getLinkText(), SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (Object)this);
        }
        renderer.append(this.myLinkedText.getTextAfter(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }
}

